<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <title>مفردات مرتب - <?php echo e($employee->arabic_name); ?></title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 20px;
            direction: rtl;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .info-table,
        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .info-table th,
        .info-table td {
            text-align: right;
            padding: 8px;
            border: 1px solid #eee;
        }

        .data-table th,
        .data-table td {
            border: 1px solid #333;
            padding: 10px;
            text-align: center;
        }

        .data-table th {
            bg-color: #f5f5f5;
        }

        .signature {
            margin-top: 50px;
            text-align: left;
            padding-left: 50px;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                margin: 0;
            }
        }
    </style>
</head>

<body onload="window.print()">
    <div class="header">
        <h1>مفردات مرتب</h1>
        <p>شهر: <?php echo e($month); ?> / <?php echo e(date('Y')); ?></p>
    </div>

    <table class="info-table">
        <tr>
            <th>رقم الموظف:</th>
            <td><?php echo e($employee->emp_id); ?></td>
            <th>اسم الموظف:</th>
            <td><?php echo e($employee->arabic_name); ?></td>
        </tr>
        <tr>
            <th>الوظيفة:</th>
            <td><?php echo e($employee->job); ?></td>
            <th>مقر العمل:</th>
            <td><?php echo e($employee->job_place); ?></td>
        </tr>
    </table>

    <?php
        $salary = $employee->salaries->first();
        $base = $employee->salary;
        $incentive = $salary->incentive ?? 0;
        $meal = $salary->meal ?? 0;
        $extra = $salary->extra ?? 0;
        $transp = $salary->transp ?? 0;
        $absence = $salary->absence ?? 0;
        $loans = $salary->loans ?? 0;
        $total = ($base + $incentive + $meal + $extra + $transp) - ($absence + $loans);
    ?>

    <table class="data-table">
        <thead>
            <tr>
                <th>الراتب الأساسي</th>
                <th>الإضافي</th>
                <th>الإنتقالات</th>
                <th>الحوافز</th>
                <th>الوجبة</th>
                <th>الغياب</th>
                <th>السلف</th>
                <th>الإجمالي</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php echo e(number_format($base)); ?></td>
                <td><?php echo e(number_format($extra)); ?></td>
                <td><?php echo e(number_format($transp)); ?></td>
                <td><?php echo e(number_format($incentive)); ?></td>
                <td><?php echo e(number_format($meal)); ?></td>
                <td><?php echo e(number_format($absence)); ?></td>
                <td><?php echo e(number_format($loans)); ?></td>
                <td style="font-weight: bold;"><?php echo e(number_format($total)); ?> EGP</td>
            </tr>
        </tbody>
    </table>

    <?php if(($options['pr_x'] ?? '1') == '1'): ?>
        <div style="margin-top: 20px; font-size: 14px; line-height: 1.6;">
            <p>أقر أنا الموضح بياناته أعلاه بأنني استلمت كافة مستحقاتي المالية عن شهر <?php echo e($month); ?> لعام <?php echo e(date('Y')); ?> وليس
                لي أي مطالبات أخرى لدى الشركة.</p>
        </div>
    <?php endif; ?>

    <div style="margin-top: 40px; display: flex; justify-content: space-between;">
        <?php if(($options['emp_x'] ?? '1') == '1'): ?>
            <div style="text-align: center;">
                <p>توقيع الموظف:</p>
                <br>
                __________________
            </div>
        <?php endif; ?>

        <?php if(($options['sign_x'] ?? '1') == '1'): ?>
            <div style="text-align: center;">
                <p>يعتمد،، المديرة الإدارية</p>
                <br>
                __________________
            </div>
        <?php endif; ?>
    </div>

    <div class="no-print" style="margin-top: 20px; text-align: center;">
        <button onclick="window.print()" style="padding: 10px 20px; cursor: pointer;">طباعة</button>
        <button onclick="window.close()" style="padding: 10px 20px; cursor: pointer;">إغلاق</button>
    </div>
</body>

</html><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/hr/print_salary.blade.php ENDPATH**/ ?>