

<?php $__env->startSection('header', 'Pricing: ' . $flat->txt); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-5xl mx-auto">
        <div class="flex justify-between items-center mb-6">
            <div>
                <nav class="flex text-sm text-gray-500 mb-2" aria-label="Breadcrumb">
                    <ol class="flex items-center space-x-2">
                        <li><a href="<?php echo e(route('inventory.projects')); ?>" class="hover:text-primary">Projects</a></li>
                        <li><svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z"
                                    clip-rule="evenodd"></path>
                            </svg></li>
                        <li><a href="<?php echo e(route('inventory.flats', $project->prj_id)); ?>" class="hover:text-primary">Units</a>
                        </li>
                        <li><svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z"
                                    clip-rule="evenodd"></path>
                            </svg></li>
                        <li class="text-gray-900 font-medium">Installment Table</li>
                    </ol>
                </nav>
                <h2 class="text-2xl font-bold text-gray-800">Installment Schedule</h2>
                <p class="text-sm text-gray-500 mt-1">Project: <?php echo e($project->name); ?> | Unit: <?php echo e($flat->txt); ?>

                    (<?php echo e($flat->area); ?>)</p>
            </div>
            <div class="flex items-center gap-3">
                <button onclick="document.getElementById('importModal').classList.remove('hidden')"
                    class="bg-white border border-gray-200 text-gray-700 hover:bg-gray-50 px-4 py-2 rounded-xl transition-all flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12">
                        </path>
                    </svg>
                    Import Excel/CSV
                </button>
                <!-- Add Row Button Hidden
                <button
                    class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-xl transition-all shadow-lg shadow-primary/20 flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                    </svg>
                    Add Row
                </button>
                -->
            </div>
        </div>

        <!-- Import Instructions -->
        <div class="bg-blue-50 border-l-4 border-blue-500 p-6 rounded-r-2xl mb-8 shadow-sm">
            <div class="flex items-start gap-4">
                <div class="bg-blue-500 p-2 rounded-lg text-white shadow-lg shadow-blue-200">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
                <div>
                    <h3 class="text-lg font-bold text-blue-900 mb-2"><?php echo e(__('Import Instructions')); ?></h3>
                    <p class="text-blue-800 mb-4 text-sm leading-relaxed">
                        <?php echo e(__('To import installments correctly, please ensure your Excel/CSV file follows this exact column order:')); ?>

                    </p>
                    <div class="grid grid-cols-2 md:grid-cols-6 gap-2">
                        <?php
                            $columns = [
                                'Building No',
                                'Flat Num',
                                'Year',
                                'Month',
                                'Installment',
                                'Addons'
                            ];
                        ?>
                        <?php $__currentLoopData = $columns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-white p-3 rounded-xl border border-blue-100 text-center shadow-sm">
                                <span class="block text-[10px] font-bold text-blue-400 uppercase tracking-wider mb-1"><?php echo e(__('Col')); ?> <?php echo e($index + 1); ?></span>
                                <span class="text-blue-900 font-extrabold text-xs"><?php echo e(__($label)); ?></span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Import Modal -->
        <div id="importModal"
            class="fixed inset-0 bg-gray-900/50 backdrop-blur-sm hidden z-50 flex items-center justify-center">
            <div class="bg-white rounded-2xl shadow-xl w-full max-w-md p-6 transform transition-all">
                <div class="flex justify-between items-center mb-6">
                    <h3 class="text-xl font-bold text-gray-800">Import Installments</h3>
                    <button onclick="document.getElementById('importModal').classList.add('hidden')"
                        class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                            </path>
                        </svg>
                    </button>
                </div>

                <form action="<?php echo e(route('inventory.installments.import', [$project->prj_id, $flat->flt_id])); ?>" method="POST"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Upload CSV File</label>
                        <div class="flex items-center justify-center w-full">
                            <label
                                class="flex flex-col items-center justify-center w-full h-32 border-2 border-dashed border-gray-300 rounded-xl cursor-pointer hover:bg-gray-50 transition-colors">
                                <div class="flex flex-col items-center justify-center pt-5 pb-6">
                                    <svg class="w-8 h-8 mb-3 text-gray-400" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12">
                                        </path>
                                    </svg>
                                    <p class="text-sm text-gray-500"><span class="font-semibold">Click to upload</span> or
                                        drag and drop</p>
                                    <p class="text-xs text-gray-500 mt-1">CSV files only</p>
                                </div>
                                <input type="file" name="csv_file" class="hidden" accept=".csv,.txt" required />
                            </label>
                        </div>
                        <p class="text-xs text-red-500 mt-2">* Warning: Importing will replace the existing schedule.</p>
                    </div>

                    <div class="flex gap-3">
                        <button type="button" onclick="document.getElementById('importModal').classList.add('hidden')"
                            class="flex-1 bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-xl font-medium transition-colors">Cancel</button>
                        <button type="submit"
                            class="flex-1 bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-xl font-medium shadow-lg shadow-primary/20 transition-all">Import
                            Now</button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Total Summary -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-6">
            <div class="p-6 bg-blue-50/50">
                <div class="flex items-center justify-between">
                    <span class="text-gray-700 font-bold">Total Project Price:</span>
                    <span class="text-2xl font-extrabold text-blue-700">
                        <?php echo e(number_format($installments->sum('total'), 2)); ?>

                    </span>
                </div>
            </div>
        </div>

            <?php $__empty_1 = true; $__currentLoopData = $groupedInstallments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-4">
                    <!-- Accordion Header -->
                    <div onclick="toggleAccordion('group-<?php echo e($loop->index); ?>')" 
                         class="p-4 bg-gray-50 border-b border-gray-100 flex justify-between items-center cursor-pointer hover:bg-gray-100 transition-colors">
                        <div class="flex items-center gap-3">
                            <span id="icon-group-<?php echo e($loop->index); ?>" class="transform transition-transform duration-200 -rotate-90">
                                <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                </svg>
                            </span>
                            <h3 class="font-bold text-lg text-gray-800">
                                 Building: <?php echo e($group->first()->bldg_no ?? 'N/A'); ?> | Flat: <?php echo e($group->first()->flat_num ?? 'N/A'); ?>

                            </h3>
                        </div>
                        <span class="text-sm font-medium text-gray-500 bg-gray-200 px-3 py-1 rounded-full">
                            <?php echo e(number_format($group->sum('total'), 2)); ?>

                        </span>
                    </div>
                    
                    <!-- Accordion Body (Hidden by default) -->
                    <div id="group-<?php echo e($loop->index); ?>" class="hidden transition-all duration-300 ease-in-out">
                        <div class="overflow-x-auto">
                            <table class="w-full text-left">
                                <thead class="bg-white border-b border-gray-100">
                                    <tr>
                                        <th class="px-6 py-4 text-sm font-bold text-gray-700 uppercase tracking-wider">Year/Month</th>
                                        <th class="px-6 py-4 text-sm font-bold text-gray-700 uppercase tracking-wider">Installment</th>
                                        <th class="px-6 py-4 text-sm font-bold text-gray-700 uppercase tracking-wider">Addons</th>
                                        <th class="px-6 py-4 text-sm font-bold text-gray-700 uppercase tracking-wider">Total</th>
                                        <th class="px-6 py-4 text-sm font-bold text-gray-700 uppercase tracking-wider text-right">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-100">
                                    <?php $__currentLoopData = $group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inst): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="hover:bg-gray-50/50 transition-colors">
                                            <td class="px-6 py-4">
                                                <span class="font-bold text-gray-900"><?php echo e($inst->year); ?></span>
                                                <span class="text-gray-400 mx-1">/</span>
                                                <span class="text-gray-600"><?php echo e($inst->month); ?></span>
                                            </td>
                                            <td class="px-6 py-4 text-gray-900 font-medium"><?php echo e(number_format($inst->inst_amount, 2)); ?></td>
                                            <td class="px-6 py-4 text-gray-600"><?php echo e(number_format($inst->addon_amount ?? 0, 2)); ?></td>
                                            <td class="px-6 py-4">
                                                <span class="font-bold text-primary"><?php echo e(number_format($inst->total, 2)); ?></span>
                                            </td>
                                            <td class="px-6 py-4 text-right">
                                                <button class="text-gray-400 hover:text-red-600 transition-colors">
                                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v2m3 4h.01" />
                                                    </svg>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-8 text-center">
                    <p class="text-gray-500 italic">No price schedule defined for this unit type.</p>
                </div>
            <?php endif; ?>
        </div>

    <script>
        function toggleAccordion(id) {
            const content = document.getElementById(id);
            const icon = document.getElementById('icon-' + id);
            
            if (content.classList.contains('hidden')) {
                // Open
                content.classList.remove('hidden');
                icon.classList.remove('-rotate-90');
                icon.classList.add('rotate-0');
            } else {
                // Close
                content.classList.add('hidden');
                icon.classList.remove('rotate-0');
                icon.classList.add('-rotate-90');
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/inventory/installments.blade.php ENDPATH**/ ?>