

<?php $__env->startSection('title', 'Delay Pay Report'); ?>

<?php $__env->startSection('header', 'Delay Pay Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto">

    <?php if(isset($client)): ?>
        <!-- Client Info Card -->
        <div class="glass-panel rounded-xl p-6 mb-8">
            <div class="flex items-center justify-between">
                <div>
                    <h2 class="text-2xl font-bold text-gray-800"><?php echo e($client->arabic_name ?? 'N/A'); ?></h2>
                    <div class="mt-2 flex items-center gap-4 text-sm text-gray-500">
                        <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full">Old Member #: <?php echo e($client->old_member_no); ?></span>
                        <span class="bg-emerald-100 text-emerald-800 px-3 py-1 rounded-full">ID: <?php echo e($client->cl_id); ?></span>
                    </div>
                </div>
                <div class="text-right">
                    <button onclick="window.print()" class="bg-gray-800 hover:bg-gray-700 text-white px-4 py-2 rounded-lg text-sm transition shadow-lg">
                        Print Report
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Reports -->
        <?php $__empty_1 = true; $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden mb-8">
                <div class="bg-gray-50 px-6 py-4 border-b border-gray-100 flex justify-between items-center">
                    <h3 class="font-bold text-lg text-gray-700">
                        <span class="text-primary">Project:</span> <?php echo e($report['project_name']); ?>

                    </h3>
                    <span class="font-medium text-gray-600">Flat: <?php echo e($report['flat_name']); ?></span>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="text-xs font-bold tracking-wider text-gray-500 uppercase bg-gray-50/50 border-b border-gray-100">
                                <th class="px-6 py-4">Date</th>
                                <th class="px-6 py-4 text-right">Expected (EGP)</th>
                                <th class="px-6 py-4 text-right">Paid (EGP)</th>
                                <th class="px-6 py-4 text-right">Remaining (EGP)</th>
                                <th class="px-6 py-4 text-center">Status</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            <?php $__currentLoopData = $report['rows']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="hover:bg-gray-50/50 transition duration-150">
                                    <td class="px-6 py-3 text-sm text-gray-700 whitespace-nowrap font-medium">
                                        <?php echo e($row['date']); ?>

                                    </td>
                                    <td class="px-6 py-3 text-sm text-gray-600 text-right whitespace-nowrap">
                                        <?php if($row['expected'] !== 'Paid'): ?>
                                            <?php echo e(number_format((float)$row['expected'], 2)); ?>

                                        <?php else: ?>
                                            <span class="text-gray-400">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-3 text-sm text-right whitespace-nowrap font-bold <?php echo e(!empty($row['paid']) ? 'text-emerald-600' : ''); ?>">
                                        <?php echo e(!empty($row['paid']) ? number_format((float)$row['paid'], 2) : '-'); ?>

                                    </td>
                                    <td class="px-6 py-3 text-sm text-gray-600 text-right whitespace-nowrap">
                                        <?php echo e(!empty($row['remaining']) ? number_format((float)$row['remaining'], 2) : '-'); ?>

                                    </td>
                                    <td class="px-6 py-3 text-center">
                                         <?php if($row['expected'] === 'Paid'): ?>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                Paid
                                            </span>
                                         <?php elseif(!empty($row['paid'])): ?>
                                             <!-- Partial? -->
                                         <?php elseif($row['date'] < now()): ?>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                Overdue
                                            </span>
                                         <?php else: ?>
                                            <span class="text-xs text-gray-400">Pending</span>
                                         <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center py-12 bg-white rounded-xl border border-dashed border-gray-300">
                <p class="text-gray-500 text-lg">No reservation records found for this client.</p>
            </div>
        <?php endif; ?>
        
    <?php else: ?>
        <div class="bg-red-50 border-l-4 border-red-400 p-4">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-red-700">
                        Client not found. Please check the member ID.
                    </p>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/clients/delay_pay.blade.php ENDPATH**/ ?>