

<?php $__env->startSection('content'); ?>
    <div class="p-6">
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 space-y-4 md:space-y-0">
            <h1 class="text-2xl font-bold text-gray-800"><?php echo e(__('Employee Bonuses')); ?></h1>
            <div class="flex flex-wrap items-center gap-3">
                <form action="<?php echo e(route('hr.bonuses')); ?>" method="GET" id="filter-form" class="flex items-center space-x-3">
                    <div class="flex items-center <?php echo e(app()->getLocale() == 'ar' ? 'ml-2' : 'space-x-2'); ?>">
                        <label class="text-sm font-semibold text-gray-600"><?php echo e(__('Department:')); ?></label>
                        <select name="job_place" onchange="this.form.submit()"
                            class="px-4 py-2 border rounded-lg outline-none focus:ring-2 focus:ring-blue-500 text-sm">
                            <option value=""><?php echo e(__('All Projects')); ?></option>
                            <?php $__currentLoopData = $jobPlaces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $place): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($place); ?>" <?php echo e($jobPlace == $place ? 'selected' : ''); ?>><?php echo e($place); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="flex items-center <?php echo e(app()->getLocale() == 'ar' ? 'ml-2' : 'space-x-2'); ?>">
                        <label class="text-sm font-semibold text-gray-600"><?php echo e(__('Year:')); ?></label>
                        <select name="year" onchange="this.form.submit()"
                            class="px-4 py-2 border rounded-lg outline-none focus:ring-2 focus:ring-blue-500 text-sm">
                            <?php $__currentLoopData = range(date('Y') - 2, date('Y') + 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($y); ?>" <?php echo e($year == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </form>

                <div class="flex items-center space-x-3 border-l pl-3">
                    <div class="flex flex-col">
                        <label class="text-[10px] uppercase font-bold text-gray-400"><?php echo e(__('Signature')); ?></label>
                        <select id="sign_x" class="text-xs border rounded p-1">
                            <option value="1"><?php echo e(__('Yes')); ?></option>
                            <option value="0"><?php echo e(__('No')); ?></option>
                        </select>
                    </div>
                    <div class="flex flex-col">
                        <label class="text-[10px] uppercase font-bold text-gray-400"><?php echo e(__('Ack.')); ?></label>
                        <select id="pr_x" class="text-xs border rounded p-1">
                            <option value="1"><?php echo e(__('Yes')); ?></option>
                            <option value="0"><?php echo e(__('No')); ?></option>
                        </select>
                    </div>
                    <div class="flex flex-col">
                        <label class="text-[10px] uppercase font-bold text-gray-400"><?php echo e(__('Emp. Sign')); ?></label>
                        <select id="emp_x" class="text-xs border rounded p-1">
                            <option value="1"><?php echo e(__('Yes')); ?></option>
                            <option value="0"><?php echo e(__('No')); ?></option>
                        </select>
                    </div>
                </div>

                <a href="<?php echo e(route('hr.bonuses.print_all', ['year' => $year, 'job_place' => $jobPlace])); ?>"
                    id="print-all-btn" target="_blank"
                    class="bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 transition flex items-center shadow-sm">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z">
                        </path>
                    </svg>
                    <?php echo e(__('Print All')); ?>

                </a>
            </div>
        </div>

        <form action="<?php echo e(route('hr.bonuses.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="year" value="<?php echo e($year); ?>">

            <div class="flex justify-end mb-4">
                <button type="submit"
                    class="px-6 py-2 bg-green-600 text-white rounded-lg font-bold hover:bg-green-700 transition duration-150 shadow-sm">
                    <?php echo e(__('Save All Changes')); ?>

                </button>
            </div>

            <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-x-auto overflow-y-hidden">
                <table class="w-full text-start min-w-[1200px]">
                    <thead class="bg-gray-50 text-sm font-semibold text-gray-600">
                        <tr>
                            <th class="px-4 py-4 text-start"><?php echo e(__('Employee')); ?></th>
                            <th class="px-2 py-4 text-center"><?php echo e(__('Salary')); ?></th>
                            <th class="px-2 py-4 text-center"><?php echo e(__('Incentive')); ?></th>
                            <th class="px-2 py-4 text-center"><?php echo e(__('Meal')); ?></th>
                            <th class="px-2 py-4 text-center"><?php echo e(__('Loans')); ?></th>
                            <th class="px-2 py-4 text-center"><?php echo e(__('Extra')); ?></th>
                            <th class="px-2 py-4 text-center"><?php echo e(__('Transp.')); ?></th>
                            <th class="px-2 py-4 text-center"><?php echo e(__('Adj.')); ?></th>
                            <th class="px-4 py-4 text-center"><?php echo e(__('Total')); ?></th>
                            <th class="px-4 py-4 text-center"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $bonus = $emp->bonuses->first();
                            ?>
                            <tr class="hover:bg-gray-50 transition duration-150">
                                <td class="px-4 py-4">
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($emp->arabic_name); ?></div>
                                    <div class="text-xs text-gray-500"><?php echo e($emp->job_place); ?></div>
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[<?php echo e($emp->emp_id); ?>][salary]" value="<?php echo e($emp->salary); ?>"
                                        class="w-20 px-2 py-1 border rounded text-xs text-center bonus-input-<?php echo e($emp->emp_id); ?>"
                                        disabled>
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[<?php echo e($emp->emp_id); ?>][incentive]"
                                        value="<?php echo e($bonus->incentive ?? 0); ?>"
                                        class="w-20 px-2 py-1 border rounded text-xs text-center bonus-input-<?php echo e($emp->emp_id); ?>"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>">
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[<?php echo e($emp->emp_id); ?>][meal]"
                                        value="<?php echo e($bonus->meal ?? 0); ?>"
                                        class="w-16 px-2 py-1 border rounded text-xs text-center bonus-input-<?php echo e($emp->emp_id); ?>"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>">
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[<?php echo e($emp->emp_id); ?>][loans]"
                                        value="<?php echo e($bonus->loans ?? 0); ?>"
                                        class="w-16 px-2 py-1 border rounded text-xs text-center bonus-input-<?php echo e($emp->emp_id); ?>"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>">
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[<?php echo e($emp->emp_id); ?>][extra]"
                                        value="<?php echo e($bonus->amount ?? 0); ?>"
                                        class="w-20 px-2 py-1 border rounded text-xs text-center bonus-input-<?php echo e($emp->emp_id); ?>"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>">
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[<?php echo e($emp->emp_id); ?>][transp]"
                                        value="<?php echo e($bonus->transp ?? 0); ?>"
                                        class="w-20 px-2 py-1 border rounded text-xs text-center bonus-input-<?php echo e($emp->emp_id); ?>"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>">
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[<?php echo e($emp->emp_id); ?>][taswia]"
                                        value="<?php echo e($bonus->taswia ?? 0); ?>"
                                        class="w-16 px-2 py-1 border rounded text-xs text-center bonus-input-<?php echo e($emp->emp_id); ?>"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>">
                                </td>
                                <td class="px-4 py-4 text-center font-bold text-blue-600">
                                    <span
                                        id="total-<?php echo e($emp->emp_id); ?>"><?php echo e(number_format($emp->salary + ($bonus ? (($bonus->incentive ?? 0) + ($bonus->meal ?? 0) + ($bonus->amount ?? 0) + ($bonus->transp ?? 0) + ($bonus->taswia ?? 0) - ($bonus->loans ?? 0)) : 0))); ?></span>
                                </td>
                                <td class="px-4 py-4 text-center">
                                    <?php if($bonus): ?>
                                        <a href="<?php echo e(route('hr.bonuses.print', $bonus->id)); ?>"
                                            data-base-url="<?php echo e(route('hr.bonuses.print', $bonus->id)); ?>" target="_blank"
                                            class="text-gray-400 hover:text-blue-600 transition-colors print-individual"
                                            title="<?php echo e(__('Print Slip')); ?>">
                                            <svg class="w-5 h-5 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z">
                                                </path>
                                            </svg>
                                        </a>
                                    <?php else: ?>
                                        <span class="text-xs text-gray-300 italic"
                                            title="<?php echo e(__('Save changes to print')); ?>"><?php echo e(__('Not Saved')); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <div class="flex justify-end mt-4">
                <button type="submit"
                    class="px-6 py-2 bg-green-600 text-white rounded-lg font-bold hover:bg-green-700 transition duration-150 shadow-sm">
                    <?php echo e(__('Save All Changes')); ?>

                </button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Dynamic Print Links update
            const printAllBtn = document.getElementById('print-all-btn');
            const signX = document.getElementById('sign_x');
            const prX = document.getElementById('pr_x');
            const empX = document.getElementById('emp_x');

            function updatePrintUrls() {
                const params = new URLSearchParams({
                    year: '<?php echo e($year); ?>',
                    job_place: '<?php echo e($jobPlace); ?>',
                    sign_x: signX.value,
                    pr_x: prX.value,
                    emp_x: empX.value
                });

                printAllBtn.href = `<?php echo e(route('hr.bonuses.print_all')); ?>?${params.toString()}`;

                document.querySelectorAll('.print-individual').forEach(btn => {
                    const baseUrl = btn.dataset.baseUrl;
                    const bonusParams = new URLSearchParams({
                        sign_x: signX.value,
                        pr_x: prX.value,
                        emp_x: empX.value
                    });
                    btn.href = `${baseUrl}?${bonusParams.toString()}`;
                });
            }

            [signX, prX, empX].forEach(el => el.addEventListener('change', updatePrintUrls));
            updatePrintUrls();

            // Dynamic Total Calculation
            document.querySelectorAll('input[type="number"]').forEach(input => {
                input.addEventListener('input', function () {
                    const empId = this.dataset.empId;
                    if (!empId) return;

                    const inputs = document.querySelectorAll(`.bonus-input-${empId}`);
                    let total = 0;
                    inputs.forEach(ci => {
                        const val = parseFloat(ci.value) || 0;
                        if (ci.name.includes('[loans]')) {
                            total -= val;
                        } else if (ci.name.includes('[salary]')) {
                            total += val;
                        } else {
                            total += val;
                        }
                    });
                    document.getElementById(`total-${empId}`).textContent = new Intl.NumberFormat().format(total);
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/hr/bonuses.blade.php ENDPATH**/ ?>