<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <title>مكافأة - <?php echo e($bonus->employee->arabic_name); ?></title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 20px;
            direction: rtl;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .info-table,
        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .info-table th,
        .info-table td {
            text-align: right;
            padding: 8px;
            border: 1px solid #eee;
        }

        .data-table th,
        .data-table td {
            border: 1px solid #333;
            padding: 10px;
            text-align: center;
        }

        .data-table th {
            background-color: #f5f5f5;
        }

        .signature {
            margin-top: 50px;
            text-align: left;
            padding-left: 50px;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                margin: 0;
            }
        }
    </style>
</head>

<body onload="window.print()">
    <div class="header">
        <h1>إيصال مكافأة</h1>
        <p>عام: <?php echo e($bonus->year); ?></p>
    </div>

    <table class="info-table">
        <tr>
            <th>رقم الموظف:</th>
            <td><?php echo e($bonus->emp_id); ?></td>
            <th>اسم الموظف:</th>
            <td><?php echo e($bonus->employee->arabic_name); ?></td>
        </tr>
        <tr>
            <th>الوظيفة:</th>
            <td><?php echo e($bonus->employee->job); ?></td>
            <th>التاريخ:</th>
            <td><?php echo e(date('d/m/Y', $bonus->crdate)); ?></td>
        </tr>
    </table>

    <table class="data-table">
        <thead>
            <tr>
                <th>نوع المكافأة</th>
                <th>القيمة</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php echo e($bonus->type); ?></td>
                <td style="font-weight: bold; font-size: 1.2em;"><?php echo e(number_format($bonus->amount)); ?> EGP</td>
            </tr>
        </tbody>
    </table>

    <?php if(($options['pr_x'] ?? '1') == '1'): ?>
        <div style="margin-top: 20px; font-size: 14px; line-height: 1.6;">
            <p>أقر أنا الموضح بياناته أعلاه بأنني استلمت كافة مستحقاتي المالية (مكافأة) لعام <?php echo e($bonus->year); ?> وليس لي أي
                مطالبات أخرى لدى الشركة.</p>
        </div>
    <?php endif; ?>

    <div style="margin-top: 40px; display: flex; justify-content: space-between;">
        <?php if(($options['emp_x'] ?? '1') == '1'): ?>
            <div style="text-align: center;">
                <p>توقيع الموظف:</p>
                <br>
                __________________
            </div>
        <?php endif; ?>


    </div>

    <div class="no-print" style="margin-top: 20px; text-align: center;">
        <button onclick="window.print()" style="padding: 10px 20px; cursor: pointer;">طباعة</button>
        <button onclick="window.close()" style="padding: 10px 20px; cursor: pointer;">إغلاق</button>
    </div>
</body>

</html><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/hr/print_bonus.blade.php ENDPATH**/ ?>