

<?php $__env->startSection('header'); ?>
    <?php echo e(__('My Profile')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">

            <!-- Profile Image Section -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h3 class="text-lg font-bold text-gray-900 mb-4">Profile Picture</h3>

                    <div class="flex flex-col items-center">
                        <div class="relative mb-4">
                            <?php if($user->image): ?>
                                <img id="profile-image-preview" src="<?php echo e(asset('storage/' . $user->image)); ?>" alt="Profile"
                                    class="w-32 h-32 rounded-full object-cover border-4 border-emerald-100">
                            <?php else: ?>
                                <div id="profile-image-preview"
                                    class="w-32 h-32 rounded-full bg-gradient-to-br from-emerald-500 to-teal-600 flex items-center justify-center text-white text-4xl font-bold border-4 border-emerald-100">
                                    <?php echo e(substr($user->name, 0, 1)); ?>

                                </div>
                            <?php endif; ?>
                        </div>

                        <form id="image-upload-form" enctype="multipart/form-data" class="w-full">
                            <?php echo csrf_field(); ?>
                            <input type="file" id="image-input" name="image" accept="image/*" class="hidden">

                            <button type="button" onclick="document.getElementById('image-input').click()"
                                class="w-full bg-emerald-600 text-white px-4 py-2 rounded-lg hover:bg-emerald-700 transition mb-2">
                                <i class="entypo-camera"></i> Upload New Photo
                            </button>

                            <?php if($user->image): ?>
                                <button type="button" id="delete-image-btn"
                                    class="w-full bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition">
                                    <i class="entypo-trash"></i> Remove Photo
                                </button>
                            <?php endif; ?>
                        </form>

                        <p class="text-xs text-gray-500 mt-4 text-center">
                            JPG, PNG or GIF. Max size 2MB
                        </p>
                    </div>
                </div>
            </div>

            <!-- Right Column -->
            <div class="lg:col-span-2 space-y-6">

                <!-- Personal Information Section -->
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h3 class="text-lg font-bold text-gray-900 mb-4">Personal Information</h3>

                    <form id="update-info-form" class="space-y-4">
                        <?php echo csrf_field(); ?>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Full Name</label>
                            <input type="text" name="name" value="<?php echo e($user->name); ?>"
                                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 focus:border-transparent"
                                required>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Email Address</label>
                            <input type="email" name="email" value="<?php echo e($user->email); ?>"
                                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 focus:border-transparent"
                                required>
                        </div>

                        <button type="submit" id="update-info-btn"
                            class="bg-emerald-600 text-white px-6 py-2 rounded-lg hover:bg-emerald-700 transition font-semibold">
                            <span class="btn-text">Update Information</span>
                            <span class="btn-loader hidden">
                                <i class="animate-spin">⏳</i> Updating...
                            </span>
                        </button>
                    </form>
                </div>

                <!-- Change Password Section -->
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h3 class="text-lg font-bold text-gray-900 mb-4">Change Password</h3>

                    <form id="update-password-form" class="space-y-4">
                        <?php echo csrf_field(); ?>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Current Password</label>
                            <input type="password" name="current_password"
                                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 focus:border-transparent"
                                required>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">New Password</label>
                            <input type="password" name="new_password"
                                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 focus:border-transparent"
                                required minlength="8">
                            <p class="text-xs text-gray-500 mt-1">Minimum 8 characters</p>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Confirm New Password</label>
                            <input type="password" name="new_password_confirmation"
                                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 focus:border-transparent"
                                required minlength="8">
                        </div>

                        <button type="submit" id="update-password-btn"
                            class="bg-emerald-600 text-white px-6 py-2 rounded-lg hover:bg-emerald-700 transition font-semibold">
                            <span class="btn-text">Update Password</span>
                            <span class="btn-loader hidden">
                                <i class="animate-spin">⏳</i> Updating...
                            </span>
                        </button>
                    </form>
                </div>

            </div>
        </div>
    </div>

    <?php $__env->startPush('styles'); ?>
        <style>
            .animate-spin {
                animation: spin 1s linear infinite;
            }

            @keyframes spin {
                from {
                    transform: rotate(0deg);
                }

                to {
                    transform: rotate(360deg);
                }
            }
        </style>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

        <script>
            $(document).ready(function () {

                // Update Personal Info
                $('#update-info-form').submit(function (e) {
                    e.preventDefault();
                    const btn = $('#update-info-btn');
                    const btnText = btn.find('.btn-text');
                    const btnLoader = btn.find('.btn-loader');

                    btnText.addClass('hidden');
                    btnLoader.removeClass('hidden');
                    btn.prop('disabled', true);

                    $.ajax({
                        url: '<?php echo e(route("admin.profile.update_info")); ?>',
                        method: 'POST',
                        data: $(this).serialize(),
                        success: function (response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Success!',
                                text: response.message,
                                timer: 2000,
                                showConfirmButton: false
                            });
                            setTimeout(() => location.reload(), 2000);
                        },
                        error: function (xhr) {
                            let message = 'An error occurred';
                            if (xhr.responseJSON && xhr.responseJSON.errors) {
                                message = Object.values(xhr.responseJSON.errors).flat().join('<br>');
                            }
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                html: message
                            });
                        },
                        complete: function () {
                            btnText.removeClass('hidden');
                            btnLoader.addClass('hidden');
                            btn.prop('disabled', false);
                        }
                    });
                });

                // Update Password
                $('#update-password-form').submit(function (e) {
                    e.preventDefault();
                    const btn = $('#update-password-btn');
                    const btnText = btn.find('.btn-text');
                    const btnLoader = btn.find('.btn-loader');

                    btnText.addClass('hidden');
                    btnLoader.removeClass('hidden');
                    btn.prop('disabled', true);

                    $.ajax({
                        url: '<?php echo e(route("admin.profile.update_password")); ?>',
                        method: 'POST',
                        data: $(this).serialize(),
                        success: function (response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Success!',
                                text: response.message,
                                timer: 2000,
                                showConfirmButton: false
                            });
                            $('#update-password-form')[0].reset();
                        },
                        error: function (xhr) {
                            let message = xhr.responseJSON?.message || 'An error occurred';
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: message
                            });
                        },
                        complete: function () {
                            btnText.removeClass('hidden');
                            btnLoader.addClass('hidden');
                            btn.prop('disabled', false);
                        }
                    });
                });

                // Image Upload Preview and Submit
                $('#image-input').change(function () {
                    const file = this.files[0];
                    if (file) {
                        // Preview
                        const reader = new FileReader();
                        reader.onload = function (e) {
                            $('#profile-image-preview').replaceWith(
                                `<img id="profile-image-preview" src="${e.target.result}" alt="Profile" class="w-32 h-32 rounded-full object-cover border-4 border-emerald-100">`
                            );
                        };
                        reader.readAsDataURL(file);

                        // Upload
                        const formData = new FormData();
                        formData.append('image', file);
                        formData.append('_token', '<?php echo e(csrf_token()); ?>');

                        $.ajax({
                            url: '<?php echo e(route("admin.profile.update_image")); ?>',
                            method: 'POST',
                            data: formData,
                            processData: false,
                            contentType: false,
                            success: function (response) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success!',
                                    text: response.message,
                                    timer: 2000,
                                    showConfirmButton: false
                                });
                                setTimeout(() => location.reload(), 2000);
                            },
                            error: function (xhr) {
                                let message = 'An error occurred';
                                if (xhr.responseJSON && xhr.responseJSON.errors) {
                                    message = Object.values(xhr.responseJSON.errors).flat().join('<br>');
                                }
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    html: message
                                });
                            }
                        });
                    }
                });

                // Delete Image
                $('#delete-image-btn').click(function () {
                    Swal.fire({
                        title: 'Are you sure?',
                        text: "Do you want to remove your profile picture?",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#dc2626',
                        cancelButtonColor: '#6b7280',
                        confirmButtonText: 'Yes, remove it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: '<?php echo e(route("admin.profile.delete_image")); ?>',
                                method: 'DELETE',
                                data: { _token: '<?php echo e(csrf_token()); ?>' },
                                success: function (response) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Deleted!',
                                        text: response.message,
                                        timer: 2000,
                                        showConfirmButton: false
                                    });
                                    setTimeout(() => location.reload(), 2000);
                                },
                                error: function () {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Error!',
                                        text: 'Failed to delete image'
                                    });
                                }
                            });
                        }
                    });
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/profile.blade.php ENDPATH**/ ?>