

<?php $__env->startSection('content'); ?>
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800"><?php echo e(__('Payroll Management')); ?></h1>
            <div class="flex items-center space-x-4">
                <form action="<?php echo e(route('hr.salaries')); ?>" method="GET" id="filter-form" class="flex items-center space-x-3">
                    <div class="flex items-center <?php echo e(app()->getLocale() == 'ar' ? 'ml-2' : 'space-x-2'); ?>">
                        <label class="text-sm font-semibold text-gray-600"><?php echo e(__('Department:')); ?></label>
                        <select name="job_place" onchange="this.form.submit()"
                            class="px-3 py-2 border rounded-lg outline-none focus:ring-2 focus:ring-blue-500 text-sm">
                            <option value=""><?php echo e(__('All Projects')); ?></option>
                            <?php $__currentLoopData = $jobPlaces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $place): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($place); ?>" <?php echo e($jobPlace == $place ? 'selected' : ''); ?>><?php echo e($place); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="flex items-center <?php echo e(app()->getLocale() == 'ar' ? 'ml-2' : 'space-x-2'); ?>">
                        <label class="text-sm font-semibold text-gray-600"><?php echo e(__('Month:')); ?></label>
                        <select name="month" onchange="this.form.submit()"
                            class="px-3 py-2 border rounded-lg outline-none focus:ring-2 focus:ring-blue-500 text-sm">
                            <?php $__currentLoopData = range(1, 12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($m); ?>" <?php echo e($month == $m ? 'selected' : ''); ?>>
                                    <?php echo e(date('F', mktime(0, 0, 0, $m, 1))); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </form>

                <div class="flex items-center space-x-3 border-l pl-3">
                    <div class="flex flex-col">
                        <label class="text-[10px] uppercase font-bold text-gray-400"><?php echo e(__('Signature')); ?></label>
                        <select id="sign_x" class="text-xs border rounded p-1">
                            <option value="1"><?php echo e(__('Yes')); ?></option>
                            <option value="0"><?php echo e(__('No')); ?></option>
                        </select>
                    </div>
                    <div class="flex flex-col">
                        <label class="text-[10px] uppercase font-bold text-gray-400"><?php echo e(__('Ack.')); ?></label>
                        <select id="pr_x" class="text-xs border rounded p-1">
                            <option value="1"><?php echo e(__('Yes')); ?></option>
                            <option value="0"><?php echo e(__('No')); ?></option>
                        </select>
                    </div>
                    <div class="flex flex-col">
                        <label class="text-[10px] uppercase font-bold text-gray-400"><?php echo e(__('Emp. Sign')); ?></label>
                        <select id="emp_x" class="text-xs border rounded p-1">
                            <option value="1"><?php echo e(__('Yes')); ?></option>
                            <option value="0"><?php echo e(__('No')); ?></option>
                        </select>
                    </div>
                </div>

                <a href="<?php echo e(route('hr.salaries.print_all', ['month' => $month, 'job_place' => $jobPlace])); ?>"
                    id="print-all-btn" target="_blank"
                    class="bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 transition flex items-center shadow-sm text-sm font-bold">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z">
                        </path>
                    </svg>
                    <?php echo e(__('Print All')); ?>

                </a>
            </div>
        </div>

        <form action="<?php echo e(route('hr.salaries.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="month" value="<?php echo e($month); ?>">

            <div class="flex justify-end mb-4 space-x-2">
                
                <button type="submit"
                    class="px-6 py-2 bg-green-600 text-white rounded-lg font-bold hover:bg-green-700 transition duration-150 shadow-sm">
                    <?php echo e(__('Save All Changes')); ?>

                </button>
            </div>

            <div class="bg-white rounded-xl shadow-sm overflow-hidden border border-gray-100">
                <table class="w-full text-start">
                    <thead class="bg-gray-50 border-b border-gray-100">
                        <tr>
                            <th class="px-6 py-4 text-sm font-semibold text-gray-600 uppercase text-start">
                                <?php echo e(__('Employee')); ?></th>
                            <th class="px-6 py-4 text-sm font-semibold text-gray-600 uppercase text-start">
                                <?php echo e(__('Base Salary')); ?></th>
                            <th class="px-6 py-4 text-sm font-semibold text-gray-600 uppercase text-start">
                                <?php echo e(__('Incentives')); ?></th>
                            <th class="px-6 py-4 text-sm font-semibold text-gray-600 uppercase text-start"><?php echo e(__('Meals')); ?>

                            </th>
                            <th class="px-6 py-4 text-sm font-semibold text-gray-600 uppercase text-start">
                                <?php echo e(__('Absence')); ?></th>
                            <th class="px-6 py-4 text-sm font-semibold text-gray-600 uppercase text-start"><?php echo e(__('Loans')); ?>

                            </th>
                            <th
                                class="px-6 py-4 text-sm font-semibold text-gray-600 uppercase <?php echo e(app()->getLocale() == 'ar' ? 'text-left' : 'text-right'); ?>">
                                <?php echo e(__('Net Total')); ?></th>
                            <th class="px-6 py-4 text-sm font-semibold text-gray-600 uppercase text-center">
                                <?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $salary = $emp->salaries->first();
                                $incentive = $salary->incentive ?? 0;
                                $meal = $salary->meal ?? 0;
                                $loans = $salary->loans ?? 0;
                                $absence = $salary->absence ?? 0;
                                $extra = $salary->extra ?? 0;
                                $transp = $salary->transp ?? 0;

                                $total = ($emp->salary + $incentive + $meal + $extra + $transp) - ($loans + $absence);
                            ?>
                            <tr class="hover:bg-gray-50 transition duration-150">
                                <td class="px-6 py-4">
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($emp->arabic_name); ?></div>
                                    <div class="text-xs text-gray-500"><?php echo e($emp->job); ?></div>
                                </td>
                                <td class="px-6 py-4">
                                    <input type="number" name="salaries[<?php echo e($emp->emp_id); ?>][base_salary]"
                                        value="<?php echo e($emp->salary); ?>"
                                        class="salary-input w-24 px-2 py-1 border rounded focus:ring-1 focus:ring-blue-500 outline-none text-sm"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>" data-type="base">
                                </td>
                                <td class="px-6 py-4">
                                    <input type="number" name="salaries[<?php echo e($emp->emp_id); ?>][incentive]" value="<?php echo e($incentive); ?>"
                                        class="salary-input w-20 px-2 py-1 border rounded focus:ring-1 focus:ring-green-500 outline-none text-sm text-green-600"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>" data-type="incentive">
                                </td>
                                <td class="px-6 py-4">
                                    <input type="number" name="salaries[<?php echo e($emp->emp_id); ?>][meal]" value="<?php echo e($meal); ?>"
                                        class="salary-input w-20 px-2 py-1 border rounded focus:ring-1 focus:ring-blue-500 outline-none text-sm text-blue-600"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>" data-type="meal">
                                </td>
                                <td class="px-6 py-4">
                                    <input type="number" name="salaries[<?php echo e($emp->emp_id); ?>][absence]" value="<?php echo e($absence); ?>"
                                        class="salary-input w-20 px-2 py-1 border rounded focus:ring-1 focus:ring-red-500 outline-none text-sm text-red-600"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>" data-type="absence">
                                </td>
                                <td class="px-6 py-4">
                                    <input type="number" name="salaries[<?php echo e($emp->emp_id); ?>][loans]" value="<?php echo e($loans); ?>"
                                        class="salary-input w-20 px-2 py-1 border rounded focus:ring-1 focus:ring-red-500 outline-none text-sm text-red-600"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>" data-type="loans">

                                    <input type="hidden" data-type="extra" value="<?php echo e($extra); ?>"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>">
                                    <input type="hidden" data-type="transp" value="<?php echo e($transp); ?>"
                                        data-emp-id="<?php echo e($emp->emp_id); ?>">
                                </td>
                                <td class="px-6 py-4 <?php echo e(app()->getLocale() == 'ar' ? 'text-left' : 'text-right'); ?>">
                                    <span id="net-total-<?php echo e($emp->emp_id); ?>"
                                        class="px-3 py-1 bg-blue-50 text-blue-700 rounded-lg font-bold">
                                        <?php echo e(number_format($total)); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <a href="<?php echo e(route('hr.salaries.print', $emp->emp_id)); ?>?month=<?php echo e($month); ?>"
                                        data-base-url="<?php echo e(route('hr.salaries.print', $emp->emp_id)); ?>" target="_blank"
                                        class="text-gray-400 hover:text-blue-600 transition-colors print-individual"
                                        title="<?php echo e(__('Print Slip')); ?>">
                                        <svg class="w-5 h-5 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z">
                                            </path>
                                        </svg>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <div class="flex justify-end mt-6">
                <button type="submit"
                    class="px-8 py-3 bg-green-600 text-white rounded-xl font-bold hover:bg-green-700 transition duration-150 shadow-lg transform hover:scale-105">
                    Save All Changes
                </button>
            </div>
        </form>
    </div>

    <script>
        document.querySelectorAll('.salary-input').forEach(input => {
            input.addEventListener('input', function () {
                const empId = this.dataset.empId;
                const row = this.closest('tr');

                const base = parseFloat(row.querySelector(`[data-type="base"]`).value) || 0;
                const incentive = parseFloat(row.querySelector(`[data-type="incentive"]`).value) || 0;
                const meal = parseFloat(row.querySelector(`[data-type="meal"]`).value) || 0;
                const absence = parseFloat(row.querySelector(`[data-type="absence"]`).value) || 0;
                const loans = parseFloat(row.querySelector(`[data-type="loans"]`).value) || 0;
                const extra = parseFloat(row.querySelector(`[data-type="extra"]`).value) || 0;
                const transp = parseFloat(row.querySelector(`[data-type="transp"]`).value) || 0;

                const netTotal = (base + incentive + meal + extra + transp) - (absence + loans);

                document.getElementById(`net-total-${empId}`).textContent = new Intl.NumberFormat().format(netTotal);
            });
            // Dynamic Print Links update
            const printAllBtn = document.getElementById('print-all-btn');
            const signX = document.getElementById('sign_x');
            const prX = document.getElementById('pr_x');
            const empX = document.getElementById('emp_x');

            function updatePrintUrls() {
                const params = new URLSearchParams({
                    month: '<?php echo e($month); ?>',
                    job_place: '<?php echo e($jobPlace); ?>',
                    sign_x: signX.value,
                    pr_x: prX.value,
                    emp_x: empX.value
                });

                printAllBtn.href = `<?php echo e(route('hr.salaries.print_all')); ?>?${params.toString()}`;

                // Update individual print icons
                document.querySelectorAll('.print-individual').forEach(btn => {
                    const baseUrl = btn.dataset.baseUrl;
                    const empParams = new URLSearchParams({
                        month: '<?php echo e($month); ?>',
                        sign_x: signX.value,
                        pr_x: prX.value,
                        emp_x: empX.value
                    });
                    btn.href = `${baseUrl}?${empParams.toString()}`;
                });
            }

            [signX, prX, empX].forEach(el => el.addEventListener('change', updatePrintUrls));

            // Initial call
            updatePrintUrls();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/hr/salaries.blade.php ENDPATH**/ ?>