<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | Tiba Rose Admin</title>
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/images/logo.png?v=2')); ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }

        .glass-panel {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }
    </style>
</head>

<body class="bg-slate-900 min-h-screen flex items-center justify-center p-6 relative overflow-hidden">
    <!-- Real Estate Background -->
    <div class="fixed inset-0 z-0">
        <img src="<?php echo e(asset('images/login-bg.png')); ?>" alt="Background" class="w-full h-full object-cover opacity-60">
        <div class="absolute inset-0 bg-gradient-to-br from-slate-900/80 via-transparent to-slate-900/90"></div>
    </div>

    <!-- Animated background elements (maintained for depth) -->
    <div
        class="absolute top-0 -left-4 w-72 h-72 bg-emerald-500 rounded-full mix-blend-multiply filter blur-3xl opacity-10 animate-blob z-0">
    </div>
    <div
        class="absolute top-0 -right-4 w-72 h-72 bg-blue-500 rounded-full mix-blend-multiply filter blur-3xl opacity-10 animate-blob animation-delay-2000 z-0">
    </div>

    <div class="w-full max-w-md relative">
        <div class="glass-panel rounded-2xl shadow-2xl overflow-hidden">
            <div class="p-8">
                <div class="text-center mb-10">
                    <h1 class="text-3xl font-bold text-slate-800">Welcome Back</h1>
                    <p class="text-slate-500 mt-2">Sign in to Tiba Rose Management</p>
                </div>

                <?php if($errors->any()): ?>
                    <div class="bg-red-50 text-red-600 p-4 rounded-lg mb-6 text-sm">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p><?php echo e($error); ?></p>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('login.post')); ?>" method="POST" class="space-y-6">
                    <?php echo csrf_field(); ?>
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">Email or Username</label>
                        <input type="text" name="login" required
                            class="w-full px-4 py-3 bg-white/50 border border-slate-200 rounded-xl focus:ring-2 focus:ring-emerald-500 focus:border-transparent outline-none transition-all duration-200 placeholder:text-slate-400"
                            placeholder="Email or Username" value="<?php echo e(old('login')); ?>">
                    </div>

                    <div>
                        <div class="flex justify-between mb-2">
                            <label class="block text-sm font-medium text-slate-700">Password</label>
                            <a href="#" class="text-xs text-emerald-600 hover:text-emerald-700 font-semibold">Forgot
                                password?</a>
                        </div>
                        <input type="password" name="password" required
                            class="w-full px-4 py-3 bg-white/50 border border-slate-200 rounded-xl focus:ring-2 focus:ring-emerald-500 focus:border-transparent outline-none transition-all duration-200"
                            placeholder="••••••••">
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" id="remember" name="remember"
                            class="w-4 h-4 text-emerald-600 rounded border-slate-300 focus:ring-emerald-500">
                        <label for="remember" class="ml-2 text-sm text-slate-600">Remember me for 30 days</label>
                    </div>

                    <button type="submit"
                        class="w-full bg-emerald-600 hover:bg-emerald-700 text-white font-semibold py-3 px-4 rounded-xl transition-all duration-200 transform hover:scale-[1.02] active:scale-[0.98] shadow-lg shadow-emerald-200/50">
                        Sign In
                    </button>
                </form>
            </div>

            <div class="bg-slate-50 border-t border-slate-100 p-6 text-center">
                <p class="text-sm text-slate-500">
                    Need technical support? <a href="#"
                        class="text-emerald-600 hover:text-emerald-700 font-semibold">Contact IT</a>
                </p>
            </div>
        </div>
    </div>
</body>

</html><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/auth/login.blade.php ENDPATH**/ ?>