

<?php $__env->startSection('content'); ?>
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800"><?php echo e(__('Attendance Machine Logs')); ?></h1>
            <form action="<?php echo e(route('hr.attendance')); ?>" method="GET" class="flex items-center space-x-2">
                <input type="date" name="from" value="<?php echo e($from); ?>"
                    class="px-3 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 outline-none">
                <span class="text-gray-400"><?php echo e(__('to')); ?></span>
                <input type="date" name="to" value="<?php echo e($to); ?>"
                    class="px-3 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 outline-none">
                <button type="submit"
                    class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition"><?php echo e(__('Filter')); ?></button>
            </form>
        </div>

        <div class="bg-white rounded-xl shadow-sm overflow-hidden border border-gray-100">
            <table class="w-full text-start">
                <thead class="bg-gray-50 border-b border-gray-100">
                    <tr>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600 text-start"><?php echo e(__('Date')); ?></th>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600 text-start"><?php echo e(__('Machine ID')); ?></th>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600 text-start"><?php echo e(__('Entry Time')); ?></th>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600 text-start"><?php echo e(__('Exit Time')); ?></th>
                        <th
                            class="px-6 py-4 text-sm font-semibold text-gray-600 <?php echo e(app()->getLocale() == 'ar' ? 'text-left' : 'text-right'); ?>">
                            <?php echo e(__('Working Hours')); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__currentLoopData = $attendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $att): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $start = \Carbon\Carbon::parse($att->enter_tm);
                            $end = \Carbon\Carbon::parse($att->exit_tm);
                            $hours = $start->diffInHours($end);
                        ?>
                        <tr class="hover:bg-gray-50 transition duration-150">
                            <td class="px-6 py-4 text-sm text-gray-800 font-medium"><?php echo e($att->day); ?></td>
                            <td class="px-6 py-4 text-sm text-gray-600 italic">#<?php echo e($att->machine_id); ?></td>
                            <td class="px-6 py-4 text-sm text-green-600"><?php echo e($att->enter_tm); ?></td>
                            <td class="px-6 py-4 text-sm text-red-600"><?php echo e($att->exit_tm); ?></td>
                            <td class="px-6 py-4 <?php echo e(app()->getLocale() == 'ar' ? 'text-left' : 'text-right'); ?>">
                                <span class="px-2 py-1 bg-yellow-50 text-yellow-700 rounded text-xs font-bold font-mono">
                                    <?php echo e($hours); ?>h
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/hr/attendance.blade.php ENDPATH**/ ?>