

<?php $__env->startSection('header'); ?>
    <?php echo e(__('Print Checks')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h2 class="text-2xl font-bold text-gray-900 mb-6">طباعه الشيكات</h2>

        <div class="max-w-md">
            <label class="block text-lg font-semibold text-gray-700 mb-3">يرجى اختيار البنك</label>
            <select id="bank-select"
                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 text-lg">
                <option value="">أختار.....</option>
                <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($bank->bank_id); ?>"><?php echo e($bank->bank_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <div class="mt-6 p-4 bg-blue-50 border border-blue-200 rounded-lg">
                <p class="text-sm text-gray-600">
                    <i class="entypo-info"></i> بعد اختيار البنك سيتم توجيهك لصفحة طباعة الشيكات الخاصة بالبنك المحدد
                </p>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script>
            $(document).ready(function () {
                $('#bank-select').change(function () {
                    const bankId = $(this).val();
                    if (bankId && bankId !== '') {
                        let bank = 'aai';
                        if (bankId == 6 || bankId == 7) bank = 'ahly';
                        if (bankId == 34 || bankId == 10) bank = 'misr';
                        if (bankId == 33) bank = 'aai';

                        alert('سيتم التوجيه لصفحة طباعة شيكات بنك ' + $(this).find('option:selected').text());
                        // In production, redirect to bank-specific check print page
                        // window.location = '/admin/print/checks/' + bank;
                    }
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/print/print_checks.blade.php ENDPATH**/ ?>