<!-- Print Payment Order Modal -->
<div id="printOrderModal" class="fixed inset-0 z-50 hidden overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen p-4 text-center sm:block sm:p-0">
        <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75" onclick="closePrintOrderModal()"></div>

        <div
            class="inline-block w-full max-w-2xl my-8 overflow-hidden text-start align-middle transition-all transform bg-white shadow-xl rounded-2xl">
            <div class="px-6 py-4 border-b border-gray-100 flex justify-between items-center bg-gray-50/50">
                <h3 class="text-lg font-bold text-gray-800" id="modalTitle"><?php echo e(__('Print Payment Order')); ?></h3>
                <button onclick="closePrintOrderModal()" class="text-gray-400 hover:text-gray-600 transition-colors">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                        </path>
                    </svg>
                </button>
            </div>

            <div class="px-8 py-6" id="modalContent">
                <!-- Step 1: Select Unit -->
                <div id="step1">
                    <p class="text-sm text-gray-500 mb-4"><?php echo e(__('Select the unit for')); ?>: <span id="clientNameDisplay"
                            class="font-bold text-slate-800"></span></p>
                    <div id="unitsList" class="space-y-3">
                        <!-- Units will be injected here -->
                    </div>
                </div>

                <!-- Step 2: Payment Details -->
                <div id="step2" class="hidden">
                    <div class="grid grid-cols-2 gap-6">
                        <div class="col-span-2">
                            <label
                                class="block text-sm font-semibold text-gray-700 mb-1"><?php echo e(__('Current Due')); ?></label>
                            <input type="text" id="due_amount" readonly
                                class="w-full px-4 py-2 bg-gray-50 border border-gray-200 rounded-lg text-lg font-bold text-emerald-600">
                        </div>

                        <div>
                            <label
                                class="block text-sm font-semibold text-gray-700 mb-1"><?php echo e(__('Amount to Pay')); ?></label>
                            <input type="number" id="pay_amount"
                                class="w-full px-4 py-2 border border-blue-200 rounded-lg focus:ring-2 focus:ring-blue-100 focus:border-blue-400 transition-all">
                        </div>

                        <div>
                            <label
                                class="block text-sm font-semibold text-gray-700 mb-1"><?php echo e(__('Payment Type')); ?></label>
                            <select id="inst_type"
                                class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400 transition-all">
                                <!-- Types will be injected here -->
                            </select>
                        </div>

                        <div class="col-span-2">
                            <label
                                class="block text-sm font-semibold text-gray-700 mb-1"><?php echo e(__('Select Bank')); ?></label>
                            <select id="bank_select"
                                class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400 transition-all">
                                <!-- Banks will be injected here -->
                            </select>
                        </div>

                        <div>
                            <label
                                class="block text-sm font-semibold text-gray-700 mb-1"><?php echo e(__('Valid Until (Days)')); ?></label>
                            <input type="number" id="pay_until" value="15" max="120"
                                class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400 transition-all">
                        </div>
                    </div>

                    <div class="mt-8 flex justify-between">
                        <button onclick="goToStep(1)"
                            class="px-6 py-2 text-gray-600 hover:text-gray-800 font-medium transition-colors"><?php echo e(__('Back')); ?></button>
                        <button onclick="submitOrder()"
                            class="px-8 py-2 bg-emerald-600 text-white rounded-xl font-bold hover:bg-emerald-700 shadow-lg shadow-emerald-200 transition-all"><?php echo e(__('Generate Order')); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        let currentClientId = null;
        let currentProjectId = null;
        let currentFlatId = null;

        function openPrintOrderModal(clientId, clientName) {
            currentClientId = clientId;
            document.getElementById('clientNameDisplay').textContent = clientName;
            document.getElementById('printOrderModal').classList.remove('hidden');
            goToStep(1);

            // Fetch Units
            fetch(`<?php echo e(url('admin/clients/print-order/units')); ?>/${clientId}`)
                .then(r => r.json())
                .then(data => {
                    const list = document.getElementById('unitsList');
                    list.innerHTML = '';
                    if (data.reservations.length === 0) {
                        list.innerHTML = `<p class="text-center py-4 text-gray-400">${'<?php echo e(__('No units found for this client')); ?>'}</p>`;
                        return;
                    }
                    data.reservations.forEach(res => {
                        const btn = document.createElement('div');
                        btn.className = 'p-4 border border-gray-100 rounded-xl hover:bg-emerald-50 hover:border-emerald-200 cursor-pointer transition-all group';
                        btn.onclick = () => selectUnit(res.prj_id, res.flt_id);
                        btn.innerHTML = `
                                    <div class="flex justify-between items-center">
                                        <div>
                                            <h4 class="font-bold text-slate-800 underline decoration-emerald-200 group-hover:decoration-emerald-400">${res.project_name}</h4>
                                            <p class="text-xs text-slate-500 mt-1">${'<?php echo e(__('Unit')); ?>'}: ${res.flat_num} | ${'<?php echo e(__('Area')); ?>'}: ${res.area}m</p>
                                        </div>
                                        <svg class="w-5 h-5 text-emerald-400 group-hover:translate-x-[-4px] transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                                        </svg>
                                    </div>
                                `;
                        list.appendChild(btn);
                    });
                });
        }

        function closePrintOrderModal() {
            document.getElementById('printOrderModal').classList.add('hidden');
        }

        function goToStep(step) {
            document.getElementById('step1').classList.toggle('hidden', step !== 1);
            document.getElementById('step2').classList.toggle('hidden', step !== 2);
        }

        function selectUnit(prjId, fltId) {
            currentProjectId = prjId;
            currentFlatId = fltId;

            console.log('Selecting unit:', { prjId, fltId, clientId: currentClientId });

            fetch(`<?php echo e(url('admin/clients/print-order/details')); ?>`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify({
                    cl_id: currentClientId,
                    prj_id: prjId,
                    flt_id: fltId
                })
            })
                .then(r => {
                    if (!r.ok) throw new Error('Network response was not ok');
                    return r.json();
                })
                .then(data => {
                    const locale = '<?php echo e(app()->getLocale() == 'ar' ? 'ar-EG' : 'en-US'); ?>';
                    document.getElementById('due_amount').value = new Intl.NumberFormat(locale, { style: 'currency', currency: 'EGP' }).format(data.remain);
                    document.getElementById('pay_amount').value = data.remain;

                    const bankSelect = document.getElementById('bank_select');
                    bankSelect.innerHTML = '';
                    data.banks.forEach(bank => {
                        const opt = document.createElement('option');
                        opt.value = `${bank.bank_name}|${bank.account_number}`;
                        opt.textContent = `${bank.bank_name} - ${bank.account_number}`;
                        if (opt.value === data.default_bank) opt.selected = true;
                        bankSelect.appendChild(opt);
                    });

                    const typeSelect = document.getElementById('inst_type');
                    typeSelect.innerHTML = '';
                    data.installment_types.forEach(type => {
                        const opt = document.createElement('option');
                        opt.value = type;
                        opt.textContent = type;
                        typeSelect.appendChild(opt);
                    });

                    goToStep(2);
                })
                .catch(error => {
                    console.error('Error fetching details:', error);
                    alert('<?php echo e(__('Error loading payment details. Please try again.')); ?>');
                });
        }

        function submitOrder() {
            const payload = {
                cl_id: currentClientId,
                prj_id: currentProjectId,
                flt_id: currentFlatId,
                amount: document.getElementById('pay_amount').value,
                bank: document.getElementById('bank_select').value,
                inst_type: document.getElementById('inst_type').value,
                pay_until: document.getElementById('pay_until').value
            };

            console.log('Submitting order:', payload);

            if (!payload.amount || payload.amount <= 0) {
                alert('<?php echo e(__('Please enter a valid amount')); ?>');
                return;
            }

            fetch(`<?php echo e(url('admin/clients/print-order/store')); ?>`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify(payload)
            })
                .then(r => {
                    if (!r.ok) {
                        return r.text().then(text => { throw new Error(text || 'Server Error') });
                    }
                    return r.json();
                })
                .then(data => {
                    if (data.success) {
                        closePrintOrderModal();
                        // Open print view in new tab
                        const url = `<?php echo e(url('admin/clients/print-order/show')); ?>/${data.order_id}`;
                        window.open(url, '_blank');
                    } else {
                        alert('<?php echo e(__('Error')); ?>: ' + (data.message || '<?php echo e(__('Unknown error occurred')); ?>'));
                    }
                })
                .catch(error => {
                    console.error('Submit error:', error);
                    alert('<?php echo e(__('Failed to generate order. Check console for details.')); ?>');
                });
        }
    </script>
<?php $__env->stopPush(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/clients/modals/print_payment_order.blade.php ENDPATH**/ ?>