<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title', 'Admin Panel'); ?> - Tiba Rose</title>
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/images/logo.png?v=' . time())); ?>">
    <link rel="shortcut icon" type="image/png" href="<?php echo e(asset('assets/images/logo.png?v=' . time())); ?>">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/font-icons/entypo/css/entypo.css')); ?>">

    <!-- Tailwind CSS (CDN for now, can move to Vite later) -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#10b981', // Emerald 500
                        secondary: '#1e293b', // Slate 800
                        danger: '#ef4444',
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    }
                }
            }
        }
    </script>

    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f3f4f6;
        }

        .glass-panel {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }

        .sidebar-link {
            transition: all 0.3s ease;
        }

        .sidebar-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
            padding-left: 1.5rem;
        }

        .submenu {
            transition: all 0.3s ease;
            overflow: hidden;
        }

        .submenu.hidden {
            max-height: 0;
            opacity: 0;
        }

        .submenu:not(.hidden) {
            max-height: 1000px;
            opacity: 1;
        }

        /* RTL Adjustments */
        [dir="rtl"] .sidebar-link:hover {
            padding-left: 1.5rem;
            padding-right: 1.5rem;
        }

        [dir="rtl"] .sidebar-link {
            text-align: right;
        }

        [dir="rtl"] .ml-auto {
            margin-right: auto;
            margin-left: 0;
        }

        [dir="rtl"] .mr-auto {
            margin-left: auto;
            margin-right: 0;
        }

        [dir="rtl"] .pl-10 {
            padding-right: 2.5rem;
            padding-left: 0.75rem;
        }

        [dir="rtl"] .left-0 {
            right: 0;
            left: auto;
        }

        [dir="rtl"] .pl-3 {
            padding-right: 0.75rem;
            padding-left: 0;
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="antialiased text-slate-800">

    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <aside class="w-64 bg-secondary text-white flex-shrink-0 hidden md:flex flex-col">
            <div class="p-6 border-b border-gray-700 flex items-center gap-4">
                <img src="/admin_laravel/public/assets/images/logo.png" alt="Logo"
                    class="w-12 h-12 object-contain rounded-lg bg-white/10 p-1">
                <div>
                    <h1 class="text-xl font-bold tracking-wider text-primary"><?php echo e(__('TIBA ROSE')); ?></h1>
                    <p class="text-[10px] text-gray-400 uppercase tracking-widest"><?php echo e(__('Admin Dashboard')); ?></p>
                </div>
            </div>

            <nav class="flex-1 overflow-y-auto py-4">
                <ul>
                    <li class="px-4 py-2">
                        <span
                            class="text-xs uppercase font-semibold text-gray-500 tracking-wider"><?php echo e(__('Main')); ?></span>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.dashboard')); ?>"
                            class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                            <?php echo e(__('Dashboard')); ?>

                        </a>
                    </li>
                    <li class="px-4 py-2 mt-4">
                        <span
                            class="text-xs uppercase font-semibold text-gray-500 tracking-wider"><?php echo e(__('Modules')); ?></span>
                    </li>
                    <li>
                        <a href="<?php echo e(route('clients.index')); ?>"
                            class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('clients.*') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                            <?php echo e(__('Clients')); ?>

                        </a>
                    </li>
                    <li>
                        <button onclick="toggleSubmenu('hr-submenu')"
                            class="sidebar-link flex items-center justify-between w-full px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('hr.*') ? 'bg-slate-700/50' : ''); ?>">
                            <span><?php echo e(__('HR (Employees)')); ?></span>
                            <svg id="hr-submenu-icon" class="w-4 h-4 transition-transform" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7" />
                            </svg>
                        </button>
                    </li>
                    <div id="hr-submenu" class="submenu hidden">
                        <li class="pl-4">
                            <a href="<?php echo e(route('hr.index')); ?>"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white <?php echo e(request()->routeIs('hr.index') ? 'text-primary' : ''); ?>">
                                - <?php echo e(__('Employees')); ?>

                            </a>
                        </li>
                        <li class="pl-4">
                            <a href="<?php echo e(route('hr.salaries')); ?>"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white <?php echo e(request()->routeIs('hr.salaries') ? 'text-primary' : ''); ?>">
                                - <?php echo e(__('Salaries')); ?>

                            </a>
                        </li>
                        <li class="pl-4">
                            <a href="<?php echo e(route('hr.attendance')); ?>"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white <?php echo e(request()->routeIs('hr.attendance') ? 'text-primary' : ''); ?>">
                                - <?php echo e(__('Attendance')); ?>

                            </a>
                        </li>
                        <li class="pl-4">
                            <a href="<?php echo e(route('hr.bonuses')); ?>"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white <?php echo e(request()->routeIs('hr.bonuses') ? 'text-primary' : ''); ?>">
                                - <?php echo e(__('Bonuses')); ?>

                            </a>
                        </li>
                        <li class="pl-4">
                            <a href="<?php echo e(route('hr.vacations')); ?>"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white <?php echo e(request()->routeIs('hr.vacations') ? 'text-primary' : ''); ?>">
                                - <?php echo e(__('Vacations')); ?>

                            </a>
                        </li>
                        <li class="pl-4">
                            <a href="<?php echo e(route('hr.audit')); ?>"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white <?php echo e(request()->routeIs('hr.audit') ? 'text-primary' : ''); ?>">
                                - <?php echo e(__('Audit Logs')); ?>

                            </a>
                        </li>
                    </div>
                    
                    
                    <li>
                        <a href="<?php echo e(route('inventory.projects')); ?>"
                            class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('inventory.projects') || request()->routeIs('inventory.flats') || request()->routeIs('inventory.installments') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                            <?php echo e(__('Inventory (Projects)')); ?>

                        </a>
                    </li>
                    
                    <li>
                        <button onclick="toggleSubmenu('reports-submenu')"
                            class="sidebar-link flex items-center justify-between w-full px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('reports.*') ? 'bg-slate-700/50' : ''); ?>">
                            <span><?php echo e(__("Reports")); ?></span>
                            <svg id="reports-submenu-icon" class="w-4 h-4 transition-transform" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7" />
                            </svg>
                        </button>
                    </li>
                    <div id="reports-submenu" class="submenu hidden">
                        <li>
                            <a href="<?php echo e(route('reports.inquiry_by_building')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('reports.inquiry_by_building') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Inquiry by Building')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('reports.parking_and_garden')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('reports.parking_and_garden') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Parking & Garden')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('reports.project_payments')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('reports.project_payments') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Project Payment Details')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('reports.penalties')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('reports.penalties') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Penalties & Interest')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('reports.receipt_review')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('reports.receipt_review') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Receipt Review Report')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('reports.pending_receipts')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('reports.pending_receipts') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Pending Receipts')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('reports.deleted_items')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('reports.deleted_items') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Deleted Items Review')); ?>

                            </a>
                        </li>
                    </div>
                    <li>
                        <button onclick="toggleSubmenu('print-submenu')"
                            class="sidebar-link flex items-center justify-between w-full px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('print.*') ? 'bg-slate-700/50' : ''); ?>">
                            <span><?php echo e(__('Print')); ?></span>
                            <svg id="print-submenu-icon" class="w-4 h-4 transition-transform" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7" />
                            </svg>
                        </button>
                    </li>
                    <div id="print-submenu" class="submenu hidden">
                        <li>
                            <a href="<?php echo e(route('print.empty_payment')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('print.empty_payment') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Empty Payment Order')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('print.manual_payment')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('print.manual_payment') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Manual Payment Order')); ?>

                            </a>
                        </li>
                        
                        <li>
                            <a href="<?php echo e(route('print.membership')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('print.membership') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Membership Form')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('letters.print_warnings')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('letters.*') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Print Warning Letters')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('import.transactions')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('import.*') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Import Transactions')); ?>

                            </a>
                        </li>
                    </div>

                    <!-- Website Section -->
                    <li>
                        <button onclick="toggleSubmenu('website-submenu')"
                            class="sidebar-link flex items-center justify-between w-full px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('website.*') ? 'bg-slate-700/50' : ''); ?>">
                            <span><?php echo e(__('Website')); ?></span>
                            <svg id="website-submenu-icon" class="w-4 h-4 transition-transform" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7" />
                            </svg>
                        </button>
                    </li>
                    <div id="website-submenu" class="submenu hidden">
                        <li>
                            <a href="<?php echo e(route('website.requests')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('website.requests') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Client Requests')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('website.comments')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('website.comments') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Client Comments')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('website.uploads')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('website.uploads') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Uploaded Files')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('website.area_changes')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('website.area_changes') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Area Change Requests')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('website.updates')); ?>"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white <?php echo e(request()->routeIs('website.updates') ? 'bg-slate-700/50 border-r-4 border-primary' : ''); ?>">
                                <?php echo e(__('Client Updates')); ?>

                            </a>
                        </li>
                    </div>
                </ul>
            </nav>

            <?php if(auth()->guard('admin')->check()): ?>
                <a href="<?php echo e(route('admin.profile')); ?>"
                    class="block p-4 border-t border-gray-700 hover:bg-slate-700/50 transition cursor-pointer">
                    <div class="flex items-center gap-3">
                        <?php if(Auth::guard('admin')->user()->image): ?>
                            <img src="<?php echo e(asset('storage/' . Auth::guard('admin')->user()->image)); ?>" alt="Profile"
                                class="h-10 w-10 rounded-full object-cover border-2 border-primary">
                        <?php else: ?>
                            <div
                                class="h-10 w-10 rounded-full bg-primary flex items-center justify-center text-white font-bold">
                                <?php echo e(substr(Auth::guard('admin')->user()->name, 0, 1)); ?>

                            </div>
                        <?php endif; ?>
                        <div>
                            <p class="text-sm font-medium text-gray-200"><?php echo e(Auth::guard('admin')->user()->name); ?></p>
                            <p class="text-xs text-gray-400"><?php echo e(Auth::guard('admin')->user()->email); ?></p>
                        </div>
                    </div>
                </a>
            <?php endif; ?>
        </aside>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col h-screen overflow-hidden">
            <!-- Header -->
            <header class="h-16 bg-white shadow-sm flex items-center justify-between px-6 z-10">
                <button class="md:hidden text-gray-600 focus:outline-none">
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                </button>

                <!-- Global Search -->
                <div class="relative flex-1 max-w-md mx-6 hidden sm:block">
                    <div
                        class="absolute inset-y-0 <?php echo e(app()->getLocale() == 'ar' ? 'right-0 pr-3' : 'left-0 pl-3'); ?> flex items-center pointer-events-none">
                        <svg class="h-4 w-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                        </svg>
                    </div>
                    <input type="text" id="global-search" placeholder="<?php echo e(__('Search anything...')); ?>"
                        class="block w-full <?php echo e(app()->getLocale() == 'ar' ? 'pr-10 pl-3' : 'pl-10 pr-3'); ?> py-2 border border-gray-100 rounded-xl leading-5 bg-gray-50/50 placeholder-gray-400 focus:outline-none focus:bg-white focus:ring-2 focus:ring-primary/20 focus:border-primary sm:text-sm transition duration-200">
                    <div id="search-results"
                        class="hidden absolute mt-2 w-full bg-white rounded-xl shadow-2xl border border-gray-100 z-50 overflow-hidden">
                        <!-- Results injected here -->
                    </div>
                </div>

                <div class="text-sm font-medium text-gray-500 <?php echo e(app()->getLocale() == 'ar' ? 'ml-auto' : 'mr-auto'); ?>">
                    <?php echo $__env->yieldContent('header'); ?>
                </div>

                <div class="flex items-center gap-4">
                    <!-- Language Switcher -->
                    <?php if(app()->getLocale() == 'en'): ?>
                        <a href="<?php echo e(route('lang.switch', 'ar')); ?>"
                            class="flex items-center gap-2 px-3 py-1.5 rounded-lg border border-gray-200 hover:bg-gray-50 transition-colors">
                            <span class="text-sm font-medium">العربية</span>
                            <span
                                class="w-6 h-4 bg-gray-200 rounded-sm overflow-hidden flex items-center justify-center text-[10px]">🇸🇦</span>
                        </a>
                    <?php else: ?>
                        <a href="<?php echo e(route('lang.switch', 'en')); ?>"
                            class="flex items-center gap-2 px-3 py-1.5 rounded-lg border border-gray-200 hover:bg-gray-50 transition-colors">
                            <span class="text-sm font-medium">English</span>
                            <span
                                class="w-6 h-4 bg-gray-200 rounded-sm overflow-hidden flex items-center justify-center text-[10px]">🇺🇸</span>
                        </a>
                    <?php endif; ?>

                    <button class="p-2 rounded-full hover:bg-gray-100 text-gray-600">
                        <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                        </svg>
                    </button>
                    <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                        class="text-sm font-medium text-red-600 hover:text-red-700"><?php echo e(__('Logout')); ?></a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="hidden">
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
                <?php if(session('success')): ?>
                    <div class="mb-4 bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded shadow-sm"
                        role="alert">
                        <p class="font-bold"><?php echo e(__('Success')); ?></p>
                        <p><?php echo e(session('success')); ?></p>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="mb-4 bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded shadow-sm" role="alert">
                        <p class="font-bold"><?php echo e(__('Error')); ?></p>
                        <p><?php echo e(session('error')); ?></p>
                    </div>
                <?php endif; ?>

                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const searchInput = document.getElementById('global-search');
            const resultsDiv = document.getElementById('search-results');
            let debounceTimer;

            searchInput.addEventListener('input', function () {
                clearTimeout(debounceTimer);
                const query = this.value;

                if (query.length < 2) {
                    resultsDiv.classList.add('hidden');
                    return;
                }

                debounceTimer = setTimeout(() => {
                    fetch(`<?php echo e(route('admin.global.search')); ?>?q=${encodeURIComponent(query)}`)
                        .then(response => response.json())
                        .then(data => {
                            if (data.length > 0) {
                                resultsDiv.innerHTML = data.map(item => `
                                    <a href="${item.url}" class="flex items-center px-4 py-3 hover:bg-gray-50 border-b border-gray-50 last:border-b-0 transition duration-150">
                                        <div class="p-2 bg-blue-50 text-blue-600 rounded-lg mr-3">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-sm font-semibold text-gray-800">${item.title}</p>
                                            <p class="text-xs text-gray-500 font-medium uppercase tracking-wider">${item.category}</p>
                                        </div>
                                    </a>
                                `).join('');
                                resultsDiv.classList.remove('hidden');
                            } else {
                                resultsDiv.innerHTML = '<div class="px-4 py-3 text-sm text-gray-500 text-center">No results found</div>';
                                resultsDiv.classList.remove('hidden');
                            }
                        });
                }, 300);
            });

            document.addEventListener('click', function (e) {
                if (!searchInput.contains(e.target) && !resultsDiv.contains(e.target)) {
                    resultsDiv.classList.add('hidden');
                }
            });
        });

        // Sidebar collapsible toggle function
        function toggleSubmenu(submenuId) {
            const submenu = document.getElementById(submenuId);
            const icon = document.getElementById(submenuId + '-icon');

            if (submenu.classList.contains('hidden')) {
                submenu.classList.remove('hidden');
                icon.style.transform = 'rotate(180deg)';
            } else {
                submenu.classList.add('hidden');
                icon.style.transform = 'rotate(0deg)';
            }
        }
    </script>
</body>

</html><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/layouts/admin.blade.php ENDPATH**/ ?>