

<?php $__env->startSection('content'); ?>
    <div class="container mx-auto px-4 py-6">
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-800"><?php echo e(__('Dashboard')); ?></h1>
            <p class="text-gray-600"><?php echo e(__('Overview of system statistics and project status.')); ?></p>
        </div>

        <!-- Top Row: General Stats -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Employees -->
            <div class="bg-white rounded-lg shadow-sm p-6 border-l-4 border-red-500 hover:shadow-md transition-shadow">
                <div class="flex justify-between items-start">
                    <div>
                        <div class="text-3xl font-bold text-gray-800 mb-1"><?php echo e($users_count); ?></div>
                        <div class="text-sm font-medium text-gray-500 uppercase"><?php echo e(__('Employees')); ?></div>
                        <div class="text-xs text-gray-400 mt-1"><?php echo e(__('Registered Staff')); ?></div>
                    </div>
                    <div class="p-3 bg-red-50 rounded-full text-red-500">
                        <i class="entypo-users text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Clients -->
            <div class="bg-white rounded-lg shadow-sm p-6 border-l-4 border-emerald-500 hover:shadow-md transition-shadow cursor-pointer"
                onclick="window.location='<?php echo e(route('clients.index')); ?>'">
                <div class="flex justify-between items-start">
                    <div>
                        <div class="text-3xl font-bold text-gray-800 mb-1"><?php echo e($clients_count); ?></div>
                        <div class="text-sm font-medium text-gray-500 uppercase"><?php echo e(__('Clients')); ?></div>
                        <div class="text-xs text-gray-400 mt-1"><?php echo e(__('Registered Clients')); ?></div>
                    </div>
                    <div class="p-3 bg-emerald-50 rounded-full text-emerald-500">
                        <i class="entypo-users text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Projects -->
            <div class="bg-white rounded-lg shadow-sm p-6 border-l-4 border-cyan-500 hover:shadow-md transition-shadow">
                <div class="flex justify-between items-start">
                    <div>
                        <div class="text-3xl font-bold text-gray-800 mb-1"><?php echo e($projects_count); ?></div>
                        <div class="text-sm font-medium text-gray-500 uppercase"><?php echo e(__('Projects')); ?></div>
                        <div class="text-xs text-gray-400 mt-1"><?php echo e(__('Active Projects')); ?></div>
                    </div>
                    <div class="p-3 bg-cyan-50 rounded-full text-cyan-500">
                        <i class="entypo-chart-bar text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Updates -->
            <div class="bg-white rounded-lg shadow-sm p-6 border-l-4 border-blue-500 hover:shadow-md transition-shadow cursor-pointer"
                onclick="window.location='<?php echo e(route('website.updates')); ?>'">
                <div class="flex justify-between items-start">
                    <div>
                        <div class="text-3xl font-bold text-gray-800 mb-1"><?php echo e($updates_count); ?></div>
                        <div class="text-sm font-medium text-gray-500 uppercase"><?php echo e(__('Updates')); ?></div>
                        <div class="text-xs text-gray-400 mt-1"><?php echo e(__('Updated Profiles')); ?></div>
                    </div>
                    <div class="p-3 bg-blue-50 rounded-full text-blue-500">
                        <i class="entypo-rss text-xl"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Middle Row: Allocations (Clickable for Visuals) -->
        <h3 class="text-lg font-semibold text-gray-700 mb-4 border-b pb-2"><?php echo e(__('Unit Allocation')); ?> <span
                class="text-xs font-normal text-gray-500 ml-2">(<?php echo e(__('Click to view visual map')); ?>)</span></h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Capital (3) -->
            <a href="<?php echo e(route('admin.dashboard.visual', 3)); ?>" class="block group">
                <div
                    class="bg-white rounded-lg shadow-sm p-6 border-l-4 border-emerald-500 group-hover:shadow-md transition-all group-hover:translate-y-[-2px]">
                    <div class="flex justify-between items-center mb-4">
                        <h4 class="font-bold text-gray-800 group-hover:text-emerald-600 transition-colors">
                            <?php echo e(__('Capital Project')); ?>

                        </h4>
                        <i class="entypo-layout text-gray-300 group-hover:text-emerald-500"></i>
                    </div>
                    <div class="space-y-2">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500"><?php echo e(__('Allocated')); ?></span>
                            <span class="font-bold text-emerald-600"><?php echo e($allocations[3] ?? 0); ?></span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500"><?php echo e(__('Unallocated')); ?></span>
                            <span class="font-mono text-gray-400"><?php echo e($unallocated[3] ?? 0); ?></span>
                        </div>
                    </div>
                </div>
            </a>

            <!-- New Cairo (2) -->
            <a href="<?php echo e(route('admin.dashboard.visual', 2)); ?>" class="block group">
                <div
                    class="bg-white rounded-lg shadow-sm p-6 border-l-4 border-emerald-500 group-hover:shadow-md transition-all group-hover:translate-y-[-2px]">
                    <div class="flex justify-between items-center mb-4">
                        <h4 class="font-bold text-gray-800 group-hover:text-emerald-600 transition-colors">
                            <?php echo e(__('New Cairo Project')); ?>

                        </h4>
                        <i class="entypo-layout text-gray-300 group-hover:text-emerald-500"></i>
                    </div>
                    <div class="space-y-2">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500"><?php echo e(__('Allocated')); ?></span>
                            <span class="font-bold text-emerald-600"><?php echo e($allocations[2] ?? 0); ?></span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500"><?php echo e(__('Unallocated')); ?></span>
                            <span class="font-mono text-gray-400"><?php echo e($unallocated[2] ?? 0); ?></span>
                        </div>
                    </div>
                </div>
            </a>

            <!-- Heliopolis (1) -->
            <a href="<?php echo e(route('admin.dashboard.visual', 1)); ?>" class="block group">
                <div
                    class="bg-white rounded-lg shadow-sm p-6 border-l-4 border-emerald-500 group-hover:shadow-md transition-all group-hover:translate-y-[-2px]">
                    <div class="flex justify-between items-center mb-4">
                        <h4 class="font-bold text-gray-800 group-hover:text-emerald-600 transition-colors">
                            <?php echo e(__('Heliopolis Project')); ?>

                        </h4>
                        <i class="entypo-layout text-gray-300 group-hover:text-emerald-500"></i>
                    </div>
                    <div class="space-y-2">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500"><?php echo e(__('Allocated')); ?></span>
                            <span class="font-bold text-emerald-600"><?php echo e($allocations[1] ?? 0); ?></span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500"><?php echo e(__('Unallocated')); ?></span>
                            <span class="font-mono text-gray-400"><?php echo e($unallocated[1] ?? 0); ?></span>
                        </div>
                    </div>
                </div>
            </a>

            <!-- Nakheel (5) (Legacy map showed Nakheel/Sahel logic, putting Nakheel here based on array keys) -->
            <a href="<?php echo e(route('admin.dashboard.visual', 5)); ?>" class="block group">
                <div
                    class="bg-white rounded-lg shadow-sm p-6 border-l-4 border-emerald-500 group-hover:shadow-md transition-all group-hover:translate-y-[-2px]">
                    <div class="flex justify-between items-center mb-4">
                        <h4 class="font-bold text-gray-800 group-hover:text-emerald-600 transition-colors">
                            <?php echo e(__('Nakheel Project')); ?>

                        </h4>
                        <i class="entypo-layout text-gray-300 group-hover:text-emerald-500"></i>
                    </div>
                    <div class="space-y-2">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500"><?php echo e(__('Allocated')); ?></span>
                            <span class="font-bold text-emerald-600"><?php echo e($allocations[5] ?? 0); ?></span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500"><?php echo e(__('Unallocated')); ?></span>
                            <span class="font-mono text-gray-400"><?php echo e($unallocated[5] ?? 0); ?></span>
                        </div>
                    </div>
                </div>
            </a>

            <!-- Sahel (4) -->
            <a href="<?php echo e(route('admin.dashboard.visual', 4)); ?>" class="block group">
                <div
                    class="bg-white rounded-lg shadow-sm p-6 border-l-4 border-emerald-500 group-hover:shadow-md transition-all group-hover:translate-y-[-2px]">
                    <div class="flex justify-between items-center mb-4">
                        <h4 class="font-bold text-gray-800 group-hover:text-emerald-600 transition-colors">
                            <?php echo e(__('Sahel Project')); ?>

                        </h4>
                        <i class="entypo-layout text-gray-300 group-hover:text-emerald-500"></i>
                    </div>
                    <div class="space-y-2">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500"><?php echo e(__('Allocated')); ?></span>
                            <span class="font-bold text-emerald-600"><?php echo e($allocations[4] ?? 0); ?></span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500"><?php echo e(__('Unallocated')); ?></span>
                            <span class="font-mono text-gray-400"><?php echo e($unallocated[4] ?? 0); ?></span>
                        </div>
                    </div>
                </div>
            </a>
        </div>

        <!-- Financials (Deposits) -->
        <h3 class="text-lg font-semibold text-gray-700 mb-4 border-b pb-2"><?php echo e(__('Total Deposits')); ?></h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Capital (3) -->
            <div class="bg-white rounded-lg shadow-sm p-6 border-t-4 border-blue-500">
                <div class="text-2xl font-bold text-gray-800 mb-1"><?php echo e(number_format($deposits[3] ?? 0)); ?></div>
                <div class="text-sm text-gray-500"><?php echo e(__('Capital Project')); ?></div>
            </div>

            <!-- New Cairo (2) -->
            <div class="bg-white rounded-lg shadow-sm p-6 border-t-4 border-blue-500">
                <div class="text-2xl font-bold text-gray-800 mb-1"><?php echo e(number_format($deposits[2] ?? 0)); ?></div>
                <div class="text-sm text-gray-500"><?php echo e(__('New Cairo Project')); ?></div>
            </div>

            <!-- Heliopolis (1) -->
            <div class="bg-white rounded-lg shadow-sm p-6 border-t-4 border-blue-500">
                <div class="text-2xl font-bold text-gray-800 mb-1"><?php echo e(number_format($deposits[1] ?? 0)); ?></div>
                <div class="text-sm text-gray-500"><?php echo e(__('Heliopolis Project')); ?></div>
            </div>

            <!-- Total -->
            <div class="bg-white rounded-lg shadow-sm p-6 border-t-4 border-indigo-600 bg-indigo-50">
                <div class="text-2xl font-bold text-indigo-800 mb-1"><?php echo e(number_format($total_deposits)); ?></div>
                <div class="text-sm text-indigo-600"><?php echo e(__('All Projects')); ?></div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/dashboard/index.blade.php ENDPATH**/ ?>