

<?php $__env->startSection('content'); ?>
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800"><?php echo e(__('Audit Logs')); ?></h1>
            <div class="text-sm text-gray-500"><?php echo e(__('Snapshots saved on various actions')); ?></div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <table class="w-full text-start">
                <thead class="bg-gray-50 text-sm font-semibold text-gray-600">
                    <tr>
                        <th class="px-6 py-4 text-start"><?php echo e(__('Context / ID')); ?></th>
                        <th class="px-6 py-4 text-start"><?php echo e(__('Type')); ?></th>
                        <th class="px-6 py-4 text-start"><?php echo e(__('Snapshot Data')); ?></th>
                        <th class="px-6 py-4 text-start"><?php echo e(__('Action Date')); ?></th>
                        <th class="px-6 py-4 text-start"><?php echo e(__('Registered By')); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-50 transition duration-150">
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900"><?php echo e($log->employee->arabic_name ?? __('N/A')); ?>

                                </div>
                                <div class="text-xs text-gray-500"><?php echo e(__('Ref ID')); ?>: <?php echo e($log->emp_id); ?></div>
                            </td>
                            <td class="px-6 py-4">
                                <?php
                                    $typeColor = match (strtolower($log->type)) {
                                        'salary' => 'bg-green-100 text-green-700',
                                        'bonus' => 'bg-blue-100 text-blue-700',
                                        'print order' => 'bg-purple-100 text-purple-700',
                                        'add_client' => 'bg-emerald-100 text-emerald-700',
                                        'add_reservation' => 'bg-indigo-100 text-indigo-700',
                                        'delete_reservation' => 'bg-rose-100 text-rose-700',
                                        'add_receipt' => 'bg-orange-100 text-orange-700 border border-orange-200',
                                        'edit_receipt' => 'bg-amber-100 text-amber-700 border border-amber-200',
                                        'delete_receipt' => 'bg-red-100 text-red-700 border border-red-200',
                                        default => 'bg-gray-100 text-gray-700'
                                    };
                                ?>
                                <span
                                    class="px-2 py-1 <?php echo e($typeColor); ?> rounded text-[10px] font-bold uppercase whitespace-nowrap">
                                    <?php echo e(__($log->type)); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-xs text-gray-600 bg-gray-50 p-2 rounded">
                                    <ul class="grid grid-cols-2 gap-x-4">
                                        <?php if(is_array($log->snapshot)): ?>
                                            <?php $__currentLoopData = $log->snapshot; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><span class="font-semibold"><?php echo e(__(str_replace('_', ' ', $key))); ?>:</span>
                                                    <?php echo e(is_array($value) ? json_encode($value) : $value); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <li><?php echo e($log->snapshot); ?></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-500">
                                <?php echo e($log->created_at); ?>

                            </td>
                            <td class="px-6 py-4 text-sm text-gray-500">
                                <?php echo e($log->registrar->name ?? 'Admin'); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            <?php echo e($logs->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/hr/audit.blade.php ENDPATH**/ ?>