

<?php $__env->startSection('header'); ?>
    <?php echo e(__('Reports')); ?> / <?php echo e(__('Inquiry by Building')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white rounded-xl shadow-lg p-6">
        <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4 border-b border-gray-100 pb-6">
            <h2 class="text-2xl font-bold bg-gradient-to-r from-emerald-600 to-teal-600 bg-clip-text text-transparent">
                <?php echo e(__('Inquiry by Building')); ?>

            </h2>
        </div>

        <!-- Filters -->
        <div
            class="grid grid-cols-1 md:grid-cols-5 gap-6 mb-8 p-6 bg-emerald-50/30 rounded-2xl border border-emerald-100/50">
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2"><?php echo e(__('Select Project')); ?></label>
                <select id="prj_select"
                    class="w-full rounded-xl border-gray-200 focus:ring-emerald-500 focus:border-emerald-500 transition-all font-medium">
                    <option value="0"><?php echo e(__('Choose Project')); ?></option>
                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($project->prj_id); ?>"><?php echo e($project->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2"><?php echo e(__('Building')); ?></label>
                <select id="bldg_select"
                    class="w-full rounded-xl border-gray-200 focus:ring-emerald-500 focus:border-emerald-500 transition-all font-medium">
                    <option value="0"><?php echo e(__('All Buildings')); ?></option>
                </select>
            </div>

            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2"><?php echo e(__('Area')); ?></label>
                <select id="area_select"
                    class="w-full rounded-xl border-gray-200 focus:ring-emerald-500 focus:border-emerald-500 transition-all font-medium">
                    <option value="0"><?php echo e(__('All Areas')); ?></option>
                </select>
            </div>

            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2"><?php echo e(__('Unit Type')); ?></label>
                <select id="flt_select"
                    class="w-full rounded-xl border-gray-200 focus:ring-emerald-500 focus:border-emerald-500 transition-all font-medium">
                    <option value="0"><?php echo e(__('All Types')); ?></option>
                </select>
            </div>

            <div class="flex items-end">
                <button id="display_btn"
                    class="w-full bg-emerald-600 text-white px-6 py-2.5 rounded-xl hover:bg-emerald-700 transition duration-150 font-bold shadow-lg shadow-emerald-100 flex items-center justify-center gap-2">
                    <i class="entypo-chart-bar"></i> <?php echo e(__('Display Report')); ?>

                </button>
            </div>
        </div>

        <!-- Results Table -->
        <div class="overflow-x-auto rounded-xl border border-gray-100 hidden" id="report_container">
            <table id="report_table" class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr class="text-[10px] font-bold text-gray-500 uppercase tracking-widest text-center">
                        <th><?php echo e(__('Bldg')); ?></th>
                        <th><?php echo e(__('Floor')); ?></th>
                        <th><?php echo e(__('Unit')); ?></th>
                        <th><?php echo e(__('Area')); ?></th>
                        <th class="text-right"><?php echo e(__('Client Name')); ?></th>
                        <th><?php echo e(__('Memb. No')); ?></th>
                        <th><?php echo e(__('File No')); ?></th>
                        <th><?php echo e(__('Mobile')); ?></th>
                        <th><?php echo e(__('Address')); ?></th>
                        <th><?php echo e(__('Required')); ?></th>
                        <th><?php echo e(__('Paid')); ?></th>
                        <th><?php echo e(__('Remaining')); ?></th>
                        <th><?php echo e(__('Phase')); ?></th>
                        <th><?php echo e(__('Remainders')); ?></th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-100 text-sm">
                    <!-- Data injected via DataTables -->
                </tbody>
            </table>
        </div>

        <div id="loader" class="hidden py-20 text-center">
            <div class="inline-block animate-spin rounded-full h-12 w-12 border-4 border-emerald-500 border-t-transparent">
            </div>
            <p class="mt-4 text-gray-500 font-medium"><?php echo e(__('Calculating financial data...')); ?></p>
        </div>
    </div>

    <?php $__env->startPush('styles'); ?>
        <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
        <style>
            .dt-buttons {
                margin-bottom: 20px;
            }

            .dt-button {
                @apply px-4 py-2 bg-white border border-gray-200 rounded-lg text-sm font-medium hover:bg-gray-50 transition-all !important;
            }

            #report_table thead th {
                @apply px-3 py-4 border-r border-gray-100 last:border-r-0;
            }

            #report_table tbody td {
                @apply px-3 py-3 border-r border-gray-50 last:border-r-0 text-center;
            }

            .dataTables_wrapper .dataTables_filter input {
                @apply rounded-lg border-gray-200 text-sm focus:ring-emerald-500 focus:border-emerald-500;
            }
        </style>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

        <script>
            $(document).ready(function () {
                let table = null;

                $('#prj_select').change(function () {
                    const prj_id = $(this).val();
                    if (prj_id == 0) return;

                    // Load Buildings
                    $.post('<?php echo e(route("reports.get_buildings")); ?>', {
                        prj_id: prj_id,
                        _token: '<?php echo e(csrf_token()); ?>'
                    }, function (data) {
                        $('#bldg_select').html(data);
                    });

                    // Load Areas
                    $.post('<?php echo e(route("reports.get_areas")); ?>', {
                        prj_id: prj_id,
                        _token: '<?php echo e(csrf_token()); ?>'
                    }, function (data) {
                        $('#area_select').html(data);
                    });

                    // Load Units
                    $.post('<?php echo e(route("reports.get_flats")); ?>', {
                        prj_id: prj_id,
                        _token: '<?php echo e(csrf_token()); ?>'
                    }, function (data) {
                        $('#flt_select').html(data);
                    });
                });

                $('#display_btn').click(function () {
                    const prj_id = $('#prj_select').val();
                    if (prj_id == 0) {
                        alert('<?php echo e(__("Please select a project first")); ?>');
                        return;
                    }

                    $('#report_container').addClass('hidden');
                    $('#loader').removeClass('hidden');

                    if (table) {
                        table.destroy();
                        $('#report_table tbody').empty();
                    }

                    $.post('<?php echo e(route("reports.inquiry_by_building_data")); ?>', {
                        prj_id: prj_id,
                        bldg_id: $('#bldg_select').val(),
                        area: $('#area_select').val(),
                        flt_id: $('#flt_select').val(),
                        _token: '<?php echo e(csrf_token()); ?>'
                    }, function (response) {
                        $('#loader').addClass('hidden');
                        $('#report_container').removeClass('hidden');

                        table = $('#report_table').DataTable({
                            data: response.data,
                            columns: [
                                { data: 'bldg' },
                                { data: 'floor' },
                                { data: 'flat_num' },
                                { data: 'area' },
                                { data: 'name', className: 'text-right font-bold text-gray-900' },
                                { data: 'old_member_no', className: 'font-semibold text-emerald-700' },
                                { data: 'file_no' },
                                { data: 'mobile' },
                                { data: 'address', className: 'text-xs max-w-xs truncate' },
                                { data: 'required', className: 'font-bold' },
                                { data: 'paid', className: 'text-emerald-600 font-bold' },
                                { data: 'remaining', className: 'text-red-600 font-bold' },
                                { data: 'phase' },
                                { data: 'subsess' }
                            ],
                            dom: 'Bfrtip',
                            buttons: [
                                { extend: 'copy', className: 'bg-gray-100' },
                                { extend: 'excel', title: 'Building Inquiry Report', className: 'bg-emerald-50 text-emerald-700 border-emerald-200' },
                                { extend: 'pdf', title: 'Building Inquiry Report', orientation: 'landscape', className: 'bg-rose-50 text-rose-700 border-rose-200' },
                                { extend: 'print', className: 'bg-blue-50 text-blue-700 border-blue-200' }
                            ],
                            language: {
                                search: "_INPUT_",
                                searchPlaceholder: "<?php echo e(__('Search in results...')); ?>"
                            },
                            pageLength: 25,
                            ordering: true,
                            order: [[0, 'asc'], [1, 'asc'], [2, 'asc']]
                        });
                    });
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/reports/inquiry_by_building.blade.php ENDPATH**/ ?>