

<?php $__env->startSection('header'); ?>
    <?php echo e(__('Reports')); ?> / Receipt Review Report
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white rounded-xl shadow-lg p-6">
        <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4 border-b border-gray-100 pb-6">
            <h2 class="text-2xl font-bold bg-gradient-to-r from-orange-600 to-amber-600 bg-clip-text text-transparent">
                Receipt Review Report - Employee Errors
            </h2>
        </div>

        <!-- Results Table -->
        <div class="overflow-x-auto rounded-xl border border-gray-100">
            <table id="report_table" class="min-w-full divide-y divide-gray-200">
                <thead class="bg-amber-50/50">
                    <tr class="text-xs font-bold text-gray-500 uppercase tracking-widest text-center">
                        <th class="px-6 py-4">Employee Name</th>
                        <th class="px-6 py-4">Error Count</th>
                        <th class="px-6 py-4">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-100 text-sm">
                    <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="px-6 py-3 text-center font-semibold text-gray-900">
                                <?php echo e($employee->arabic_name ?? 'Unknown'); ?>

                            </td>
                            <td class="px-6 py-3 text-center">
                                <span
                                    class="inline-flex items-center px-3 py-1 rounded-full text-sm font-bold bg-orange-100 text-orange-700">
                                    <?php echo e($employee->cnt); ?>

                                </span>
                            </td>
                            <td class="px-6 py-3 text-center">
                                <button
                                    class="view-btn bg-orange-600 text-white px-4 py-2 rounded-lg hover:bg-orange-700 transition font-semibold"
                                    data-emp-id="<?php echo e($employee->emp_id); ?>">
                                    <i class="entypo-eye"></i> View Details
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal for Wrong Receipts -->
    <div id="detailsModal" class="hidden fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center">
        <div class="bg-white rounded-2xl shadow-2xl max-w-4xl w-full mx-4 max-h-[90vh] overflow-hidden">
            <div class="bg-gradient-to-r from-orange-600 to-amber-600 px-6 py-4 flex justify-between items-center">
                <h3 class="text-xl font-bold text-white">Wrong Receipts Details</h3>
                <button id="closeModal" class="text-white hover:text-gray-200 text-2xl font-bold">×</button>
            </div>
            <div id="modalContent" class="p-6 overflow-y-auto max-h-[70vh]">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>

    <?php $__env->startPush('styles'); ?>
        <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
        <style>
            .dt-buttons {
                margin-bottom: 20px;
            }

            .dt-button {
                @apply px-4 py-2 bg-white border border-gray-200 rounded-lg text-sm font-medium hover:bg-gray-50 transition-all !important;
            }

            #report_table thead th {
                @apply border-r border-gray-100 last:border-r-0;
            }

            #report_table tbody td {
                @apply border-r border-gray-50 last:border-r-0;
            }
        </style>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

        <script>
            $(document).ready(function () {
                $('#report_table').DataTable({
                    dom: 'Bfrtip',
                    buttons: [
                        { extend: 'copy', className: 'bg-gray-100' },
                        { extend: 'excel', title: 'Receipt Review Report', className: 'bg-orange-50 text-orange-700 border-orange-200' },
                        { extend: 'pdf', title: 'Receipt Review Report', className: 'bg-amber-50 text-amber-700 border-amber-200' },
                        { extend: 'print', className: 'bg-blue-50 text-blue-700 border-blue-200' }
                    ]
                });

                // View button click
                $('.view-btn').click(function () {
                    const empId = $(this).data('emp-id');

                    $('#modalContent').html('<div class="text-center py-8"><div class="inline-block animate-spin rounded-full h-12 w-12 border-4 border-orange-500 border-t-transparent"></div></div>');
                    $('#detailsModal').removeClass('hidden');

                    $.post('<?php echo e(route("reports.receipt_review_details")); ?>', {
                        emp_id: empId,
                        _token: '<?php echo e(csrf_token()); ?>'
                    }, function (data) {
                        $('#modalContent').html(data);
                    });
                });

                // Close modal
                $('#closeModal').click(function () {
                    $('#detailsModal').addClass('hidden');
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/reports/receipt_review_report.blade.php ENDPATH**/ ?>