

<?php $__env->startSection('content'); ?>
    <div class="container mx-auto px-4 py-6">
        <div class="flex flex-col md:flex-row justify-between items-center mb-6 gap-4">
            <div>
                <h1 class="text-2xl font-bold text-gray-800"><?php echo e($project->name); ?></h1>
            </div>
            <div>
                <a href="<?php echo e(route('admin.dashboard')); ?>"
                    class="px-4 py-2 bg-gray-100 text-gray-700 rounded-md hover:bg-gray-200 transition-colors">
                    <i class="entypo-left-open"></i> <?php echo e(__('Back to Dashboard')); ?>

                </a>
            </div>
        </div>

        <!-- Legend -->
        <div class="bg-white rounded-lg shadow-sm p-4 mb-8">
            <h3 class="text-sm font-semibold text-gray-700 mb-3 uppercase tracking-wider"><?php echo e(__('Legend')); ?></h3>
            <div class="flex flex-wrap gap-4">
                <div class="flex items-center gap-2">
                    <span class="w-4 h-4 bg-[#F00] rounded"></span>
                    <span class="text-[12px] text-gray-600"><?php echo e(__('Phase 1')); ?></span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-4 h-4 bg-[#2d3aa1] rounded"></span>
                    <span class="text-[12px] text-gray-600"><?php echo e(__('Phase 2')); ?></span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-4 h-4 bg-[#f5cb42] rounded"></span>
                    <span class="text-[12px] text-gray-600"><?php echo e(__('Phase 3')); ?></span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-4 h-4 bg-[#42f551] rounded"></span>
                    <span class="text-[12px] text-gray-600"><?php echo e(__('Sub-Session')); ?></span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-4 h-4 bg-[#03fcf0] rounded"></span>
                    <span class="text-[12px] text-gray-600"><?php echo e(__('Tebarose Society')); ?></span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-4 h-4 bg-white border border-emerald-400 border-dashed rounded"></span>
                    <span class="text-[12px] text-emerald-600 font-medium"><?php echo e(__('Available')); ?></span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-4 h-4 bg-yellow-300 rounded lamp"></span>
                    <span class="text-[12px] text-gray-600"><?php echo e(__('Temporary')); ?></span>
                </div>
            </div>
        </div>

        <!-- Areas Loop -->
        <?php $__currentLoopData = $groupings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $areaLabel => $buildings): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mb-12">
                <div class="flex items-center gap-3 mb-6 bg-gray-100 p-3 rounded-lg border-l-4 border-emerald-500">
                    <i class="entypo-layout text-emerald-600 text-xl"></i>
                    <h2 class="text-xl font-bold text-gray-700"><?php echo e($areaLabel); ?></h2>
                </div>

                <!-- Buildings Grid: 4 per row -->
                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
                    <?php $__currentLoopData = $buildings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bLabel => $units): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div
                            class="bg-white rounded-xl shadow-sm overflow-hidden flex flex-col border border-gray-100 hover:shadow-md transition-shadow">
                            <!-- Header -->
                            <div class="bg-gray-50 px-4 py-2 border-b border-gray-100 flex justify-between items-center">
                                <h3 class="font-bold text-gray-700 text-sm"><?php echo e(str_replace('Bldg', __('Bldg'), $bLabel)); ?></h3>
                                <span class="text-[10px] bg-white text-gray-500 border px-2 py-0.5 rounded-full"><?php echo e(count($units)); ?>

                                    U</span>
                            </div>

                            <!-- Units Grid: 4 per row -->
                            <div class="p-4">
                                <div class="grid grid-cols-4 gap-1.5">
                                    <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $isReserved = $unit->is_reserved;
                                            $isTebarose = $unit->client_member_no && str_contains($unit->client_member_no, '2372');
                                            $isTemp = $unit->res_kind === 0 || $unit->res_kind === "0";

                                            $colorClass = 'bg-white border-emerald-400 border-dashed text-emerald-600';
                                            $textClass = 'text-emerald-600';

                                            if ($isReserved) {
                                                if ($isTebarose)
                                                    $colorClass = 'bg-[#03fcf0] text-gray-800';
                                                elseif ($unit->subsess == 1)
                                                    $colorClass = 'bg-[#42f551] text-gray-800';
                                                elseif ($unit->sess == 1)
                                                    $colorClass = 'bg-[#F00] text-white';
                                                elseif ($unit->sess == 2)
                                                    $colorClass = 'bg-[#2d3aa1] text-white';
                                                elseif ($unit->sess == 3)
                                                    $colorClass = 'bg-[#f5cb42] text-white';
                                                else
                                                    $colorClass = 'bg-gray-200 text-gray-700';

                                                $textClass = str_contains($colorClass, 'text-white') ? 'text-white' : 'text-gray-800';
                                            }

                                            $extraClasses = $isTemp ? ' lamp' : '';
                                            $unitKey = $unit->bldg_id . '-' . $unit->flat_num;
                                            $title = $isReserved ? "عضويه: " . $unit->client_member_no . "\nالاسم: " . $unit->arabic_name : __('Available') . ' ' . $unit->flat_num;
                                        ?>

                                        <?php if($isReserved): ?>
                                            <a href="<?php echo e($unit->client_id ? route('clients.show', $unit->client_id) : '#'); ?>"
                                                class="unit-box aspect-square flex justify-center items-center rounded-sm <?php echo e($colorClass); ?> <?php echo e($extraClasses); ?> transition-all transform hover:scale-105 group relative text-center no-underline z-0 hover:z-10 unit-<?php echo e($unitKey); ?>"
                                                title="<?php echo e($title); ?>" data-unit="<?php echo e($unitKey); ?>">
                                                <span class="text-[9px] font-bold"><?php echo e($unit->flat_num); ?></span>
                                            </a>
                                        <?php else: ?>
                                            <button type="button"
                                                onclick="openReserveModal('<?php echo e($unit->flat_num); ?>', '<?php echo e($unit->bldg_id); ?>', '<?php echo e($unit->floor); ?>')"
                                                class="unit-box aspect-square flex justify-center items-center rounded-sm <?php echo e($colorClass); ?> <?php echo e($extraClasses); ?> transition-all transform hover:scale-105 unit-<?php echo e($unitKey); ?>"
                                                title="<?php echo e($title); ?>" data-unit="<?php echo e($unitKey); ?>">
                                                <span class="text-[9px] font-bold"><?php echo e($unit->flat_num); ?></span>
                                            </button>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php if(empty($groupings)): ?>
            <div class="w-full py-12 text-center text-gray-500">
                <i class="entypo-info-circled text-4xl mb-4 block"></i>
                <?php echo e(__('No visual data found for this project.')); ?>

            </div>
        <?php endif; ?>
    </div>

    <!-- Modal & Scripts from previous version preserved ... -->
    <!-- [Rest of the modal and script content] -->

    <!-- Reservation Modal -->
    <div id="reserveModal"
        class="hidden fixed inset-0 z-50 overflow-auto bg-black bg-opacity-50 flex items-center justify-center p-4 backdrop-blur-sm">
        <div
            class="bg-white rounded-xl shadow-2xl w-full max-w-lg transform transition-all animate-in fade-in zoom-in duration-300">
            <div class="border-b px-6 py-4 flex justify-between items-center bg-gray-50 rounded-t-xl">
                <h3 class="text-xl font-bold text-gray-800 flex items-center gap-2">
                    <i class="entypo-home text-emerald-500"></i>
                    <?php echo e(__('New Reservation')); ?>

                </h3>
                <button onclick="closeReserveModal()" class="text-gray-400 hover:text-gray-600 transition-colors">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>

            <form id="reserveForm" onsubmit="submitReservation(event)">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="prj_id" value="<?php echo e($project->prj_id); ?>">
                <input type="hidden" name="bldg_id" id="modal_bldg_id">
                <input type="hidden" name="flat_num" id="modal_flat_num">
                <input type="hidden" name="floor" id="modal_floor">

                <div class="p-6 space-y-5">
                    <div class="bg-emerald-50 border border-emerald-100 rounded-lg p-3 flex justify-around text-center">
                        <div>
                            <div class="text-xs text-emerald-600 uppercase font-bold"><?php echo e(__('Building')); ?></div>
                            <div class="text-lg font-bold text-emerald-800" id="display_bldg"></div>
                        </div>
                        <div>
                            <div class="text-xs text-emerald-600 uppercase font-bold"><?php echo e(__('Unit')); ?></div>
                            <div class="text-lg font-bold text-emerald-800" id="display_unit"></div>
                        </div>
                        <div>
                            <div class="text-xs text-emerald-600 uppercase font-bold"><?php echo e(__('Floor')); ?></div>
                            <div class="text-lg font-bold text-emerald-800" id="display_floor"></div>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2"><?php echo e(__('Select Client')); ?></label>
                        <div class="relative">
                            <input type="text" id="clientSearch"
                                class="w-full px-4 py-3 rounded-lg border border-gray-300 pr-10 outline-none"
                                placeholder="<?php echo e(__('Search...')); ?>" onkeyup="filterClients()">
                            <div class="absolute right-3 top-3.5 text-gray-400"><i class="entypo-search"></i></div>
                        </div>
                        <select name="cl_id" id="cl_id" required
                            class="mt-2 w-full px-4 py-3 rounded-lg border border-gray-300 appearance-none bg-white outline-none">
                            <option value=""><?php echo e(__('-- Choose Client --')); ?></option>
                            <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($c->cl_id); ?>"
                                    data-search="<?php echo e(mb_strtolower($c->arabic_name . ' ' . $c->member_no)); ?>">
                                    <?php echo e($c->member_no); ?> - <?php echo e($c->arabic_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2"><?php echo e(__('Date')); ?></label>
                        <input type="text" name="resv_date" value="<?php echo e(date('d-m-Y h:i:sa')); ?>"
                            class="w-full px-4 py-3 rounded-lg border border-gray-300 outline-none bg-gray-50">
                    </div>
                </div>

                <div class="bg-gray-50 px-6 py-4 rounded-b-xl border-t flex justify-end gap-3">
                    <button type="button" onclick="closeReserveModal()"
                        class="px-6 py-2.5 bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 font-bold transition-all"><?php echo e(__('Cancel')); ?></button>
                    <button type="submit"
                        class="px-8 py-2.5 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 font-bold transition-all"><?php echo e(__('Confirm')); ?></button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function openReserveModal(unit, bldg, floor) {
            document.getElementById('modal_flat_num').value = unit;
            document.getElementById('modal_bldg_id').value = bldg;
            document.getElementById('modal_floor').value = floor;
            document.getElementById('display_unit').innerText = unit;
            document.getElementById('display_bldg').innerText = bldg == '0' ? '-' : bldg;
            document.getElementById('display_floor').innerText = floor;
            document.getElementById('reserveModal').classList.remove('hidden');
            document.body.style.overflow = 'hidden';
        }
        function closeReserveModal() {
            document.getElementById('reserveModal').classList.add('hidden');
            document.body.style.overflow = 'auto';
        }
        function filterClients() {
            const input = document.getElementById('clientSearch').value.toLowerCase();
            const select = document.getElementById('cl_id');
            const options = select.options;
            for (let i = 1; i < options.length; i++) {
                const text = options[i].getAttribute('data-search');
                options[i].style.display = text.includes(input) ? '' : 'none';
            }
        }
        async function submitReservation(event) {
            event.preventDefault();
            const form = event.target;
            const clientId = form.cl_id.value;
            const formData = new FormData(form);
            const url = `/admin/clients/${clientId}/reservations-add`;
            const btn = form.querySelector('button[type="submit"]');
            btn.disabled = true;
            try {
                const response = await fetch(url, {
                    method: 'POST',
                    headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>', 'Accept': 'application/json', 'X-Requested-With': 'XMLHttpRequest' },
                    body: formData
                });
                const result = await response.json();
                if (result.success) { alert('<?php echo e(__("Success!")); ?>'); window.location.reload(); }
                else { alert(result.error || 'Error'); }
            } catch (e) { alert('Error'); } finally { btn.disabled = false; }
        }
        window.onclick = function (e) { if (e.target.id == 'reserveModal') closeReserveModal(); }

        document.addEventListener('DOMContentLoaded', function () {
            const duplixData = <?php echo json_encode($duplix_arr, 15, 512) ?>;
            duplixData.forEach(d => {
                const parts = d.split('|');
                const unit1El = document.querySelector(`.unit-${parts[0]}`);
                const unit2El = document.querySelector(`.unit-${parts[1]}`);

                if (unit1El && unit2El) {
                    unit1El.classList.add('duplix-master');
                    unit1El.style.position = 'relative';
                    unit1El.innerHTML += '<span class="absolute -top-1 -right-1 bg-black text-white text-[7px] px-1 rounded shadow-sm z-20">DUP</span>';

                    unit2El.classList.add('opacity-40');
                    unit2El.title = "<?php echo e(__('Duplex Part')); ?> - " + unit2El.title;
                }
            });
        });
    </script>

    <style>
        @keyframes zoom-in {
            from {
                opacity: 0;
                transform: scale(0.95);
            }

            to {
                opacity: 1;
                transform: scale(1);
            }
        }

        @keyframes flash {

            0%,
            50% {
                background-color: #FFF;
                color: #000;
            }

            51%,
            100% {
                background-color: #ebe709;
                color: #000;
            }
        }

        .animate-in {
            animation: zoom-in 0.2s ease-out;
        }

        .lamp {
            animation: flash 0.5s infinite;
            border: 1px solid #d97706 !important;
        }

        .unit-box {
            text-decoration: none !important;
            cursor: pointer;
        }

        .duplix-master {
            box-shadow: 0 0 0 2px #000;
            z-index: 10;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/dashboard/visual.blade.php ENDPATH**/ ?>