

<?php $__env->startSection('content'); ?>
    <div class="max-w-6xl mx-auto space-y-6">
        <!-- Client Info Card -->
        <div class="bg-white rounded-2xl shadow-xl border border-blue-100 overflow-hidden">
            <div class="bg-gradient-to-r from-blue-600 to-indigo-600 p-6 flex justify-between items-center text-white">
                <div>
                    <h2 class="text-2xl font-bold"><?php echo e(__('Client Checks')); ?></h2>
                    <p class="text-blue-50 text-sm mt-1">
                        <span class="font-bold"><?php echo e($client->arabic_name); ?></span>
                        <span class="mx-2 opacity-50">|</span>
                        <?php echo e(__('Membership No:')); ?> <?php echo e($client->old_member_no); ?>

                    </p>
                </div>
                <div class="text-right">
                    <div class="text-xs uppercase tracking-widest text-blue-200 font-bold"><?php echo e(__('Total Checks')); ?></div>
                    <div class="text-3xl font-black mt-1"><?php echo e(count($checks)); ?></div>
                </div>
            </div>

            <div class="p-8">
                <?php if($checks->isEmpty()): ?>
                    <div class="py-20 text-center bg-gray-50 rounded-2xl border border-gray-100">
                        <i class="entypo-docs text-4xl text-gray-300 block mb-2"></i>
                        <span class="text-gray-400 italic"><?php echo e(__('No checks found for this client.')); ?></span>
                    </div>
                <?php else: ?>
                    <div class="bg-white rounded-2xl border border-gray-100 overflow-hidden shadow-sm">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gradient-to-r from-gray-50 to-blue-50">
                                <tr class="text-xs font-bold text-gray-600 uppercase tracking-widest">
                                    <th class="px-6 py-4 text-left"><?php echo e(__('Check No.')); ?></th>
                                    <th class="px-6 py-4 text-left"><?php echo e(__('Bank')); ?></th>
                                    <th class="px-6 py-4 text-right"><?php echo e(__('Amount')); ?></th>
                                    <th class="px-6 py-4 text-center"><?php echo e(__('Issue Date')); ?></th>
                                    <th class="px-6 py-4 text-center"><?php echo e(__('Printed By')); ?></th>
                                    <th class="px-6 py-4 text-center"><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100 bg-white">
                                <?php $__currentLoopData = $checks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $check): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="hover:bg-blue-50/30 transition-colors group">
                                        <td class="px-6 py-4">
                                            <div class="flex items-center">
                                                <i class="entypo-doc-text text-blue-500 mr-2 text-lg"></i>
                                                <span class="font-bold text-gray-800"><?php echo e($check->bank_acc ?? 'N/A'); ?></span>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="text-sm font-medium text-gray-700"><?php echo e($check->bank ?? 'N/A'); ?></div>
                                        </td>
                                        <td class="px-6 py-4 text-right">
                                            <div
                                                class="inline-flex items-center px-3 py-1 bg-emerald-50 border border-emerald-200 rounded-lg">
                                                <span
                                                    class="text-sm font-black text-emerald-700"><?php echo e(number_format($check->amount, 2)); ?></span>
                                                <span class="text-xs text-emerald-600 ml-1">EGP</span>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 text-center">
                                            <div class="text-xs text-gray-500 font-medium"><?php echo e($check->crdate ?? '-'); ?></div>
                                        </td>
                                        <td class="px-6 py-4 text-center">
                                            <div
                                                class="text-xs text-gray-600 font-medium bg-gray-100 px-2 py-1 rounded inline-block">
                                                <?php echo e($check->prn_by ?? '-'); ?>

                                            </div>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div
                                                class="flex justify-center gap-2 opacity-0 group-hover:opacity-100 transition-opacity">
                                                <button class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors"
                                                    title="<?php echo e(__('View Details')); ?>">
                                                    <i class="entypo-eye"></i>
                                                </button>
                                                <button class="p-2 text-amber-600 hover:bg-amber-50 rounded-lg transition-colors"
                                                    title="<?php echo e(__('Edit')); ?>">
                                                    <i class="entypo-pencil"></i>
                                                </button>
                                                <button
                                                    class="p-2 text-red-600 hover:bg-red-50 rounded-lg transition-colors delete-check"
                                                    data-member="<?php echo e($client->old_member_no); ?>" data-check="<?php echo e($check->bank_acc); ?>"
                                                    title="<?php echo e(__('Delete')); ?>">
                                                    <i class="entypo-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const deleteButtons = document.querySelectorAll('.delete-check');

            deleteButtons.forEach(btn => {
                btn.addEventListener('click', function () {
                    const memberNo = this.dataset.member;
                    const checkNum = this.dataset.check;

                    if (!confirm('<?php echo e(__('Are you sure you want to delete this check?')); ?>')) {
                        return;
                    }

                    // Legacy style AJAX call (to match legacy system)
                    fetch('<?php echo e(url('admin/clients/delete-check')); ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        },
                        body: JSON.stringify({
                            old_member_no: memberNo,
                            chk_num: checkNum
                        })
                    })
                        .then(res => res.json())
                        .then(data => {
                            alert('<?php echo e(__('Check deleted successfully')); ?>');
                            location.reload();
                        })
                        .catch(err => {
                            alert('<?php echo e(__('Error deleting check')); ?>');
                            console.error(err);
                        });
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/clients/checks.blade.php ENDPATH**/ ?>