

<?php $__env->startSection('header'); ?>
    <?php echo e(__('Reports')); ?> / تفاصيل مدفوعات المشاريع
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white rounded-xl shadow-lg p-6">
        <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4 border-b border-gray-100 pb-6">
            <h2 class="text-2xl font-bold bg-gradient-to-r from-emerald-600 to-teal-600 bg-clip-text text-transparent">
                تفاصيل مدفوعات المشاريع
            </h2>
        </div>

        <!-- Filters -->
        <div
            class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8 p-6 bg-emerald-50/30 rounded-2xl border border-emerald-100/50">
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2"><?php echo e(__('Select Project')); ?></label>
                <select id="prj_select"
                    class="w-full rounded-xl border-gray-200 focus:ring-emerald-500 focus:border-emerald-500 transition-all font-medium">
                    <option value="0">اختر المشروع</option>
                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($project->prj_id); ?>"><?php echo e($project->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">تاريخ من:</label>
                <input type="date" id="date_from"
                    class="w-full rounded-xl border-gray-200 focus:ring-emerald-500 focus:border-emerald-500 transition-all font-medium">
            </div>

            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">تاريخ إلى:</label>
                <input type="date" id="date_to"
                    class="w-full rounded-xl border-gray-200 focus:ring-emerald-500 focus:border-emerald-500 transition-all font-medium">
            </div>

            <div class="md:col-span-1">
                <label class="block text-sm font-semibold text-gray-700 mb-2">العميل:</label>
                <select id="client_select"
                    class="w-full rounded-xl border-gray-200 focus:ring-emerald-500 focus:border-emerald-500 transition-all font-medium">
                    <option value="all">الكل</option>
                    <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($client->cl_id); ?>"><?php echo e($client->arabic_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>

        <div class="flex justify-end mb-6">
            <button id="display_btn"
                class="bg-emerald-600 text-white px-8 py-2.5 rounded-xl hover:bg-emerald-700 transition duration-150 font-bold shadow-lg shadow-emerald-100 flex items-center gap-2">
                <i class="entypo-chart-bar"></i> عرض التقرير
            </button>
        </div>

        <!-- Results Table -->
        <div class="overflow-x-auto rounded-xl border border-gray-100 hidden" id="report_container">
            <div class="text-center font-bold text-xl py-4 bg-emerald-50 border-b border-emerald-100">
                تفاصيل مدفوعات المشاريع
            </div>
            <table id="report_table" class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr class="text-[10px] font-bold text-gray-500 uppercase tracking-widest text-center">
                        <th>رقم الملف</th>
                        <th>أسم العميل</th>
                        <th>رقم العضويه</th>
                        <th>الوحده / المساحه</th>
                        <th>المشروع</th>
                        <th>المدفوعات</th>
                        <th>نوع الايصال</th>
                        <th>تاريخ الايصال</th>
                        <th>رقم الحركه</th>
                        <th>رقم الايصال البنكى</th>
                        <th>الحساب</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-100 text-sm">
                    <!-- Data injected via DataTables -->
                </tbody>
                <tfoot class="bg-emerald-50 font-bold">
                    <tr>
                        <td colspan="5" class="px-3 py-4 text-right text-gray-900">الإجمالى</td>
                        <td id="total_value" class="px-3 py-4 text-center text-emerald-700 text-lg">0</td>
                        <td colspan="5"></td>
                    </tr>
                </tfoot>
            </table>
        </div>

        <div id="loader" class="hidden py-20 text-center">
            <div class="inline-block animate-spin rounded-full h-12 w-12 border-4 border-emerald-500 border-t-transparent">
            </div>
            <p class="mt-4 text-gray-500 font-medium">جاري تحميل البيانات...</p>
        </div>
    </div>

    <?php $__env->startPush('styles'); ?>
        <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
        <style>
            .dt-buttons {
                margin-bottom: 20px;
            }

            .dt-button {
                @apply px-4 py-2 bg-white border border-gray-200 rounded-lg text-sm font-medium hover:bg-gray-50 transition-all !important;
            }

            #report_table thead th {
                @apply px-3 py-4 border-r border-gray-100 last:border-r-0;
            }

            #report_table tbody td {
                @apply px-3 py-3 border-r border-gray-50 last:border-r-0 text-center;
            }

            #report_table tfoot td {
                @apply px-3 py-4 border-r border-gray-100 last:border-r-0 text-center;
            }

            .dataTables_wrapper .dataTables_filter input {
                @apply rounded-lg border-gray-200 text-sm focus:ring-emerald-500 focus:border-emerald-500;
            }
        </style>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

        <script>
            $(document).ready(function () {
                let table = null;

                $('#display_btn').click(function () {
                    const prj_id = $('#prj_select').val();
                    if (prj_id == 0) {
                        alert('يرجى اختيار المشروع أولاً');
                        return;
                    }

                    $('#report_container').addClass('hidden');
                    $('#loader').removeClass('hidden');

                    if (table) {
                        table.destroy();
                        $('#report_table tbody').empty();
                    }

                    $.post('<?php echo e(route("reports.project_payments_data")); ?>', {
                        prj_id: prj_id,
                        date_from: $('#date_from').val(),
                        date_to: $('#date_to').val(),
                        cl_id: $('#client_select').val(),
                        _token: '<?php echo e(csrf_token()); ?>'
                    }, function (response) {
                        $('#loader').addClass('hidden');
                        $('#report_container').removeClass('hidden');
                        $('#total_value').text(response.total);

                        table = $('#report_table').DataTable({
                            data: response.data,
                            columns: [
                                { data: 'file_no' },
                                { data: 'arabic_name', className: 'text-right font-bold text-gray-900' },
                                { data: 'old_member_no', className: 'font-semibold text-emerald-700' },
                                { data: 'flat_name' },
                                { data: 'project_name' },
                                { data: 'value', className: 'font-bold text-emerald-600' },
                                { data: 'receipt_type' },
                                { data: 'date' },
                                { data: 'number' },
                                { data: 'bnk_number' },
                                {
                                    data: null,
                                    render: function (data, type, row) {
                                        return (row.bank_name || '') + '<br><span class="text-xs text-gray-500">' + (row.account_number || '') + '</span>';
                                    }
                                }
                            ],
                            dom: 'Bfrtip',
                            buttons: [
                                { extend: 'copy', className: 'bg-gray-100', footer: true },
                                { extend: 'excel', title: 'تفاصيل مدفوعات المشاريع', className: 'bg-emerald-50 text-emerald-700 border-emerald-200', footer: true },
                                { extend: 'csv', footer: true },
                                { extend: 'pdf', title: 'تفاصيل مدفوعات المشاريع', orientation: 'landscape', className: 'bg-rose-50 text-rose-700 border-rose-200', footer: true },
                                { extend: 'print', className: 'bg-blue-50 text-blue-700 border-blue-200', footer: true }
                            ],
                            language: {
                                search: "_INPUT_",
                                searchPlaceholder: "بحث في النتائج..."
                            },
                            pageLength: 25,
                            ordering: true,
                            order: [[0, 'asc']]
                        });
                    });
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/reports/project_payment_details.blade.php ENDPATH**/ ?>