

<?php $__env->startSection('content'); ?>
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800"><?php echo e(__('Vacations & Leaves')); ?></h1>
            <button class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700"><?php echo e(__('Request Leave')); ?></button>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <table class="w-full text-start">
                <thead class="bg-gray-50 text-sm font-semibold text-gray-600">
                    <tr>
                        <th class="px-6 py-4 text-start"><?php echo e(__('Employee')); ?></th>
                        <th class="px-6 py-4 text-start"><?php echo e(__('Type')); ?></th>
                        <th class="px-6 py-4 text-start"><?php echo e(__('From')); ?></th>
                        <th class="px-6 py-4 text-start"><?php echo e(__('To')); ?></th>
                        <th class="px-6 py-4 <?php echo e(app()->getLocale() == 'ar' ? 'text-left' : 'text-right'); ?>">
                            <?php echo e(__('Duration')); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__currentLoopData = $vacations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vac): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $start = \Carbon\Carbon::parse($vac->date_from);
                            $end = \Carbon\Carbon::parse($vac->date_to);
                            $days = $start->diffInDays($end) + 1;
                        ?>
                        <tr class="hover:bg-gray-50 transition duration-150">
                            <td class="px-6 py-4 text-sm font-medium text-gray-900"><?php echo e($vac->employee->arabic_name); ?></td>
                            <td class="px-6 py-4 text-sm">
                                <span
                                    class="px-2 py-1 <?php echo e($vac->type == 'vac' ? 'bg-green-50 text-green-700' : 'bg-red-50 text-red-700'); ?> rounded text-xs font-medium">
                                    <?php echo e($vac->type == 'vac' ? __('Vacation') : ($vac->type == 'sick' ? __('Sick Leave') : __(ucfirst($vac->type)))); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($vac->date_from); ?></td>
                            <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($vac->date_to); ?></td>
                            <td class="px-6 py-4 <?php echo e(app()->getLocale() == 'ar' ? 'text-left' : 'text-right'); ?>">
                                <span class="font-bold text-gray-700"><?php echo e($days); ?> <?php echo e(__('days')); ?></span>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/hr/vacations.blade.php ENDPATH**/ ?>