

<?php $__env->startSection('header'); ?>
    <?php echo e(__('Membership Form')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h2 class="text-2xl font-bold text-gray-900 mb-6">استماره طلب عضويه</h2>

        <div class="p-4 bg-blue-50 border border-blue-200 rounded-lg mb-6">
            <p class="text-sm"><i class="entypo-info"></i> املأ البيانات التالية لتقديم طلب عضوية جديد</p>
        </div>

        <table class="w-full">
            <tr>
                <td class="font-bold py-2 px-2">الاسم بالعربيه</td>
                <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="arabic_name" /></td>
                <td class="font-bold py-2 px-2">الاسم بالانجليزيه</td>
                <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="english_name" /></td>
            </tr>
            <tr>
                <td class="font-bold py-2 px-2">الرقم القومى</td>
                <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="nat_id" maxlength="14" />
                </td>
                <td class="font-bold py-2 px-2">رقم البطاقه العسكريه</td>
                <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="milit_card_id" /></td>
            </tr>
            <tr>
                <td class="font-bold py-2 px-2">العنوان</td>
                <td><textarea class="form-control w-full px-3 py-2 border rounded" name="address"></textarea></td>
                <td class="font-bold py-2 px-2">الجنسيه</td>
                <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="nationality"
                        value="مصرى" /></td>
            </tr>
            <tr>
                <td class="font-bold py-2 px-2">رقم الموبايل</td>
                <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="mobile" maxlength="11" />
                </td>
                <td class="font-bold py-2 px-2">النوع</td>
                <td>
                    <select class="form-control w-full px-3 py-2 border rounded" name="gender">
                        <?php $__currentLoopData = $genders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gender): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($gender['id']); ?>"><?php echo e($gender['name']); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
            </tr>
            <tr>
                <td class="font-bold py-2 px-2">المحافظه</td>
                <td>
                    <select class="form-control w-full px-3 py-2 border rounded" name="city">
                        <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($state['id']); ?>"><?php echo e($state['name']); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td class="font-bold py-2 px-2">الحى</td>
                <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="state" /></td>
            </tr>
            <tr>
                <td class="font-bold py-2 px-2">البريد الاليكترونى</td>
                <td><input type="email" class="form-control w-full px-3 py-2 border rounded" name="email" /></td>
                <td class="font-bold py-2 px-2">المؤهل</td>
                <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="cert" /></td>
            </tr>
            <tr>
                <td colspan="4" class="text-center pt-6">
                    <button class="bg-emerald-600 text-white px-6 py-2 rounded-lg hover:bg-emerald-700">
                        <i class="entypo-download"></i> حفظ
                    </button>
                </td>
            </tr>
        </table>

        <?php if($members->count() > 0): ?>
            <hr class="my-8">
            <h3 class="text-xl font-bold mb-4">طلبات العضوية المسجلة</h3>
            <table class="w-full border-collapse">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="border p-2">الاسم</th>
                        <th class="border p-2">الرقم القومى</th>
                        <th class="border p-2">رقم الموبايل</th>
                        <th class="border p-2">أجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="border p-2"><?php echo e($member->arabic_name); ?></td>
                            <td class="border p-2"><?php echo e($member->nat_id); ?></td>
                            <td class="border p-2"><?php echo e($member->mobile); ?></td>
                            <td class="border p-2 text-center">
                                <button class="bg-blue-600 text-white px-3 py-1 rounded hover:bg-blue-700 text-sm"
                                    onclick="window.print()">
                                    <i class="entypo-print"></i> طباعه
                                </button>
                                <button class="bg-emerald-600 text-white px-3 py-1 rounded hover:bg-emerald-700 text-sm ml-1">
                                    <i class="entypo-pencil"></i> تعديل
                                </button>
                                <button class="bg-red-600 text-white px-3 py-1 rounded hover:bg-red-700 text-sm ml-1">
                                    <i class="entypo-trash"></i> حذف
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/print/membership_form.blade.php ENDPATH**/ ?>