

<?php $__env->startSection('header'); ?>
    <?php echo e(__('Client Requests')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h1 class="text-2xl font-bold mb-6">طلبات العملاء</h1>

        <table class="w-full border-collapse" id="requests-table">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">رقم العضويه</th>
                    <th class="border p-2">الاسم العربى</th>
                    <th class="border p-2">الرقم القومى</th>
                    <th class="border p-2">نوع الطلب</th>
                    <th class="border p-2">الحاله</th>
                    <th class="border p-2">أجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $statuses = ['0' => 'تمت الموافقه', '1' => 'فى انتظار الموافقه', '3' => 'تم الرفض'];
                        $colors = ['0' => 'bg-green-200', '1' => 'bg-yellow-200', '3' => 'bg-red-200'];
                    ?>
                    <tr>
                        <td class="border p-2"><?php echo e($request->to_cl ?? $request->member_no); ?></td>
                        <td class="border p-2"><?php echo e($request->arabic_name); ?></td>
                        <td class="border p-2"><?php echo e($request->nat_id); ?></td>
                        <td class="border p-2"><?php echo e($request->type); ?></td>
                        <td class="border p-2 <?php echo e($colors[$request->tflag] ?? ''); ?>"><?php echo e($statuses[$request->tflag] ?? ''); ?></td>
                        <td class="border p-2">
                            <button
                                onclick="viewRequest('<?php echo e($request->to_cl); ?>', '<?php echo e($request->tfile_no); ?>', '<?php echo e($request->prj_id); ?>', '<?php echo e($request->tid); ?>', '<?php echo e($request->type); ?>', '<?php echo e($request->tflag); ?>')"
                                class="bg-blue-600 text-white px-3 py-1 rounded text-sm hover:bg-blue-700">
                                عرض
                            </button>
                            <button onclick="rejectRequest('<?php echo e($request->tid); ?>')"
                                class="bg-red-600 text-white px-3 py-1 rounded text-sm hover:bg-red-700 ml-1">
                                رفض
                            </button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <script>
        function viewRequest(to_cl, file_no, prj_id, id, type, status) {
            // Create form and submit to view request details
            const form = document.createElement('form');
            form.method = 'POST';
            form.target = '_blank';

            if (type === 'سحب مدخرات') {
                form.action = '<?php echo e(route("clients.withdrawal")); ?>';
            } else {
                form.action = '<?php echo e(route("clients.transfer_request")); ?>';
            }

            // Add CSRF token
            const csrfInput = document.createElement('input');
            csrfInput.type = 'hidden';
            csrfInput.name = '_token';
            csrfInput.value = '<?php echo e(csrf_token()); ?>';
            form.appendChild(csrfInput);

            // Add parameters
            ['file_no', 'prj_id', 'to_file_no', 'flag', 'id', 'type', 'status'].forEach((name, index) => {
                const input = document.createElement('input');
                input.type = 'hidden';
                input.name = name;
                input.value = [file_no, prj_id, to_cl, '1', id, type, status][index];
                form.appendChild(input);
            });

            document.body.appendChild(form);
            form.submit();
            document.body.removeChild(form);
        }

        function rejectRequest(id) {
            if (!confirm('هل أنت متأكد من رفض هذا الطلب؟')) return;

            fetch('<?php echo e(route("website.reject_request")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify({ id: id })
            })
                .then(response => response.json())
                .then(data => {
                    alert('تم الرفض');
                    location.reload();
                });
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\admin_laravel\resources\views/admin/website/client_requests.blade.php ENDPATH**/ ?>