<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ClientsController;
use App\Http\Controllers\HrController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ConstrController;
use App\Http\Controllers\ConsultController;
use App\Http\Controllers\GlobalSearchController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\DashboardController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    if (auth('admin')->check()) {
        return redirect()->route('admin.dashboard');
    }
    return redirect()->route('login');
});

Route::get('/login', [App\Http\Controllers\AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [App\Http\Controllers\AuthController::class, 'login'])->name('login.post');
Route::post('/logout', [App\Http\Controllers\AuthController::class, 'logout'])->name('logout');

Route::get('/lang/{locale}', function ($locale) {
    if (in_array($locale, ['en', 'ar'])) {
        session(['locale' => $locale]);
    }
    return redirect()->back();
})->name('lang.switch');

Route::middleware(['auth:admin'])->group(function () {
    Route::prefix('admin')->group(function () {

        // Dashboard
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
        Route::get('/dashboard/visual/{id}', [DashboardController::class, 'visual'])->name('admin.dashboard.visual');

        // Profile Management
        Route::get('/profile', [App\Http\Controllers\ProfileController::class, 'index'])->name('admin.profile');
        Route::post('/profile/update-info', [App\Http\Controllers\ProfileController::class, 'updateInfo'])->name('admin.profile.update_info');
        Route::post('/profile/update-password', [App\Http\Controllers\ProfileController::class, 'updatePassword'])->name('admin.profile.update_password');
        Route::post('/profile/update-image', [App\Http\Controllers\ProfileController::class, 'updateImage'])->name('admin.profile.update_image');
        Route::delete('/profile/delete-image', [App\Http\Controllers\ProfileController::class, 'deleteImage'])->name('admin.profile.delete_image');

        // Print Management
        Route::get('/print/empty-payment-order', [App\Http\Controllers\PrintController::class, 'emptyPaymentOrder'])->name('print.empty_payment');
        Route::get('/print/manual-payment-order', [App\Http\Controllers\PrintController::class, 'manualPaymentOrder'])->name('print.manual_payment');
        Route::get('/print/checks', [App\Http\Controllers\PrintController::class, 'printChecks'])->name('print.checks');
        Route::get('/print/membership-form', [App\Http\Controllers\PrintController::class, 'membershipForm'])->name('print.membership');
        Route::post('/print/number-to-text', [App\Http\Controllers\PrintController::class, 'numberToText'])->name('print.number_to_text');

        // Warning Letters
        Route::get('/letters/print-warnings', [App\Http\Controllers\LettersController::class, 'printWarnings'])->name('letters.print_warnings');
        Route::post('/letters/generate-letter', [App\Http\Controllers\LettersController::class, 'generateLetter'])->name('letters.generate');
        Route::post('/letters/delete-project-data', [App\Http\Controllers\LettersController::class, 'deleteProjectData'])->name('letters.delete_data');
        Route::post('/letters/review-project', [App\Http\Controllers\LettersController::class, 'reviewProject'])->name('letters.review');

        // Excel Import
        Route::get('/import/transactions', [App\Http\Controllers\ImportController::class, 'importTransactions'])->name('import.transactions');
        Route::post('/import/process-row', [App\Http\Controllers\ImportController::class, 'processRow'])->name('import.process_row');


        // Website Management
        Route::get('/website/requests', [App\Http\Controllers\WebsiteController::class, 'clientRequests'])->name('website.requests');
        Route::post('/website/reject-request', [App\Http\Controllers\WebsiteController::class, 'rejectRequest'])->name('website.reject_request');
        Route::get('/website/comments', [App\Http\Controllers\WebsiteController::class, 'clientComments'])->name('website.comments');
        Route::post('/website/get-comments', [App\Http\Controllers\WebsiteController::class, 'getComments'])->name('website.get_comments');
        Route::get('/website/uploads', [App\Http\Controllers\WebsiteController::class, 'uploadedFiles'])->name('website.uploads');
        Route::get('/website/area-changes', [App\Http\Controllers\WebsiteController::class, 'areaChangeRequests'])->name('website.area_changes');
        Route::get('/website/updates', [App\Http\Controllers\WebsiteController::class, 'clientUpdates'])->name('website.updates');

        // Clients Module
        Route::prefix('clients')->group(function () {
            // Client Search
            Route::get('/ajax-search', [App\Http\Controllers\ClientsController::class, 'ajaxSearch'])->name('clients.ajax_search');

            Route::get('/', [App\Http\Controllers\ClientsController::class, 'index'])->name('clients.index');
            Route::post('/store', [App\Http\Controllers\ClientsController::class, 'store'])->name('clients.store');
            Route::post('/check-existence', [App\Http\Controllers\ClientsController::class, 'checkExistence'])->name('clients.check_existence');
            Route::get('/comments/{id?}', [App\Http\Controllers\ClientsController::class, 'viewComments'])->name('clients.comments');
            Route::post('/comments/store', [App\Http\Controllers\ClientsController::class, 'storeComment'])->name('clients.comments.store');
            Route::get('/delay-pay/{id}', [App\Http\Controllers\ClientsController::class, 'delayPay'])->name('clients.delay_pay');

            // Garden Installments
            Route::get('/garden/create', [App\Http\Controllers\ClientsController::class, 'createGarden'])->name('clients.garden.create');
            Route::post('/garden/store', [App\Http\Controllers\ClientsController::class, 'saveGarden'])->name('clients.garden.store');
            Route::post('/garden/assign', [App\Http\Controllers\ClientsController::class, 'assignGarden'])->name('clients.reservations.assign_garden');
            Route::post('/garden/delete', [App\Http\Controllers\ClientsController::class, 'deleteGarden'])->name('clients.reservations.delete_garden');

            // Parking Installments
            Route::get('/parking/create', [App\Http\Controllers\ClientsController::class, 'createParking'])->name('clients.parking.create');
            Route::post('/parking/store', [App\Http\Controllers\ClientsController::class, 'saveParking'])->name('clients.parking.store');
            Route::post('/parking/update', [App\Http\Controllers\ClientsController::class, 'updateParking'])->name('clients.parking.update');

            // Transactions
            Route::post('/transaction/save', [App\Http\Controllers\ClientsController::class, 'saveTransaction'])->name('clients.transaction.save');

            // Refunds & Penalties
            Route::post('/refund', [App\Http\Controllers\ClientsController::class, 'refund'])->name('clients.refund');
            Route::post('/penalty/add', [App\Http\Controllers\ClientsController::class, 'addPenalty'])->name('clients.penalty.add');

            // Advanced Data Operations
            Route::post('/pending/process', [App\Http\Controllers\ClientsController::class, 'processPending'])->name('clients.pending.process');

            // Client Actions (Legacy Migration)
            Route::get('/{id}/reservations', [App\Http\Controllers\ClientsController::class, 'reservations'])->name('clients.reservations');
            Route::get('/{id}/account-statement', [App\Http\Controllers\ClientsController::class, 'accountStatement'])->name('clients.account_statement');
            Route::get('/{id}/checks', [App\Http\Controllers\ClientsController::class, 'checks'])->name('clients.checks');
            Route::get('/{id}/payments', [App\Http\Controllers\ClientsController::class, 'payments'])->name('clients.payments');
            Route::get('/{id}/documents', [App\Http\Controllers\ClientsController::class, 'documents'])->name('clients.documents');
            Route::get('/{id}/edit', [App\Http\Controllers\ClientsController::class, 'editClient'])->name('clients.edit');
            Route::post('/{id}/update', [App\Http\Controllers\ClientsController::class, 'updateClient'])->name('clients.update');
            Route::post('/move-savings', [App\Http\Controllers\ClientsController::class, 'moveSavings'])->name('clients.move_savings');
            Route::get('/{id}', [App\Http\Controllers\ClientsController::class, 'show'])->name('clients.show');
            Route::delete('/{id}', [App\Http\Controllers\ClientsController::class, 'deleteClient'])->name('clients.delete');

            // Receipt Management
            Route::post('/{id}/receipts', [App\Http\Controllers\ClientsController::class, 'addReceipt'])->name('clients.receipts.add');
            Route::put('/receipts/{id}', [App\Http\Controllers\ClientsController::class, 'updateReceipt'])->name('clients.receipts.update');
            Route::delete('/receipts/{id}', [App\Http\Controllers\ClientsController::class, 'deleteReceipt'])->name('clients.receipts.delete');
            Route::post('/receipts/bulk-delete', [App\Http\Controllers\ClientsController::class, 'bulkDeleteReceipts'])->name('clients.receipts.bulk_delete');
            Route::post('/receipts/check-number', [App\Http\Controllers\ClientsController::class, 'checkReceiptNumber'])->name('clients.receipts.check_number');
            Route::get('/receipts/generate-serial', [App\Http\Controllers\ClientsController::class, 'generateReceiptSerial'])->name('clients.receipts.generate_serial');
            Route::get('/receipts/generate-bank-serial', [App\Http\Controllers\ClientsController::class, 'generateBankSerial'])->name('clients.receipts.generate_bank_serial');
            Route::post('/receipts/{id}/lock', [App\Http\Controllers\ClientsController::class, 'lockReceipt'])->name('clients.receipts.lock');
            Route::post('/receipts/get-data', [App\Http\Controllers\ClientsController::class, 'getReceiptData'])->name('clients.receipts.get_data');
            Route::delete('/parking/{id}', [App\Http\Controllers\ClientsController::class, 'deleteParking'])->name('clients.parking.delete');

            // Reservations Management
            Route::get('/{id}/reservations-data', [App\Http\Controllers\ClientsController::class, 'getReservations'])->name('clients.reservations.get');
            Route::post('/{id}/reservations-add', [App\Http\Controllers\ClientsController::class, 'addReservation'])->name('clients.reservations.add');
            Route::get('/reservations/check-availability', [App\Http\Controllers\ClientsController::class, 'checkAvailability'])->name('clients.reservations.check_availability');
            Route::get('/reservations/get-projects', [App\Http\Controllers\ClientsController::class, 'getProjects'])->name('clients.reservations.get_projects');
            Route::get('/reservations/get-buildings', [App\Http\Controllers\ClientsController::class, 'getBuildings'])->name('clients.reservations.get_buildings');
            Route::delete('/reservations/delete', [App\Http\Controllers\ClientsController::class, 'deleteReservation'])->name('clients.reservations.delete');

            // Review Status
            Route::post('/{id}/review-status', [App\Http\Controllers\ClientsController::class, 'setReviewStatus'])->name('clients.review_status');

            // Auxiliary
            Route::post('/print-check', [App\Http\Controllers\ClientsController::class, 'printCheck'])->name('clients.print_check');

            // Data Views
            Route::get('/{memberNo}/live-data', [App\Http\Controllers\ClientsController::class, 'viewLiveData'])->name('clients.live_data');
            Route::get('/{memberNo}/old-data', [App\Http\Controllers\ClientsController::class, 'viewOldData'])->name('clients.old_data');

            // Auxiliary & Print Functions
            Route::post('/print-check', [App\Http\Controllers\ClientsController::class, 'printCheck'])->name('clients.print_check');
            Route::prefix('print-order')->name('clients.print_order.')->group(function () {
                Route::get('/units/{id}', [App\Http\Controllers\PrintOrderController::class, 'getClientUnits'])->name('units');
                Route::post('/details', [App\Http\Controllers\PrintOrderController::class, 'getPaymentDetails'])->name('details');
                Route::post('/store', [App\Http\Controllers\PrintOrderController::class, 'store'])->name('store');
                Route::get('/show/{id}', [App\Http\Controllers\PrintOrderController::class, 'show'])->name('show');
            });

            // AJAX Helpers
            Route::get('/check-availability', [App\Http\Controllers\ClientsController::class, 'checkAvailability'])->name('clients.check_availability');
            Route::get('/get-projects', [App\Http\Controllers\ClientsController::class, 'getProjects'])->name('clients.get_projects');
            Route::post('/toggle-review', [App\Http\Controllers\ClientsController::class, 'toggleReview'])->name('clients.toggle_review');
        });

        Route::get('/setup-tables', [App\Http\Controllers\ClientsController::class, 'setupTables'])->name('setup.tables');

        // HR Module
        Route::prefix('hr')->group(function () {
            Route::get('/employees', [App\Http\Controllers\HrController::class, 'index'])->name('hr.index');
            Route::get('/employees/create', [App\Http\Controllers\HrController::class, 'create'])->name('hr.create');
            Route::post('/employees/store', [App\Http\Controllers\HrController::class, 'store'])->name('hr.store');
            Route::get('/employees/{id}/edit', [App\Http\Controllers\HrController::class, 'edit'])->name('hr.edit');
            Route::put('/employees/{id}', [App\Http\Controllers\HrController::class, 'update'])->name('hr.update');
            Route::delete('/employees/{id}', [App\Http\Controllers\HrController::class, 'destroy'])->name('hr.destroy');

            // Advanced HR
            Route::get('/salaries', [App\Http\Controllers\HrController::class, 'salaries'])->name('hr.salaries');
            Route::post('/salaries/update', [App\Http\Controllers\HrController::class, 'updateSalaries'])->name('hr.salaries.update');
            Route::get('/salaries/print/{id}', [App\Http\Controllers\HrController::class, 'printSalary'])->name('hr.salaries.print');
            Route::get('/salaries/print-all', [App\Http\Controllers\HrController::class, 'printAllSalaries'])->name('hr.salaries.print_all');
            Route::get('/attendance', [App\Http\Controllers\HrController::class, 'attendance'])->name('hr.attendance');
            Route::get('/bonuses', [App\Http\Controllers\HrController::class, 'bonuses'])->name('hr.bonuses');
            Route::post('/bonuses/update', [App\Http\Controllers\HrController::class, 'updateBonuses'])->name('hr.bonuses.update');
            Route::get('/bonuses/print/{id}', [App\Http\Controllers\HrController::class, 'printBonus'])->name('hr.bonuses.print');
            Route::get('/bonuses/print-all', [App\Http\Controllers\HrController::class, 'printAllBonuses'])->name('hr.bonuses.print_all');
            Route::get('/vacations', [App\Http\Controllers\HrController::class, 'vacations'])->name('hr.vacations');
            Route::get('/audit', [App\Http\Controllers\HrController::class, 'audit'])->name('hr.audit');
        });
    });

    // Construction Module
    Route::prefix('construction')->name('constr.')->group(function () {
        Route::get('/', [ConstrController::class, 'index'])->name('index');
        Route::get('/create', [ConstrController::class, 'create'])->name('create');
        Route::post('/store', [ConstrController::class, 'store'])->name('store');
        Route::get('/{id}', [ConstrController::class, 'show'])->name('show');
        Route::post('/{id}/payments', [ConstrController::class, 'addPayment'])->name('payments.store');
    });

    // Consultants Module
    Route::prefix('consultants')->name('consult.')->group(function () {
        Route::get('/', [ConsultController::class, 'index'])->name('index');
        Route::get('/create', [ConsultController::class, 'create'])->name('create');
        Route::post('/store', [ConsultController::class, 'store'])->name('store');
        Route::get('/{id}', [ConsultController::class, 'show'])->name('show');
        Route::post('/{id}/payments', [ConsultController::class, 'addPayment'])->name('payments.store');
    });

    // Inventory Management
    Route::prefix('inventory')->name('inventory.')->group(function () {
        Route::get('/projects', [InventoryController::class, 'projects'])->name('projects');
        Route::get('/projects/{project}/flats', [InventoryController::class, 'flats'])->name('flats');
        Route::get('/projects/{project}/flats/{flat}/installments', [InventoryController::class, 'installments'])->name('installments');
        Route::post('/projects/{project}/flats/{flat}/installments/import', [InventoryController::class, 'importInstallments'])->name('installments.import');
        Route::get('/projects/{project}/flats/{flat}/installments/template', [InventoryController::class, 'downloadTemplate'])->name('installments.template');
        Route::get('/jobs', [InventoryController::class, 'jobs'])->name('jobs');
        Route::post('/jobs', [InventoryController::class, 'storeJob'])->name('jobs.store');
        Route::delete('/jobs/{id}', [InventoryController::class, 'deleteJob'])->name('jobs.delete');
    });
    // Admin Utilities & Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('/system/permissions', [DashboardController::class, 'permissions'])->name('admin.iba.permissions');
    Route::get('/system/lock', [DashboardController::class, 'lockScreen'])->name('admin.iba.lock');

    // Global Search
    Route::get('/global-search', [GlobalSearchController::class, 'search'])->name('admin.global.search');

    // Reports
    Route::prefix('reports')->group(function () {
        Route::get('/inquiry-by-building', [ReportsController::class, 'inquiryByBuilding'])->name('reports.inquiry_by_building');
        Route::post('/get-buildings', [ReportsController::class, 'getBuildings'])->name('reports.get_buildings');
        Route::post('/get-areas', [ReportsController::class, 'getAreas'])->name('reports.get_areas');
        Route::post('/get-flats', [ReportsController::class, 'getFlats'])->name('reports.get_flats');
        Route::post('/inquiry-by-building-data', [ReportsController::class, 'inquiryByBuildingData'])->name('reports.inquiry_by_building_data');
        Route::get('/parking-and-garden', [ReportsController::class, 'parkingAndGarden'])->name('reports.parking_and_garden');
        Route::post('/parking-and-garden-data', [ReportsController::class, 'parkingAndGardenData'])->name('reports.parking_and_garden_data');

        // Project Payment Details Report
        Route::get('/project-payments', [ReportsController::class, 'projectPaymentDetails'])->name('reports.project_payments');
        Route::post('/project-payments-data', [ReportsController::class, 'projectPaymentDetailsData'])->name('reports.project_payments_data');

        // Penalties Report
        Route::get('/penalties', [ReportsController::class, 'penaltiesReport'])->name('reports.penalties');
        Route::post('/penalties-data', [ReportsController::class, 'penaltiesReportData'])->name('reports.penalties_data');

        // Receipt Review Report (Employee Errors)
        Route::get('/receipt-review', [ReportsController::class, 'receiptReviewReport'])->name('reports.receipt_review');
        Route::post('/receipt-review/details', [ReportsController::class, 'receiptReviewDetails'])->name('reports.receipt_review_details');

        // Pending Receipts
        Route::get('/pending-receipts', [ReportsController::class, 'pendingReceipts'])->name('reports.pending_receipts');
        Route::post('/pending-receipts/confirm', [ReportsController::class, 'confirmReceipt'])->name('reports.pending_receipts_confirm');

        // Deleted Items Review
        Route::get('/deleted-items', [ReportsController::class, 'deletedItems'])->name('reports.deleted_items');
        Route::post('/deleted-items/restore-client', [ReportsController::class, 'restoreClient'])->name('reports.deleted_items_restore_client');
        Route::post('/deleted-items/restore-receipt', [ReportsController::class, 'restoreReceipt'])->name('reports.deleted_items_restore_receipt');
    });
});
