<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', 'Admin Panel') - Tiba Rose</title>
    <link rel="icon" type="image/png" href="{{ asset('assets/images/logo.png?v=' . time()) }}">
    <link rel="shortcut icon" type="image/png" href="{{ asset('assets/images/logo.png?v=' . time()) }}">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/css/font-icons/entypo/css/entypo.css') }}">

    <!-- Tailwind CSS (CDN for now, can move to Vite later) -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#10b981', // Emerald 500
                        secondary: '#1e293b', // Slate 800
                        danger: '#ef4444',
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    }
                }
            }
        }
    </script>

    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f3f4f6;
        }

        .glass-panel {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }

        .sidebar-link {
            transition: all 0.3s ease;
        }

        .sidebar-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
            padding-left: 1.5rem;
        }

        .submenu {
            transition: all 0.3s ease;
            overflow: hidden;
        }

        .submenu.hidden {
            max-height: 0;
            opacity: 0;
        }

        .submenu:not(.hidden) {
            max-height: 1000px;
            opacity: 1;
        }

        /* RTL Adjustments */
        [dir="rtl"] .sidebar-link:hover {
            padding-left: 1.5rem;
            padding-right: 1.5rem;
        }

        [dir="rtl"] .sidebar-link {
            text-align: right;
        }

        [dir="rtl"] .ml-auto {
            margin-right: auto;
            margin-left: 0;
        }

        [dir="rtl"] .mr-auto {
            margin-left: auto;
            margin-right: 0;
        }

        [dir="rtl"] .pl-10 {
            padding-right: 2.5rem;
            padding-left: 0.75rem;
        }

        [dir="rtl"] .left-0 {
            right: 0;
            left: auto;
        }

        [dir="rtl"] .pl-3 {
            padding-right: 0.75rem;
            padding-left: 0;
        }
    </style>
    @stack('styles')
</head>

<body class="antialiased text-slate-800">

    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <aside class="w-64 bg-secondary text-white flex-shrink-0 hidden md:flex flex-col">
            <div class="p-6 border-b border-gray-700 flex items-center gap-4">
                <img src="/admin_laravel/public/assets/images/logo.png" alt="Logo"
                    class="w-12 h-12 object-contain rounded-lg bg-white/10 p-1">
                <div>
                    <h1 class="text-xl font-bold tracking-wider text-primary">{{ __('TIBA ROSE') }}</h1>
                    <p class="text-[10px] text-gray-400 uppercase tracking-widest">{{ __('Admin Dashboard') }}</p>
                </div>
            </div>

            <nav class="flex-1 overflow-y-auto py-4">
                <ul>
                    <li class="px-4 py-2">
                        <span
                            class="text-xs uppercase font-semibold text-gray-500 tracking-wider">{{ __('Main') }}</span>
                    </li>
                    <li>
                        <a href="{{ route('admin.dashboard') }}"
                            class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('admin.dashboard') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                            {{ __('Dashboard') }}
                        </a>
                    </li>
                    <li class="px-4 py-2 mt-4">
                        <span
                            class="text-xs uppercase font-semibold text-gray-500 tracking-wider">{{ __('Modules') }}</span>
                    </li>
                    <li>
                        <a href="{{ route('clients.index') }}"
                            class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('clients.*') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                            {{ __('Clients') }}
                        </a>
                    </li>
                    <li>
                        <button onclick="toggleSubmenu('hr-submenu')"
                            class="sidebar-link flex items-center justify-between w-full px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('hr.*') ? 'bg-slate-700/50' : '' }}">
                            <span>{{ __('HR (Employees)') }}</span>
                            <svg id="hr-submenu-icon" class="w-4 h-4 transition-transform" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7" />
                            </svg>
                        </button>
                    </li>
                    <div id="hr-submenu" class="submenu hidden">
                        <li class="pl-4">
                            <a href="{{ route('hr.index') }}"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white {{ request()->routeIs('hr.index') ? 'text-primary' : '' }}">
                                - {{ __('Employees') }}
                            </a>
                        </li>
                        <li class="pl-4">
                            <a href="{{ route('hr.salaries') }}"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white {{ request()->routeIs('hr.salaries') ? 'text-primary' : '' }}">
                                - {{ __('Salaries') }}
                            </a>
                        </li>
                        <li class="pl-4">
                            <a href="{{ route('hr.attendance') }}"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white {{ request()->routeIs('hr.attendance') ? 'text-primary' : '' }}">
                                - {{ __('Attendance') }}
                            </a>
                        </li>
                        <li class="pl-4">
                            <a href="{{ route('hr.bonuses') }}"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white {{ request()->routeIs('hr.bonuses') ? 'text-primary' : '' }}">
                                - {{ __('Bonuses') }}
                            </a>
                        </li>
                        <li class="pl-4">
                            <a href="{{ route('hr.vacations') }}"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white {{ request()->routeIs('hr.vacations') ? 'text-primary' : '' }}">
                                - {{ __('Vacations') }}
                            </a>
                        </li>
                        <li class="pl-4">
                            <a href="{{ route('hr.audit') }}"
                                class="sidebar-link block px-6 py-2 text-sm text-gray-400 hover:text-white {{ request()->routeIs('hr.audit') ? 'text-primary' : '' }}">
                                - {{ __('Audit Logs') }}
                            </a>
                        </li>
                    </div>
                    {{-- <li>
                        <a href="{{ route('constr.index') }}"
                            class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('constr.*') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                            Construction
                        </a>
                    </li> --}}
                    {{-- <li>
                        <a href="{{ route('consult.index') }}"
                            class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('consult.*') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                            Consultants
                        </a>
                    </li> --}}
                    <li>
                        <a href="{{ route('inventory.projects') }}"
                            class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('inventory.projects') || request()->routeIs('inventory.flats') || request()->routeIs('inventory.installments') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                            {{ __('Inventory (Projects)') }}
                        </a>
                    </li>
                    {{-- <li>
                        <a href="{{ route('inventory.jobs') }}"
                            class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('inventory.jobs') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                            Jobs Management
                        </a>
                    </li> --}}
                    <li>
                        <button onclick="toggleSubmenu('reports-submenu')"
                            class="sidebar-link flex items-center justify-between w-full px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('reports.*') ? 'bg-slate-700/50' : '' }}">
                            <span>{{ __("Reports") }}</span>
                            <svg id="reports-submenu-icon" class="w-4 h-4 transition-transform" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7" />
                            </svg>
                        </button>
                    </li>
                    <div id="reports-submenu" class="submenu hidden">
                        <li>
                            <a href="{{ route('reports.inquiry_by_building') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('reports.inquiry_by_building') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Inquiry by Building') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('reports.parking_and_garden') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('reports.parking_and_garden') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Parking & Garden') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('reports.project_payments') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('reports.project_payments') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Project Payment Details') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('reports.penalties') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('reports.penalties') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Penalties & Interest') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('reports.receipt_review') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('reports.receipt_review') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Receipt Review Report') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('reports.pending_receipts') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('reports.pending_receipts') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Pending Receipts') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('reports.deleted_items') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('reports.deleted_items') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Deleted Items Review') }}
                            </a>
                        </li>
                    </div>
                    <li>
                        <button onclick="toggleSubmenu('print-submenu')"
                            class="sidebar-link flex items-center justify-between w-full px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('print.*') ? 'bg-slate-700/50' : '' }}">
                            <span>{{ __('Print') }}</span>
                            <svg id="print-submenu-icon" class="w-4 h-4 transition-transform" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7" />
                            </svg>
                        </button>
                    </li>
                    <div id="print-submenu" class="submenu hidden">
                        <li>
                            <a href="{{ route('print.empty_payment') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('print.empty_payment') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Empty Payment Order') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('print.manual_payment') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('print.manual_payment') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Manual Payment Order') }}
                            </a>
                        </li>
                        {{-- <li>
                            <a href="{{ route('print.checks') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('print.checks') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                Print Checks
                            </a>
                        </li> --}}
                        <li>
                            <a href="{{ route('print.membership') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('print.membership') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Membership Form') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('letters.print_warnings') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('letters.*') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Print Warning Letters') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('import.transactions') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('import.*') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Import Transactions') }}
                            </a>
                        </li>
                    </div>

                    <!-- Website Section -->
                    <li>
                        <button onclick="toggleSubmenu('website-submenu')"
                            class="sidebar-link flex items-center justify-between w-full px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('website.*') ? 'bg-slate-700/50' : '' }}">
                            <span>{{ __('Website') }}</span>
                            <svg id="website-submenu-icon" class="w-4 h-4 transition-transform" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7" />
                            </svg>
                        </button>
                    </li>
                    <div id="website-submenu" class="submenu hidden">
                        <li>
                            <a href="{{ route('website.requests') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('website.requests') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Client Requests') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('website.comments') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('website.comments') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Client Comments') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('website.uploads') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('website.uploads') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Uploaded Files') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('website.area_changes') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('website.area_changes') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Area Change Requests') }}
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('website.updates') }}"
                                class="sidebar-link block px-6 py-3 text-gray-300 hover:text-white {{ request()->routeIs('website.updates') ? 'bg-slate-700/50 border-r-4 border-primary' : '' }}">
                                {{ __('Client Updates') }}
                            </a>
                        </li>
                    </div>
                </ul>
            </nav>

            @auth('admin')
                <a href="{{ route('admin.profile') }}"
                    class="block p-4 border-t border-gray-700 hover:bg-slate-700/50 transition cursor-pointer">
                    <div class="flex items-center gap-3">
                        @if(Auth::guard('admin')->user()->image)
                            <img src="{{ asset('storage/' . Auth::guard('admin')->user()->image) }}" alt="Profile"
                                class="h-10 w-10 rounded-full object-cover border-2 border-primary">
                        @else
                            <div
                                class="h-10 w-10 rounded-full bg-primary flex items-center justify-center text-white font-bold">
                                {{ substr(Auth::guard('admin')->user()->name, 0, 1) }}
                            </div>
                        @endif
                        <div>
                            <p class="text-sm font-medium text-gray-200">{{ Auth::guard('admin')->user()->name }}</p>
                            <p class="text-xs text-gray-400">{{ Auth::guard('admin')->user()->email }}</p>
                        </div>
                    </div>
                </a>
            @endauth
        </aside>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col h-screen overflow-hidden">
            <!-- Header -->
            <header class="h-16 bg-white shadow-sm flex items-center justify-between px-6 z-10">
                <button class="md:hidden text-gray-600 focus:outline-none">
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                </button>

                <!-- Global Search -->
                <div class="relative flex-1 max-w-md mx-6 hidden sm:block">
                    <div
                        class="absolute inset-y-0 {{ app()->getLocale() == 'ar' ? 'right-0 pr-3' : 'left-0 pl-3' }} flex items-center pointer-events-none">
                        <svg class="h-4 w-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                        </svg>
                    </div>
                    <input type="text" id="global-search" placeholder="{{ __('Search anything...') }}"
                        class="block w-full {{ app()->getLocale() == 'ar' ? 'pr-10 pl-3' : 'pl-10 pr-3' }} py-2 border border-gray-100 rounded-xl leading-5 bg-gray-50/50 placeholder-gray-400 focus:outline-none focus:bg-white focus:ring-2 focus:ring-primary/20 focus:border-primary sm:text-sm transition duration-200">
                    <div id="search-results"
                        class="hidden absolute mt-2 w-full bg-white rounded-xl shadow-2xl border border-gray-100 z-50 overflow-hidden">
                        <!-- Results injected here -->
                    </div>
                </div>

                <div class="text-sm font-medium text-gray-500 {{ app()->getLocale() == 'ar' ? 'ml-auto' : 'mr-auto' }}">
                    @yield('header')
                </div>

                <div class="flex items-center gap-4">
                    <!-- Language Switcher -->
                    @if(app()->getLocale() == 'en')
                        <a href="{{ route('lang.switch', 'ar') }}"
                            class="flex items-center gap-2 px-3 py-1.5 rounded-lg border border-gray-200 hover:bg-gray-50 transition-colors">
                            <span class="text-sm font-medium">العربية</span>
                            <span
                                class="w-6 h-4 bg-gray-200 rounded-sm overflow-hidden flex items-center justify-center text-[10px]">🇸🇦</span>
                        </a>
                    @else
                        <a href="{{ route('lang.switch', 'en') }}"
                            class="flex items-center gap-2 px-3 py-1.5 rounded-lg border border-gray-200 hover:bg-gray-50 transition-colors">
                            <span class="text-sm font-medium">English</span>
                            <span
                                class="w-6 h-4 bg-gray-200 rounded-sm overflow-hidden flex items-center justify-center text-[10px]">🇺🇸</span>
                        </a>
                    @endif

                    <button class="p-2 rounded-full hover:bg-gray-100 text-gray-600">
                        <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                        </svg>
                    </button>
                    <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                        class="text-sm font-medium text-red-600 hover:text-red-700">{{ __('Logout') }}</a>
                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="hidden">
                        @csrf
                    </form>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
                @if(session('success'))
                    <div class="mb-4 bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded shadow-sm"
                        role="alert">
                        <p class="font-bold">{{ __('Success') }}</p>
                        <p>{{ session('success') }}</p>
                    </div>
                @endif

                @if(session('error'))
                    <div class="mb-4 bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded shadow-sm" role="alert">
                        <p class="font-bold">{{ __('Error') }}</p>
                        <p>{{ session('error') }}</p>
                    </div>
                @endif

                @yield('content')
            </main>
        </div>
    </div>

    @stack('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const searchInput = document.getElementById('global-search');
            const resultsDiv = document.getElementById('search-results');
            let debounceTimer;

            searchInput.addEventListener('input', function () {
                clearTimeout(debounceTimer);
                const query = this.value;

                if (query.length < 2) {
                    resultsDiv.classList.add('hidden');
                    return;
                }

                debounceTimer = setTimeout(() => {
                    fetch(`{{ route('admin.global.search') }}?q=${encodeURIComponent(query)}`)
                        .then(response => response.json())
                        .then(data => {
                            if (data.length > 0) {
                                resultsDiv.innerHTML = data.map(item => `
                                    <a href="${item.url}" class="flex items-center px-4 py-3 hover:bg-gray-50 border-b border-gray-50 last:border-b-0 transition duration-150">
                                        <div class="p-2 bg-blue-50 text-blue-600 rounded-lg mr-3">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-sm font-semibold text-gray-800">${item.title}</p>
                                            <p class="text-xs text-gray-500 font-medium uppercase tracking-wider">${item.category}</p>
                                        </div>
                                    </a>
                                `).join('');
                                resultsDiv.classList.remove('hidden');
                            } else {
                                resultsDiv.innerHTML = '<div class="px-4 py-3 text-sm text-gray-500 text-center">No results found</div>';
                                resultsDiv.classList.remove('hidden');
                            }
                        });
                }, 300);
            });

            document.addEventListener('click', function (e) {
                if (!searchInput.contains(e.target) && !resultsDiv.contains(e.target)) {
                    resultsDiv.classList.add('hidden');
                }
            });
        });

        // Sidebar collapsible toggle function
        function toggleSubmenu(submenuId) {
            const submenu = document.getElementById(submenuId);
            const icon = document.getElementById(submenuId + '-icon');

            if (submenu.classList.contains('hidden')) {
                submenu.classList.remove('hidden');
                icon.style.transform = 'rotate(180deg)';
            } else {
                submenu.classList.add('hidden');
                icon.style.transform = 'rotate(0deg)';
            }
        }
    </script>
</body>

</html>