@extends('layouts.admin')

@section('header')
    {{ __('Uploaded Files') }}
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h1 class="text-2xl font-bold mb-6">أيصالات مرفوعه</h1>

        <table class="w-full border-collapse">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">رقم العضويه</th>
                    <th class="border p-2">رقم الملف</th>
                    <th class="border p-2">الاسم العربى</th>
                    <th class="border p-2">الرقم القومى</th>
                    <th class="border p-2">الملف</th>
                    <th class="border p-2">تاريخ الرفع</th>
                    <th class="border p-2">أجراءات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($uploads as $upload)
                    <tr>
                        <td class="border p-2">{{ $upload->old_member_no }}</td>
                        <td class="border p-2">{{ $upload->member_no }}</td>
                        <td class="border p-2">{{ $upload->arabic_name }}</td>
                        <td class="border p-2">{{ $upload->nat_id }}</td>
                        <td class="border p-2"><a href="{{ $upload->path }}" target="_blank"
                                class="text-blue-600">{{ $upload->filename }}</a></td>
                        <td class="border p-2">{{ $upload->date_added }}</td>
                        <td class="border p-2 whitespace-nowrap">
                            <button class="bg-blue-600 text-white px-2 py-1 rounded text-sm hover:bg-blue-700">نقل لملفات
                                العضو</button>
                            <button class="bg-red-600 text-white px-2 py-1 rounded text-sm hover:bg-red-700 ml-2">تم
                                التسجيل</button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection