@extends('layouts.admin')

@section('header')
    {{ __('Client Updates') }}
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h1 class="text-2xl font-bold mb-6">بيانات محدثه</h1>

        <div class="overflow-x-auto">
            <table class="w-full border-collapse text-sm">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="border p-2">رقم العضويه</th>
                        <th class="border p-2">الاسم العربى</th>
                        <th class="border p-2">الاسم الانجليزى</th>
                        <th class="border p-2">الرقم القومى</th>
                        <th class="border p-2">الجنسيه</th>
                        <th class="border p-2">تاريخ الميلاد</th>
                        <th class="border p-2">المدينه</th>
                        <th class="border p-2">الموبايل</th>
                        <th class="border p-2">البريد</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($updates as $update)
                        <tr>
                            <td class="border p-2">{{ $update->member_no }}</td>
                            <td class="border p-2">{{ $update->arabic_name }}</td>
                            <td class="border p-2">{{ $update->english_name }}</td>
                            <td class="border p-2">{{ $update->nat_id }}</td>
                            <td class="border p-2">{{ $update->nationality }}</td>
                            <td class="border p-2">{{ $update->birth_date }}</td>
                            <td class="border p-2">{{ $update->city }}</td>
                            <td class="border p-2">{{ $update->mobile }}</td>
                            <td class="border p-2">{{ $update->email }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection