@extends('layouts.admin')

@section('header')
    {{ __('Client Requests') }}
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h1 class="text-2xl font-bold mb-6">طلبات العملاء</h1>

        <table class="w-full border-collapse" id="requests-table">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">رقم العضويه</th>
                    <th class="border p-2">الاسم العربى</th>
                    <th class="border p-2">الرقم القومى</th>
                    <th class="border p-2">نوع الطلب</th>
                    <th class="border p-2">الحاله</th>
                    <th class="border p-2">أجراءات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($requests as $request)
                    @php
                        $statuses = ['0' => 'تمت الموافقه', '1' => 'فى انتظار الموافقه', '3' => 'تم الرفض'];
                        $colors = ['0' => 'bg-green-200', '1' => 'bg-yellow-200', '3' => 'bg-red-200'];
                    @endphp
                    <tr>
                        <td class="border p-2">{{ $request->to_cl ?? $request->member_no }}</td>
                        <td class="border p-2">{{ $request->arabic_name }}</td>
                        <td class="border p-2">{{ $request->nat_id }}</td>
                        <td class="border p-2">{{ $request->type }}</td>
                        <td class="border p-2 {{ $colors[$request->tflag] ?? '' }}">{{ $statuses[$request->tflag] ?? '' }}</td>
                        <td class="border p-2">
                            <button
                                onclick="viewRequest('{{ $request->to_cl }}', '{{ $request->tfile_no }}', '{{ $request->prj_id }}', '{{ $request->tid }}', '{{ $request->type }}', '{{ $request->tflag }}')"
                                class="bg-blue-600 text-white px-3 py-1 rounded text-sm hover:bg-blue-700">
                                عرض
                            </button>
                            <button onclick="rejectRequest('{{ $request->tid }}')"
                                class="bg-red-600 text-white px-3 py-1 rounded text-sm hover:bg-red-700 ml-1">
                                رفض
                            </button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <script>
        function viewRequest(to_cl, file_no, prj_id, id, type, status) {
            // Create form and submit to view request details
            const form = document.createElement('form');
            form.method = 'POST';
            form.target = '_blank';

            if (type === 'سحب مدخرات') {
                form.action = '{{ route("clients.withdrawal") }}';
            } else {
                form.action = '{{ route("clients.transfer_request") }}';
            }

            // Add CSRF token
            const csrfInput = document.createElement('input');
            csrfInput.type = 'hidden';
            csrfInput.name = '_token';
            csrfInput.value = '{{ csrf_token() }}';
            form.appendChild(csrfInput);

            // Add parameters
            ['file_no', 'prj_id', 'to_file_no', 'flag', 'id', 'type', 'status'].forEach((name, index) => {
                const input = document.createElement('input');
                input.type = 'hidden';
                input.name = name;
                input.value = [file_no, prj_id, to_cl, '1', id, type, status][index];
                form.appendChild(input);
            });

            document.body.appendChild(form);
            form.submit();
            document.body.removeChild(form);
        }

        function rejectRequest(id) {
            if (!confirm('هل أنت متأكد من رفض هذا الطلب؟')) return;

            fetch('{{ route("website.reject_request") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ id: id })
            })
                .then(response => response.json())
                .then(data => {
                    alert('تم الرفض');
                    location.reload();
                });
        }
    </script>
@endsection