@extends('layouts.admin')

@section('header')
    {{ __('Client Comments') }}
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h1 class="text-2xl font-bold mb-6 text-center">تعليقات العملاء</h1>

        <table class="w-full border-collapse">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">رقم الملف</th>
                    <th class="border p-2">رقم العضويه</th>
                    <th class="border p-2">الاسم</th>
                    <th class="border p-2">أجراءات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($clients as $client)
                    <tr>
                        <td class="border p-2">{{ $client->file_no }}</td>
                        <td class="border p-2">{{ $client->old_member_no }}</td>
                        <td class="border p-2">{{ $client->arabic_name }}</td>
                        <td class="border p-2">
                            <button onclick="viewComments('{{ $client->file_no }}')"
                                class="bg-emerald-600 text-white px-3 py-1 rounded text-sm hover:bg-emerald-700">التعليقات</button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Comments Modal -->
    <div id="commentsModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
        <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-xl font-bold">التعليقات</h3>
                <button onclick="closeModal()" class="text-gray-600 hover:text-gray-900 text-2xl">&times;</button>
            </div>
            <div id="commentsContent" class="mt-3">
                <!-- Comments will be loaded here -->
            </div>
        </div>
    </div>

    <script>
        function viewComments(fileNo) {
            fetch('{{ route("website.get_comments") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ file_no: fileNo })
            })
                .then(response => response.json())
                .then(data => {
                    const content = document.getElementById('commentsContent');
                    if (data.comments && data.comments.length > 0) {
                        let html = '<div class="space-y-3">';
                        data.comments.forEach(comment => {
                            html += `
                        <div class="border-b pb-3">
                            <p class="text-gray-700">${comment.comment || comment.com || 'لا يوجد تعليق'}</p>
                            <small class="text-gray-500">${comment.date || comment.comment_date || ''}</small>
                        </div>
                    `;
                        });
                        html += '</div>';
                        content.innerHTML = html;
                    } else {
                        content.innerHTML = '<p class="text-center text-gray-500">لا توجد تعليقات</p>';
                    }
                    document.getElementById('commentsModal').classList.remove('hidden');
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('حدث خطأ أثناء تحميل التعليقات');
                });
        }

        function closeModal() {
            document.getElementById('commentsModal').classList.add('hidden');
        }

        // Close modal when clicking outside
        document.getElementById('commentsModal')?.addEventListener('click', function (e) {
            if (e.target === this) closeModal();
        });
    </script>
@endsection