@extends('layouts.admin')

@section('header')
    {{ __('Area Change Requests') }}
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h1 class="text-2xl font-bold mb-6">طلبات تغيير المساحه</h1>

        <table class="w-full border-collapse">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">رقم العضويه</th>
                    <th class="border p-2">الاسم العربى</th>
                    <th class="border p-2">المشروع</th>
                    <th class="border p-2">المساحه</th>
                    <th class="border p-2">رقم العماره</th>
                    <th class="border p-2">رقم الوحده</th>
                    <th class="border p-2">الملفات</th>
                    <th class="border p-2">اجراءات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($requests as $request)
                    <tr>
                        <td class="border p-2">{{ $request->mem_no }}</td>
                        <td class="border p-2">{{ $request->name }}</td>
                        <td class="border p-2">{{ $request->project }}</td>
                        <td class="border p-2">{{ $request->area }}</td>
                        <td class="border p-2">{{ $request->bldg }}</td>
                        <td class="border p-2">{{ $request->flat }}</td>
                        <td class="border p-2"><a href="{{ $request->file }}" target="_blank" class="text-blue-600">عرض</a></td>
                        <td class="border p-2">
                            <button class="bg-red-600 text-white px-2 py-1 rounded text-sm">حذف</button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection