@extends('layouts.admin')

@section('header', 'System Lock')

@section('content')
    <div class="max-w-md mx-auto mt-20">
        <div class="bg-white rounded-[2rem] shadow-2xl border border-gray-100 p-10 text-center relative overflow-hidden">
            <div class="absolute top-0 left-0 w-full h-2 bg-red-500"></div>

            <div class="w-24 h-24 bg-red-50 text-red-500 rounded-3xl mx-auto flex items-center justify-center mb-8">
                <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                </svg>
            </div>

            <h2 class="text-2xl font-black text-gray-900 mb-2">Console Locked</h2>
            <p class="text-gray-500 mb-8">Your session is currently protected. Enter your password to resume work.</p>

            <form class="space-y-4">
                <input type="password" placeholder="Enter Administrator Password"
                    class="block w-full px-5 py-4 rounded-2xl border border-gray-100 bg-gray-50 focus:outline-none focus:ring-4 focus:ring-red-500/10 focus:border-red-500 transition-all text-center font-bold">

                <button type="button"
                    class="w-full bg-slate-900 text-white px-5 py-4 rounded-2xl font-bold hover:bg-black transition-all shadow-xl shadow-slate-900/20">
                    Unlock System
                </button>
            </form>

            <div class="mt-8 pt-8 border-t border-gray-50">
                <a href="#" class="text-sm font-bold text-gray-400 hover:text-primary transition-colors">Switch
                    Administrator Account</a>
            </div>
        </div>
    </div>
@endsection