@extends('layouts.admin')

@section('header')
    {{ __('Reports') }} / Pending Receipts
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4 border-b border-gray-100 pb-6">
            <h2 class="text-2xl font-bold bg-gradient-to-r from-yellow-600 to-amber-600 bg-clip-text text-transparent">
                Pending Receipts - Awaiting Confirmation
            </h2>
        </div>

        <!-- Results Table -->
        <div class="overflow-x-auto rounded-xl border border-gray-100">
            <table id="report_table" class="min-w-full divide-y divide-gray-200">
                <thead class="bg-yellow-50/50">
                    <tr class="text-[10px] font-bold text-gray-500 uppercase tracking-widest text-center">
                        <th class="px-3 py-4">#</th>
                        <th class="px-3 py-4">Member No</th>
                        <th class="px-3 py-4">File No</th>
                        <th class="px-3 py-4">Client Name</th>
                        <th class="px-3 py-4">Date</th>
                        <th class="px-3 py-4">Value</th>
                        <th class="px-3 py-4">Receipt No</th>
                        <th class="px-3 py-4">Bank Account</th>
                        <th class="px-3 py-4">Type</th>
                        <th class="px-3 py-4">Employee</th>
                        <th class="px-3 py-4">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-100 text-sm">
                    @php $x = 1; @endphp
                    @foreach($receipts as $receipt)
                        <tr id="row-{{ $receipt->rid }}">
                            <td class="px-3 py-3 text-center">{{ $x++ }}</td>
                            <td class="px-3 py-3 text-center font-semibold text-yellow-700">{{ $receipt->old_member_no ?? '' }}
                            </td>
                            <td class="px-3 py-3 text-center">{{ $receipt->file_no ?? '' }}</td>
                            <td class="px-3 py-3 text-right font-bold text-gray-900">{{ $receipt->arabic_name ?? '' }}</td>
                            <td class="px-3 py-3 text-center">{{ $receipt->date ?? '' }}</td>
                            <td class="px-3 py-3 text-center font-bold text-yellow-600">
                                {{ number_format($receipt->value ?? 0) }}
                            </td>
                            <td class="px-3 py-3 text-center">{{ $receipt->number ?? '' }}</td>
                            <td class="px-3 py-3 text-center text-xs">{{ $receipt->bank_name ?? '' }}</td>
                            <td class="px-3 py-3 text-center">{{ $receipt->type_name ?? '' }}</td>
                            <td class="px-3 py-3 text-center text-xs">{{ $receipt->adname ?? '' }}</td>
                            <td class="px-3 py-3">
                                <div class="flex justify-center items-center gap-2">
                                    <button
                                        class="confirm-btn bg-emerald-600 text-white px-3 py-1 rounded-lg hover:bg-emerald-700 transition text-xs font-semibold"
                                        data-id="{{ $receipt->rid }}">
                                        <i class="entypo-check"></i> Confirm
                                    </button>
                                    <button
                                        class="cancel-btn bg-red-600 text-white px-3 py-1 rounded-lg hover:bg-red-700 transition text-xs font-semibold"
                                        data-id="{{ $receipt->rid }}">
                                        <i class="entypo-cancel"></i> Cancel
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    @push('styles')
        <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
        <style>
            .dt-buttons {
                margin-bottom: 20px;
            }

            .dt-button {
                @apply px-4 py-2 bg-white border border-gray-200 rounded-lg text-sm font-medium hover:bg-gray-50 transition-all !important;
            }

            #report_table thead th {
                @apply border-r border-gray-100 last:border-r-0;
            }

            #report_table tbody td {
                @apply border-r border-gray-50 last:border-r-0;
            }
        </style>
    @endpush

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

        <script>
            $(document).ready(function () {
                $('#report_table').DataTable({
                    dom: 'Bfrtip',
                    buttons: [
                        { extend: 'copy', className: 'bg-gray-100' },
                        { extend: 'excel', title: 'Pending Receipts', className: 'bg-yellow-50 text-yellow-700 border-yellow-200' },
                        { extend: 'pdf', title: 'Pending Receipts', orientation: 'landscape', className: 'bg-amber-50 text-amber-700 border-amber-200' },
                        { extend: 'print', className: 'bg-blue-50 text-blue-700 border-blue-200' }
                    ],
                    order: [[0, 'asc']]
                });

                // Confirm button click
                $('.confirm-btn').click(function () {
                    const id = $(this).data('id');
                    const row = $('#row-' + id);

                    if (confirm('Confirm this receipt?')) {
                        $.post('{{ route("reports.pending_receipts_confirm") }}', {
                            id: id,
                            status: 'Y',
                            _token: '{{ csrf_token() }}'
                        }, function (response) {
                            if (response.success) {
                                row.fadeOut(300, function () {
                                    $(this).remove();
                                });
                            }
                        });
                    }
                });

                // Cancel button click
                $('.cancel-btn').click(function () {
                    const id = $(this).data('id');
                    const row = $('#row-' + id);

                    if (confirm('Cancel and delete this receipt?')) {
                        $.post('{{ route("reports.pending_receipts_confirm") }}', {
                            id: id,
                            status: 'X',
                            _token: '{{ csrf_token() }}'
                        }, function (response) {
                            if (response.success) {
                                row.fadeOut(300, function () {
                                    $(this).remove();
                                });
                            }
                        });
                    }
                });
            });
        </script>
    @endpush
@endsection