@extends('layouts.admin')

@section('header')
    {{ __('Reports') }} / {{ __('Parking & Garden') }}
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4 border-b border-gray-100 pb-6">
            <h2 class="text-2xl font-bold bg-gradient-to-r from-emerald-600 to-teal-600 bg-clip-text text-transparent">
                {{ __('Parking & Garden Statement') }}
            </h2>
        </div>

        <!-- Filters -->
        <div
            class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8 p-6 bg-emerald-50/30 rounded-2xl border border-emerald-100/50">
            <div class="md:col-span-3">
                <label class="block text-sm font-semibold text-gray-700 mb-2">{{ __('Select Project') }}</label>
                <select id="prj_select"
                    class="w-full rounded-xl border-gray-200 focus:ring-emerald-500 focus:border-emerald-500 transition-all font-medium">
                    <option value="0">{{ __('Choose Project') }}</option>
                    @foreach($projects as $project)
                        <option value="{{ $project->prj_id }}">{{ $project->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="flex items-end">
                <button id="display_btn"
                    class="w-full bg-emerald-600 text-white px-6 py-2.5 rounded-xl hover:bg-emerald-700 transition duration-150 font-bold shadow-lg shadow-emerald-100 flex items-center justify-center gap-2">
                    <i class="entypo-chart-bar"></i> {{ __('Display Report') }}
                </button>
            </div>
        </div>

        <!-- Results Table -->
        <div class="overflow-x-auto rounded-xl border border-gray-100 hidden" id="report_container">
            <table id="membersTable" class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr class="text-[10px] font-bold text-gray-500 uppercase tracking-widest text-center">
                        <th>{{ __('Memb. No') }}</th>
                        <th class="text-start">{{ __('Client Name') }}</th>
                        <th>{{ __('Bldg') }}</th>
                        <th>{{ __('Park No') }}</th>
                        <th class="bg-blue-50/50">{{ __('Park Req.') }}</th>
                        <th class="bg-blue-50/50">{{ __('Park Tot.') }}</th>
                        <th class="bg-blue-50/50">{{ __('Park Paid') }}</th>
                        <th class="bg-blue-50/50 text-red-600">{{ __('Park Rem.') }}</th>
                        <th class="bg-emerald-50/50">{{ __('Gard Req.') }}</th>
                        <th class="bg-emerald-50/50">{{ __('Gard Tot.') }}</th>
                        <th class="bg-emerald-50/50">{{ __('Gard Paid') }}</th>
                        <th class="bg-emerald-50/50 text-red-600">{{ __('Gard Rem.') }}</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-100 text-sm">
                    <!-- Data injected via DataTables -->
                </tbody>
            </table>
        </div>

        <div id="loader" class="hidden py-20 text-center">
            <div class="inline-block animate-spin rounded-full h-12 w-12 border-4 border-emerald-500 border-t-transparent">
            </div>
            <p class="mt-4 text-gray-500 font-medium">{{ __('Analyzing parking and garden installments...') }}</p>
        </div>
    </div>

    @push('styles')
        <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
        <style>
            .dt-buttons {
                margin-bottom: 20px;
            }

            .dt-button {
                @apply px-4 py-2 bg-white border border-gray-200 rounded-lg text-sm font-medium hover:bg-gray-50 transition-all !important;
            }

            #membersTable thead th {
                @apply px-2 py-4 border-r border-gray-100 last:border-r-0;
            }

            #membersTable tbody td {
                @apply px-2 py-3 border-r border-gray-50 last:border-r-0 text-center;
            }

            .dataTables_wrapper .dataTables_filter input {
                @apply rounded-lg border-gray-200 text-sm focus:ring-emerald-500 focus:border-emerald-500;
            }
        </style>
    @endpush

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

        <script>
            $(document).ready(function () {
                let table = null;

                $('#display_btn').click(function () {
                    const prj_id = $('#prj_select').val();
                    if (prj_id == 0) {
                        alert('{{ __("Please select a project first") }}');
                        return;
                    }

                    $('#report_container').addClass('hidden');
                    $('#loader').removeClass('hidden');

                    if (table) {
                        table.destroy();
                        $('#membersTable tbody').empty();
                    }

                    $.post('{{ route("reports.parking_and_garden_data") }}', {
                        prj_id: prj_id,
                        _token: '{{ csrf_token() }}'
                    }, function (response) {
                        $('#loader').addClass('hidden');
                        $('#report_container').removeClass('hidden');

                        table = $('#membersTable').DataTable({
                            data: response.data,
                            columns: [
                                { data: 'old_member_no', className: 'font-semibold text-emerald-700' },
                                { data: 'arabic_name', className: 'text-start font-bold text-gray-900 no-wrap' },
                                { data: 'bldg_id' },
                                { data: 'park_no' },
                                { data: 'park_required' },
                                { data: 'park_total' },
                                { data: 'park_paied' },
                                { data: 'park_remain', className: 'text-red-600 font-bold' },
                                { data: 'garden_required' },
                                { data: 'garden_total' },
                                { data: 'garden_paied' },
                                { data: 'garden_remain', className: 'text-red-600 font-bold' }
                            ],
                            dom: 'Bfrtip',
                            buttons: [
                                { extend: 'copy', className: 'bg-gray-100' },
                                buttons: [
                                    { extend: 'copy', className: 'bg-gray-100' },
                                    { extend: 'excel', title: '{{ __('Parking & Garden Report') }}', className: 'bg-emerald-50 text-emerald-700 border-emerald-200' },
                                    { extend: 'pdf', title: '{{ __('Parking & Garden Report') }}', orientation: 'landscape', className: 'bg-rose-50 text-rose-700 border-rose-200' },
                                    { extend: 'print', className: 'bg-blue-50 text-blue-700 border-blue-200' }
                                ],
                                language: {
                                    search: "_INPUT_",
                                    searchPlaceholder: "{{ __('Search in results...') }}",
                                    @if(app()->getLocale() == 'ar')
                                        url: "//cdn.datatables.net/plug-ins/1.13.6/i18n/ar.json"
                                    @endif
                                    },
                            pageLength: 25,
                            ordering: true,
                            order: [[0, 'asc']]
                                });
                });
            });
                    });
        </script>
    @endpush
@endsection