@extends('layouts.admin')

@section('header')
    {{ __('Reports') }} / Deleted Items Review
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4 border-b border-gray-100 pb-6">
            <h2 class="text-2xl font-bold bg-gradient-to-r from-red-600 to-rose-600 bg-clip-text text-transparent">
                Deleted Items Review - Restore Functionality
            </h2>
        </div>

        <!-- Tab Buttons -->
        <div class="flex gap-4 mb-6">
            <button id="tab-clients" class="tab-btn active px-6 py-3 rounded-xl font-bold transition bg-red-600 text-white">
                <i class="entypo-users"></i> Deleted Clients
            </button>
            <button id="tab-receipts" class="tab-btn px-6 py-3 rounded-xl font-bold transition bg-gray-200 text-gray-700 hover:bg-gray-300">
                <i class="entypo-docs"></i> Deleted Receipts
            </button>
        </div>

        <!-- Tab 1: Deleted Clients -->
        <div id="content-clients" class="tab-content">
            <div class="overflow-x-auto rounded-xl border border-gray-100">
                <table id="table-clients" class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-red-50/50">
                        <tr class="text-xs font-bold text-gray-500 uppercase tracking-widest text-center">
                            <th class="px-3 py-4">#</th>
                            <th class="px-3 py-4">Member No</th>
                            <th class="px-3 py-4">File No</th>
                            <th class="px-3 py-4">Client Name</th>
                            <th class="px-3 py-4">Deleted By</th>
                            <th class="px-3 py-4">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-100 text-sm">
                        @php $x = 1; @endphp
                        @foreach($deletedClients as $client)
                            <tr id="client-row-{{ $client->cl_id }}">
                                <td class="px-3 py-3 text-center">{{ $x++ }}</td>
                                <td class="px-3 py-3 text-center font-semibold text-red-700">{{ $client->old_member_no ?? '' }}</td>
                                <td class="px-3 py-3 text-center">{{ $client->file_no ?? '' }}</td>
                                <td class="px-3 py-3 text-right font-bold text-gray-900">{{ $client->arabic_name ?? '' }}</td>
                                <td class="px-3 py-3 text-center text-xs">{{ $client->adname ?? '' }}</td>
                                <td class="px-3 py-3 text-center">
                                    <button class="restore-client-btn bg-amber-600 text-white px-4 py-2 rounded-lg hover:bg-amber-700 transition font-semibold"
                                        data-id="{{ $client->cl_id }}">
                                        <i class="entypo-cw"></i> Restore
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Tab 2: Deleted Receipts -->
        <div id="content-receipts" class="tab-content hidden">
            <div class="overflow-x-auto rounded-xl border border-gray-100">
                <table id="table-receipts" class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-red-50/50">
                        <tr class="text-[10px] font-bold text-gray-500 uppercase tracking-widest text-center">
                            <th class="px-3 py-4">#</th>
                            <th class="px-3 py-4">Member No</th>
                            <th class="px-3 py-4">File No</th>
                            <th class="px-3 py-4">Client Name</th>
                            <th class="px-3 py-4">Date</th>
                            <th class="px-3 py-4">Value</th>
                            <th class="px-3 py-4">Receipt No</th>
                            <th class="px-3 py-4">Bank</th>
                            <th class="px-3 py-4">Type</th>
                            <th class="px-3 py-4">Deleted By</th>
                            <th class="px-3 py-4">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-100 text-sm">
                        @php $x = 1; @endphp
                        @foreach($deletedReceipts as $receipt)
                            <tr id="receipt-row-{{ $receipt->rid }}">
                                <td class="px-3 py-3 text-center">{{ $x++ }}</td>
                                <td class="px-3 py-3 text-center font-semibold text-red-700">{{ $receipt->old_member_no ?? '' }}</td>
                                <td class="px-3 py-3 text-center">{{ $receipt->file_no ?? '' }}</td>
                                <td class="px-3 py-3 text-right font-bold text-gray-900">{{ $receipt->arabic_name ?? '' }}</td>
                                <td class="px-3 py-3 text-center">{{ $receipt->date ?? '' }}</td>
                                <td class="px-3 py-3 text-center font-bold text-red-600">{{ number_format($receipt->value ?? 0) }}</td>
                                <td class="px-3 py-3 text-center">{{ $receipt->number ?? '' }}</td>
                                <td class="px-3 py-3 text-center text-xs">{{ $receipt->bank_name ?? '' }}</td>
                                <td class="px-3 py-3 text-center">{{ $receipt->type_name ?? '' }}</td>
                                <td class="px-3 py-3 text-center text-xs">{{ $receipt->adname ?? '' }}</td>
                                <td class="px-3 py-3 text-center">
                                    <button class="restore-receipt-btn bg-amber-600 text-white px-4 py-2 rounded-lg hover:bg-amber-700 transition font-semibold"
                                        data-id="{{ $receipt->rid }}">
                                        <i class="entypo-cw"></i> Restore
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @push('styles')
        <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
        <style>
            .dt-buttons {
                margin-bottom: 20px;
            }

            .dt-button {
                @apply px-4 py-2 bg-white border border-gray-200 rounded-lg text-sm font-medium hover:bg-gray-50 transition-all !important;
            }

            table thead th {
                @apply border-r border-gray-100 last:border-r-0;
            }

            table tbody td {
                @apply border-r border-gray-50 last:border-r-0;
            }

            .tab-btn.active {
                @apply bg-red-600 text-white;
            }
        </style>
    @endpush

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

        <script>
            $(document).ready(function () {
                // Initialize DataTables
                $('#table-clients').DataTable({
                    dom: 'Bfrtip',
                    buttons: [
                        { extend: 'copy', className: 'bg-gray-100' },
                        { extend: 'excel', title: 'Deleted Clients', className: 'bg-red-50 text-red-700 border-red-200' },
                        { extend: 'pdf', title: 'Deleted Clients', className: 'bg-rose-50 text-rose-700 border-rose-200' },
                        { extend: 'print', className: 'bg-blue-50 text-blue-700 border-blue-200' }
                    ]
                });

                $('#table-receipts').DataTable({
                    dom: 'Bfrtip',
                    buttons: [
                        { extend: 'copy', className: 'bg-gray-100' },
                        { extend: 'excel', title: 'Deleted Receipts', className: 'bg-red-50 text-red-700 border-red-200' },
                        { extend: 'pdf', title: 'Deleted Receipts', orientation: 'landscape', className: 'bg-rose-50 text-rose-700 border-rose-200' },
                        { extend: 'print', className: 'bg-blue-50 text-blue-700 border-blue-200' }
                    ]
                });

                // Tab switching
                $('#tab-clients').click(function () {
                    $('.tab-btn').removeClass('active bg-red-600 text-white').addClass('bg-gray-200 text-gray-700');
                    $(this).removeClass('bg-gray-200 text-gray-700').addClass('active bg-red-600 text-white');
                    $('.tab-content').addClass('hidden');
                    $('#content-clients').removeClass('hidden');
                });

                $('#tab-receipts').click(function () {
                    $('.tab-btn').removeClass('active bg-red-600 text-white').addClass('bg-gray-200 text-gray-700');
                    $(this).removeClass('bg-gray-200 text-gray-700').addClass('active bg-red-600 text-white');
                    $('.tab-content').addClass('hidden');
                    $('#content-receipts').removeClass('hidden');
                });

                // Restore client
                $('.restore-client-btn').click(function () {
                    const cl_id = $(this).data('id');
                    const row = $('#client-row-' + cl_id);

                    if (confirm('Restore this client?')) {
                        $.post('{{ route("reports.deleted_items_restore_client") }}', {
                            cl_id: cl_id,
                            _token: '{{ csrf_token() }}'
                        }, function (response) {
                            if (response.success) {
                                row.fadeOut(300, function () {
                                    $(this).remove();
                                });
                            }
                        });
                    }
                });

                // Restore receipt
                $('.restore-receipt-btn').click(function () {
                    const id = $(this).data('id');
                    const row = $('#receipt-row-' + id);

                    if (confirm('Restore this receipt?')) {
                        $.post('{{ route("reports.deleted_items_restore_receipt") }}', {
                            id: id,
                            _token: '{{ csrf_token() }}'
                        }, function (response) {
                            if (response.success) {
                                row.fadeOut(300, function () {
                                    $(this).remove();
                                });
                            }
                        });
                    }
                });
            });
        </script>
    @endpush
@endsection
