@extends('layouts.admin')

@section('header')
    {{ __('Print Checks') }}
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h2 class="text-2xl font-bold text-gray-900 mb-6">طباعه الشيكات</h2>

        <div class="max-w-md">
            <label class="block text-lg font-semibold text-gray-700 mb-3">يرجى اختيار البنك</label>
            <select id="bank-select"
                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 text-lg">
                <option value="">أختار.....</option>
                @foreach($banks as $bank)
                    <option value="{{ $bank->bank_id }}">{{ $bank->bank_name }}</option>
                @endforeach
            </select>

            <div class="mt-6 p-4 bg-blue-50 border border-blue-200 rounded-lg">
                <p class="text-sm text-gray-600">
                    <i class="entypo-info"></i> بعد اختيار البنك سيتم توجيهك لصفحة طباعة الشيكات الخاصة بالبنك المحدد
                </p>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script>
            $(document).ready(function () {
                $('#bank-select').change(function () {
                    const bankId = $(this).val();
                    if (bankId && bankId !== '') {
                        let bank = 'aai';
                        if (bankId == 6 || bankId == 7) bank = 'ahly';
                        if (bankId == 34 || bankId == 10) bank = 'misr';
                        if (bankId == 33) bank = 'aai';

                        alert('سيتم التوجيه لصفحة طباعة شيكات بنك ' + $(this).find('option:selected').text());
                        // In production, redirect to bank-specific check print page
                        // window.location = '/admin/print/checks/' + bank;
                    }
                });
            });
        </script>
    @endpush
@endsection