@extends('layouts.admin')

@section('header')
    {{ __('Membership Form') }}
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h2 class="text-2xl font-bold text-gray-900 mb-6">استماره طلب عضويه</h2>

        <div class="p-4 bg-blue-50 border border-blue-200 rounded-lg mb-6">
            <p class="text-sm"><i class="entypo-info"></i> املأ البيانات التالية لتقديم طلب عضوية جديد</p>
        </div>

        <form id="membership-form">
            @csrf
            <table class="w-full">
                <tr>
                    <td class="font-bold py-2 px-2">الاسم بالعربيه</td>
                    <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="arabic_name"
                            required /></td>
                    <td class="font-bold py-2 px-2">الاسم بالانجليزيه</td>
                    <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="english_name"
                            required /></td>
                </tr>
                <tr>
                    <td class="font-bold py-2 px-2">الرقم القومى</td>
                    <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="nat_id" maxlength="14"
                            required /></td>
                    <td class="font-bold py-2 px-2">رقم البطاقه العسكريه</td>
                    <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="milit_card_id"
                            required /></td>
                </tr>
                <tr>
                    <td class="font-bold py-2 px-2">العنوان</td>
                    <td><textarea class="form-control w-full px-3 py-2 border rounded" name="address"></textarea></td>
                    <td class="font-bold py-2 px-2">الجنسيه</td>
                    <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="nationality"
                            value="مصرى" /></td>
                </tr>
                <tr>
                    <td class="font-bold py-2 px-2">رقم الموبايل</td>
                    <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="mobile" maxlength="11"
                            required /></td>
                    <td class="font-bold py-2 px-2">النوع</td>
                    <td>
                        <select class="form-control w-full px-3 py-2 border rounded" name="gender">
                            @foreach($genders as $gender)
                                <option value="{{ $gender['id'] }}">{{ $gender['name'] }}</option>
                            @endforeach
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="font-bold py-2 px-2">المحافظه</td>
                    <td>
                        <select class="form-control w-full px-3 py-2 border rounded" name="city">
                            @foreach($states as $state)
                                <option value="{{ $state['id'] }}">{{ $state['name'] }}</option>
                            @endforeach
                        </select>
                    </td>
                    <td class="font-bold py-2 px-2">الحى</td>
                    <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="state" /></td>
                </tr>
                <tr>
                    <td class="font-bold py-2 px-2">البريد الاليكترونى</td>
                    <td><input type="email" class="form-control w-full px-3 py-2 border rounded" name="email" /></td>
                    <td class="font-bold py-2 px-2">المؤهل</td>
                    <td><input type="text" class="form-control w-full px-3 py-2 border rounded" name="cert" /></td>
                </tr>
                <tr>
                    <td colspan="4" class="text-center pt-6">
                        <button type="submit" class="bg-emerald-600 text-white px-6 py-2 rounded-lg hover:bg-emerald-700">
                            <i class="entypo-download"></i> حفظ
                        </button>
                    </td>
                </tr>
            </table>
        </form>

        @if($members->count() > 0)
            <hr class="my-8">
            <h3 class="text-xl font-bold mb-4">طلبات العضوية المسجلة</h3>
            <table class="w-full border-collapse" id="members-table">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="border p-2">الاسم</th>
                        <th class="border p-2">الرقم القومى</th>
                        <th class="border p-2">رقم الموبايل</th>
                        <th class="border p-2">أجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($members as $member)
                        <tr id="row-{{ $member->cl_id }}">
                            <td class="border p-2">{{ $member->arabic_name }}</td>
                            <td class="border p-2">{{ $member->nat_id }}</td>
                            <td class="border p-2">{{ $member->mobile }}</td>
                            <td class="border p-2 text-center">
                                <button class="print-btn bg-blue-600 text-white px-3 py-1 rounded hover:bg-blue-700 text-sm"
                                    data-id="{{ $member->cl_id }}" data-name="{{ $member->arabic_name }}"
                                    data-nat="{{ $member->nat_id }}" data-mobile="{{ $member->mobile }}">
                                    <i class="entypo-print"></i> طباعه
                                </button>
                                <button
                                    class="edit-btn bg-emerald-600 text-white px-3 py-1 rounded hover:bg-emerald-700 text-sm ml-1"
                                    data-id="{{ $member->cl_id }}">
                                    <i class="entypo-pencil"></i> تعديل
                                </button>
                                <button class="delete-btn bg-red-600 text-white px-3 py-1 rounded hover:bg-red-700 text-sm ml-1"
                                    data-id="{{ $member->cl_id }}" data-name="{{ $member->arabic_name }}">
                                    <i class="entypo-trash"></i> حذف
                                </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
    </div>

    <!-- Print Modal (hidden) -->
    <div id="print-area" style="display:none;">
        <div style="direction:rtl; padding:20px; font-family: Arial;">
            <h2 style="text-align:center;">استماره طلب عضويه</h2>
            <hr>
            <p><strong>الاسم:</strong> <span id="print-name"></span></p>
            <p><strong>الرقم القومى:</strong> <span id="print-nat"></span></p>
            <p><strong>رقم الموبايل:</strong> <span id="print-mobile"></span></p>
        </div>
    </div>

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script>
            $(document).ready(function () {
                // Print individual record
                $('.print-btn').click(function () {
                    const name = $(this).data('name');
                    const nat = $(this).data('nat');
                    const mobile = $(this).data('mobile');

                    $('#print-name').text(name);
                    $('#print-nat').text(nat);
                    $('#print-mobile').text(mobile);

                    const printContent = document.getElementById('print-area').innerHTML;
                    const originalContent = document.body.innerHTML;
                    document.body.innerHTML = printContent;
                    window.print();
                    document.body.innerHTML = originalContent;
                    location.reload();
                });

                // Edit button
                $('.edit-btn').click(function () {
                    const id = $(this).data('id');
                    Swal.fire({
                        title: 'تعديل',
                        text: 'سيتم تحميل البيانات للتعديل',
                        icon: 'info',
                    });
                    // Redirect to edit page or load data into form
                    // window.location = '/admin/print/membership-form?edit=' + id;
                });

                // Delete button
                $('.delete-btn').click(function () {
                    const id = $(this).data('id');
                    const name = $(this).data('name');

                    Swal.fire({
                        title: 'هل أنت متأكد؟',
                        text: 'سيتم حذف طلب العضوية لـ ' + name,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#dc2626',
                        cancelButtonColor: '#6b7280',
                        confirmButtonText: 'نعم، احذف',
                        cancelButtonText: 'إلغاء'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // AJAX Delete call would go here
                            $('#row-' + id).fadeOut(300, function () {
                                $(this).remove();
                            });
                            Swal.fire('تم الحذف!', 'تم حذف الطلب بنجاح', 'success');
                        }
                    });
                });

                // Form submission
                $('#membership-form').submit(function (e) {
                    e.preventDefault();
                    Swal.fire({
                        title: 'جاري الحفظ...',
                        text: 'يتم حفظ طلب العضوية',
                        icon: 'info',
                        showConfirmButton: false
                    });

                    // AJAX save would go here
                    setTimeout(() => {
                        Swal.fire('تم الحفظ!', 'تم حفظ طلب العضوية بنجاح', 'success');
                    }, 1000);
                });
            });
        </script>
    @endpush
@endsection