@extends('layouts.admin')

@section('header')
    {{ __('Print Warning Letters') }}
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h1 class="text-3xl font-bold text-center mb-6 underline">طباعه اخطارات التخصيص</h1>

        <div class="grid grid-cols-2 gap-4 mb-6">
            <div>
                <label class="block font-bold mb-2">المشروع:</label>
                <select class="form-control w-full px-3 py-2 border rounded" id="project-select">
                    <option value="0">اختار المشروع</option>
                    @foreach($projects as $project)
                        <option value="{{ $project->prj_id }}" {{ $projectId == $project->prj_id ? 'selected' : '' }}>
                            {{ $project->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block font-bold mb-2">المساحه:</label>
                <select class="form-control w-full px-3 py-2 border rounded" id="area-select">
                    <option value="0">الكل</option>
                    @foreach($areas as $areaItem)
                        <option value="{{ base64_encode($areaItem->area) }}">{{ $areaItem->area }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        @if($projectId > 0)
            <div class="flex gap-2 mb-4">
                <button class="btn-delete-data bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700"
                    data-id="{{ $projectId }}">
                    <i class="entypo-trash"></i> مسح بيانات المشروع
                </button>
                <button class="btn-review bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700"
                    data-id="{{ $projectId }}">
                    <i class="entypo-eye"></i> مراجعه بيانات المشروع
                </button>
            </div>
        @endif

        <table class="w-full border-collapse" id="warnings-table">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">الاسم</th>
                    <th class="border p-2">رقم العضويه</th>
                    <th class="border p-2">المساحه</th>
                    <th class="border p-2">عماره</th>
                    <th class="border p-2">وحده</th>
                    <th class="border p-2">
                        <button class="print-all bg-emerald-600 text-white px-3 py-1 rounded text-sm">طباعه الكل</button>
                        <button class="print-all-info bg-blue-600 text-white px-3 py-1 rounded text-sm ml-1">طباعه الكل
                            معلوميه</button>
                        <button class="print-all-garden bg-teal-600 text-white px-3 py-1 rounded text-sm ml-1">طباعه الكل
                            حدائق</button>
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach($clients as $client)
                    <tr>
                        <td class="border p-2">{{ $client->name }}</td>
                        <td class="border p-2">{{ $client->mem_no }}</td>
                        <td class="border p-2">{{ $client->area }}</td>
                        <td class="border p-2">{{ $client->bldg }}</td>
                        <td class="border p-2">{{ $client->flat_num }}</td>
                        <td class="border p-2 text-center">
                            <button class="print-warning bg-emerald-600 text-white px-2 py-1 rounded text-sm"
                                data-id="{{ $client->mem_no }}" data-prj="{{ $projectId }}">
                                <i class="entypo-print"></i> طباعه انذار
                            </button>
                            <button class="print-info bg-blue-600 text-white px-2 py-1 rounded text-sm ml-1"
                                data-id="{{ $client->mem_no }}" data-prj="{{ $projectId }}">
                                <i class="entypo-print"></i> طباعه معلوميه
                            </button>
                            @if(in_array($client->mem_no, $gardenClients))
                                <button class="print-garden bg-teal-600 text-white px-2 py-1 rounded text-sm ml-1"
                                    data-id="{{ $client->mem_no }}" data-prj="{{ $projectId }}">
                                    <i class="entypo-print"></i> طباعه انذار حديقه
                                </button>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script>
            $(document).ready(function () {
                $('#project-select').change(function () {
                    const prj = $(this).val();
                    window.location = '/admin/letters/print-warnings?project_id=' + prj;
                });

                $('#area-select').change(function () {
                    const area = $(this).val();
                    const prj = $('#project-select').val();
                    window.location = '/admin/letters/print-warnings?project_id=' + prj + '&area=' + area;
                });

                function printLetter(memNo, prj, type) {
                    const date = prompt('يرجى ادخال تاريخ الانذار.');
                    if (!date) return;
                    const num = prompt('يرجى ادخال رقم الانذار.');
                    if (!num) return;

                    $.post('/admin/letters/generate-letter', {
                        _token: '{{ csrf_token() }}',
                        mem_no: memNo,
                        prj: prj,
                        date: date,
                        num: num,
                        type: type
                    }, function (data) {
                        const WinPrint = window.open('', '', 'width=900,height=550');
                        WinPrint.document.write(data);
                        WinPrint.document.close();
                        WinPrint.focus();
                        setTimeout(() => WinPrint.print(), 2000);
                    });
                }

                $('.print-warning').click(function () {
                    printLetter($(this).data('id'), $(this).data('prj'), 'standard');
                });

                $('.print-info').click(function () {
                    printLetter($(this).data('id'), $(this).data('prj'), 'info');
                });

                $('.print-garden').click(function () {
                    printLetter($(this).data('id'), $(this).data('prj'), 'garden');
                });

                $('.print-all, .print-all-info, .print-all-garden').click(function () {
                    let memNos = '';
                    $('.print-warning').each(function () {
                        memNos += $(this).data('id') + "','";
                    });
                    const type = $(this).hasClass('print-all-info') ? 'info' : ($(this).hasClass('print-all-garden') ? 'garden' : 'standard');
                    const prj = $('#project-select').val();
                    printLetter(memNos, prj, type);
                });

                $('.btn-delete-data').click(function () {
                    if (!confirm('هل تريد مسح البيانات؟')) return;
                    $.post('/admin/letters/delete-project-data', {
                        _token: '{{ csrf_token() }}',
                        prj: $(this).data('id')
                    }, function (data) {
                        alert(data.message);
                        location.reload();
                    });
                });

                $('.btn-review').click(function () {
                    $.post('/admin/letters/review-project', {
                        _token: '{{ csrf_token() }}',
                        prj: $(this).data('id')
                    }, function (data) {
                        const WinPrint = window.open('', '', 'width=1300,height=750');
                        WinPrint.document.write(data);
                    });
                });
            });
        </script>
    @endpush
@endsection