@extends('layouts.admin')

@section('header')
    {{ __('Import Transactions') }}
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h2 class="text-2xl font-bold mb-6">استيراد المعاملات المالية من Excel</h2>

        <div class="mb-6">
            <label class="block font-bold mb-2">اختر ملف Excel:</label>
            <input type="file" id="fileUpload" class="form-control" accept=".xls,.xlsx" />
            <button id="upload" class="bg-emerald-600 text-white px-6 py-2 rounded mt-3 hover:bg-emerald-700">
                <i class="entypo-upload"></i> Upload & Import
            </button>
        </div>

        <div id="dvExcel" class="overflow-x-auto"></div>
    </div>

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
        <script>
            $(document).ready(function () {
                $("#upload").on("click", function () {
                    const fileUpload = $("#fileUpload")[0];
                    const regex = /^([a-zA-Z0-9\s_\\.\-:])+(.xls|.xlsx)$/;

                    if (regex.test(fileUpload.value.toLowerCase())) {
                        if (typeof (FileReader) != "undefined") {
                            const reader = new FileReader();

                            if (reader.readAsBinaryString) {
                                reader.onload = function (e) {
                                    ProcessExcel(e.target.result);
                                };
                                reader.readAsBinaryString(fileUpload.files[0]);
                            } else {
                                reader.onload = function (e) {
                                    let data = "";
                                    const bytes = new Uint8Array(e.target.result);
                                    for (let i = 0; i < bytes.byteLength; i++) {
                                        data += String.fromCharCode(bytes[i]);
                                    }
                                    ProcessExcel(data);
                                };
                                reader.readAsArrayBuffer(fileUpload.files[0]);
                            }
                        } else {
                            alert("This browser does not support HTML5.");
                        }
                    } else {
                        alert("Please upload a valid Excel file.");
                    }
                });

                function ProcessExcel(data) {
                    const workbook = XLSX.read(data, { type: 'binary' });
                    const firstSheet = workbook.SheetNames[0];
                    const excelRows = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[firstSheet]);

                    const table = $("<table class='w-full border-collapse' />");
                    table[0].border = "1";

                    // Add header row
                    let row = $(table[0].insertRow(-1));
                    row.addClass('bg-gray-100');
                    const headers = ['trans_date', 'val_date', 'trans_ref_no', 'desc', 'debit', 'credit', 'balance'];
                    headers.forEach(h => {
                        const headerCell = $("<th class='border p-2' />");
                        headerCell.html(h);
                        row.append(headerCell);
                    });

                    // Add data rows
                    for (let i = 0; i < excelRows.length; i++) {
                        const dataRow = $(table[0].insertRow(-1));
                        dataRow.attr('id', 'row-' + i);

                        headers.forEach(h => {
                            const cell = $("<td class='border p-2' />");
                            cell.html(excelRows[i][h] || '');
                            dataRow.append(cell);
                        });

                        // Post Data
                        $.ajax({
                            url: "{{ route('import.process_row') }}",
                            type: "post",
                            data: {
                                _token: '{{ csrf_token() }}',
                                trans_date: excelRows[i].trans_date,
                                val_date: excelRows[i].val_date,
                                trans_ref_no: excelRows[i].trans_ref_no,
                                desc: excelRows[i].desc,
                                debit: excelRows[i].debit,
                                credit: excelRows[i].credit,
                                balance: excelRows[i].balance
                            },
                            success: function (response) {
                                dataRow.css('background-color', '#d4edda');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                dataRow.css('background-color', '#f8d7da');
                                console.log(textStatus, errorThrown);
                            }
                        });
                    }

                    $("#dvExcel").html("");
                    $("#dvExcel").append(table);
                }
            });
        </script>
    @endpush
@endsection