@extends('layouts.admin')

@section('content')
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800">{{ __('Vacations & Leaves') }}</h1>
            <button class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">{{ __('Request Leave') }}</button>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <table class="w-full text-start">
                <thead class="bg-gray-50 text-sm font-semibold text-gray-600">
                    <tr>
                        <th class="px-6 py-4 text-start">{{ __('Employee') }}</th>
                        <th class="px-6 py-4 text-start">{{ __('Type') }}</th>
                        <th class="px-6 py-4 text-start">{{ __('From') }}</th>
                        <th class="px-6 py-4 text-start">{{ __('To') }}</th>
                        <th class="px-6 py-4 {{ app()->getLocale() == 'ar' ? 'text-left' : 'text-right' }}">
                            {{ __('Duration') }}</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @foreach($vacations as $vac)
                        @php
                            $start = \Carbon\Carbon::parse($vac->date_from);
                            $end = \Carbon\Carbon::parse($vac->date_to);
                            $days = $start->diffInDays($end) + 1;
                        @endphp
                        <tr class="hover:bg-gray-50 transition duration-150">
                            <td class="px-6 py-4 text-sm font-medium text-gray-900">{{ $vac->employee->arabic_name }}</td>
                            <td class="px-6 py-4 text-sm">
                                <span
                                    class="px-2 py-1 {{ $vac->type == 'vac' ? 'bg-green-50 text-green-700' : 'bg-red-50 text-red-700' }} rounded text-xs font-medium">
                                    {{ $vac->type == 'vac' ? __('Vacation') : ($vac->type == 'sick' ? __('Sick Leave') : __(ucfirst($vac->type))) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-600">{{ $vac->date_from }}</td>
                            <td class="px-6 py-4 text-sm text-gray-600">{{ $vac->date_to }}</td>
                            <td class="px-6 py-4 {{ app()->getLocale() == 'ar' ? 'text-left' : 'text-right' }}">
                                <span class="font-bold text-gray-700">{{ $days }} {{ __('days') }}</span>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection