<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">

<head>
    <meta charset="UTF-8">
    <title>{{ __('Salary Slip') }} - {{ $employee->arabic_name }}</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 20px;
            direction:
                {{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}
            ;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .info-table,
        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .info-table th,
        .info-table td {
            text-align:
                {{ app()->getLocale() == 'ar' ? 'right' : 'left' }}
            ;
            padding: 8px;
            border: 1px solid #eee;
        }

        .data-table th,
        .data-table td {
            border: 1px solid #333;
            padding: 10px;
            text-align: center;
        }

        .data-table th {
            bg-color: #f5f5f5;
        }

        .signature {
            margin-top: 50px;
            text-align:
                {{ app()->getLocale() == 'ar' ? 'left' : 'right' }}
            ;
            padding-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}: 50px;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                margin: 0;
            }
        }
    </style>
</head>

<body onload="window.print()">
    <div class="header">
        <h1>{{ __('Salary Slip') }}</h1>
        <p>{{ __('Month:') }} {{ $month }} / {{ date('Y') }}</p>
    </div>

    <table class="info-table">
        <tr>
            <th>{{ __('Employee ID:') }}</th>
            <td>{{ $employee->emp_id }}</td>
            <th>{{ __('Employee Name:') }}</th>
            <td>{{ $employee->arabic_name }}</td>
        </tr>
        <tr>
            <th>{{ __('Job Title:') }}</th>
            <td>{{ $employee->job }}</td>
            <th>{{ __('Work Location:') }}</th>
            <td>{{ $employee->job_place }}</td>
        </tr>
    </table>

    @php
        $salary = $employee->salaries->first();
        $base = $employee->salary;
        $incentive = $salary->incentive ?? 0;
        $meal = $salary->meal ?? 0;
        $extra = $salary->extra ?? 0;
        $transp = $salary->transp ?? 0;
        $absence = $salary->absence ?? 0;
        $loans = $salary->loans ?? 0;
        $total = ($base + $incentive + $meal + $extra + $transp) - ($absence + $loans);
    @endphp

    <table class="data-table">
        <thead>
            <tr>
                <th>{{ __('Base Salary') }}</th>
                <th>{{ __('Extra') }}</th>
                <th>{{ __('Transp.') }}</th>
                <th>{{ __('Incentive') }}</th>
                <th>{{ __('Meal') }}</th>
                <th>{{ __('Absence') }}</th>
                <th>{{ __('Loans') }}</th>
                <th>{{ __('Total') }}</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>{{ number_format($base) }}</td>
                <td>{{ number_format($extra) }}</td>
                <td>{{ number_format($transp) }}</td>
                <td>{{ number_format($incentive) }}</td>
                <td>{{ number_format($meal) }}</td>
                <td>{{ number_format($absence) }}</td>
                <td>{{ number_format($loans) }}</td>
                <td style="font-weight: bold;">{{ number_format($total) }} EGP</td>
            </tr>
        </tbody>
    </table>

    @if(($options['pr_x'] ?? '1') == '1')
        <div style="margin-top: 20px; font-size: 14px; line-height: 1.6;">
            <p>{{ __('Acknowledgement', ['month' => $month, 'year' => date('Y')]) }}</p>
        </div>
    @endif

    <div style="margin-top: 40px; display: flex; justify-content: space-between;">
        @if(($options['emp_x'] ?? '1') == '1')
            <div style="text-align: center;">
                <p>{{ __('Employee Signature:') }}</p>
                <br>
                __________________
            </div>
        @endif


    </div>

    <div class="no-print" style="margin-top: 20px; text-align: center;">
        <button onclick="window.print()" style="padding: 10px 20px; cursor: pointer;">{{ __('Print') }}</button>
        <button onclick="window.close()" style="padding: 10px 20px; cursor: pointer;">{{ __('Close') }}</button>
    </div>
</body>

</html>