<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <title>تقرير الرواتب - شهر {{ $month }}</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 20px;
            direction: rtl;
            font-size: 12px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
        }

        .data-table th,
        .data-table td {
            border: 1px solid #333;
            padding: 5px;
            text-align: center;
        }

        .data-table th {
            background-color: #f5f5f5;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                margin: 10mm;
            }
        }
    </style>
</head>

<body onload="window.print()">
    <div class="header">
        <h1>كشف رواتب الموظفين</h1>
        <p>شهر: {{ $month }} / {{ date('Y') }} {{ $jobPlace ? '- مشروع: ' . $jobPlace : '' }}</p>
    </div>

    @php
        $totalBase = 0;
        $totalExtra = 0;
        $totalTransp = 0;
        $totalIncentive = 0;
        $totalMeal = 0;
        $totalAbsence = 0;
        $totalLoans = 0;
        $totalNet = 0;
    @endphp

    <table class="data-table">
        <thead>
            <tr>
                <th>م</th>
                <th>الاسم</th>
                <th>الوظيفة</th>
                <th>الراتب الأساسي</th>
                <th>الإضافي</th>
                <th>انتقالات</th>
                <th>حوافز</th>
                <th>وجبة</th>
                <th>غياب</th>
                <th>سلف</th>
                <th>الصافي</th>
                <th>التوقيع</th>
            </tr>
        </thead>
        <tbody>
            @foreach($employees as $index => $emp)
                @php
                    $salary = $emp->salaries->first();
                    $base = $emp->salary;
                    $incentive = $salary->incentive ?? 0;
                    $meal = $salary->meal ?? 0;
                    $extra = $salary->extra ?? 0;
                    $transp = $salary->transp ?? 0;
                    $absence = $salary->absence ?? 0;
                    $loans = $salary->loans ?? 0;
                    $total = ($base + $incentive + $meal + $extra + $transp) - ($loans + $absence);

                    $totalBase += $base;
                    $totalExtra += $extra;
                    $totalTransp += $transp;
                    $totalIncentive += $incentive;
                    $totalMeal += $meal;
                    $totalAbsence += $absence;
                    $totalLoans += $loans;
                    $totalNet += $total;
                @endphp
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td style="text-align: right;">{{ $emp->arabic_name }}</td>
                    <td>{{ $emp->job }}</td>
                    <td>{{ number_format($base) }}</td>
                    <td>{{ number_format($extra) }}</td>
                    <td>{{ number_format($transp) }}</td>
                    <td>{{ number_format($incentive) }}</td>
                    <td>{{ number_format($meal) }}</td>
                    <td>{{ number_format($absence) }}</td>
                    <td>{{ number_format($loans) }}</td>
                    <td style="font-weight: bold;">{{ number_format($total) }}</td>
                    <td style="width: 100px;"></td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr style="background-color: #f9f9f9; font-weight: bold;">
                <td colspan="3">الاجمالى</td>
                <td>{{ number_format($totalBase) }}</td>
                <td>{{ number_format($totalExtra) }}</td>
                <td>{{ number_format($totalTransp) }}</td>
                <td>{{ number_format($totalIncentive) }}</td>
                <td>{{ number_format($totalMeal) }}</td>
                <td>{{ number_format($totalAbsence) }}</td>
                <td>{{ number_format($totalLoans) }}</td>
                <td>{{ number_format($totalNet) }}</td>
                <td></td>
            </tr>
        </tfoot>
    </table>

    @if(($options['pr_x'] ?? '1') == '1')
        <div style="margin-top: 30px; border: 1px solid #333; padding: 15px; font-size: 14px; line-height: 2;">
            <h3 style="text-align: center; margin-top: 0;">أقرار بالاستلام</h3>
            <p>اقر انا الموقع ادناه/ _________________________________ باستلام مبلغ وقدرة ( {{ number_format($totalNet) }} )
            </p>
            <p>فقط ( _________________ ) وذلك قيمة مرتبات العاملين بمشروع ( {{ $jobPlace ?? '................' }} )</p>
            <p>على ان اقوم بتسليمه لكل فرد والتوقيع بالاستلام</p>
            <div style="display: flex; justify-content: space-between; margin-top: 20px;">
                <span>و هذا اقرار منى بذلك</span>
                <div style="text-align: center;">
                    <span>التوقيع: _________________</span>
                    <br>
                    <span>الاسم: _________________</span>
                </div>
            </div>
        </div>
    @endif

    @if(($options['sign_x'] ?? '1') == '1')
        <div style="margin-top: 50px; display: flex; justify-content: space-around; font-weight: bold;">
            <div style="text-align: center;">
                <p>المدير المالي</p>
                <br><br>
                __________________
            </div>
            <div style="text-align: center;">
                <p>رئيس مجلس الإدارة</p>
                <br><br>
                __________________
            </div>
        </div>
    @endif

    <div class="no-print" style="margin-top: 20px; text-align: center;">
        <button onclick="window.print()" style="padding: 10px 20px; cursor: pointer;">طباعة</button>
        <button onclick="window.close()" style="padding: 10px 20px; cursor: pointer;">إغلاق</button>
    </div>
</body>

</html>