<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <title>تقرير المكافآت - عام {{ $year }}</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 20px;
            direction: rtl;
            font-size: 12px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
        }

        .data-table th,
        .data-table td {
            border: 1px solid #333;
            padding: 5px;
            text-align: center;
        }

        .data-table th {
            background-color: #f5f5f5;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                margin: 10mm;
            }
        }
    </style>
</head>

<body onload="window.print()">
    <div class="header">
        <h1>كشف مكافآت الموظفين</h1>
        <p>عام: {{ $year }} {{ $jobPlace ? '- مشروع: ' . $jobPlace : '' }}</p>
    </div>

    @php $totalAmount = 0; @endphp
    <table class="data-table">
        <thead>
            <tr>
                <th>م</th>
                <th>الاسم</th>
                <th>الوظيفة</th>
                <th>النوع</th>
                <th>القيمة</th>
                <th>التاريخ</th>
                <th>التوقيع</th>
            </tr>
        </thead>
        <tbody>
            @foreach($bonuses as $index => $bonus)
                @php $totalAmount += $bonus->amount; @endphp
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td style="text-align: right;">{{ $bonus->employee->arabic_name }}</td>
                    <td>{{ $bonus->employee->job }}</td>
                    <td>{{ $bonus->type }}</td>
                    <td style="font-weight: bold;">{{ number_format($bonus->amount) }}</td>
                    <td>{{ date('d-m-Y', $bonus->crdate) }}</td>
                    <td style="width: 150px;"></td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr style="background-color: #f9f9f9; font-weight: bold;">
                <td colspan="4">الاجمالى</td>
                <td>{{ number_format($totalAmount) }}</td>
                <td colspan="2"></td>
            </tr>
        </tfoot>
    </table>

    @if(($options['pr_x'] ?? '1') == '1')
        <div style="margin-top: 30px; border: 1px solid #333; padding: 15px; font-size: 14px; line-height: 2;">
            <h3 style="text-align: center; margin-top: 0;">أقرار بالاستلام</h3>
            <p>اقر انا الموقع ادناه/ _________________________________ باستلام مبلغ وقدرة (
                {{ number_format($totalAmount) }} )</p>
            <p>فقط ( _________________ ) وذلك قيمة مكافآت العاملين بمشروع ( {{ $jobPlace ?? '................' }} )</p>
            <p>على ان اقوم بتسليمه لكل فرد والتوقيع بالاستلام</p>
            <div style="display: flex; justify-content: space-between; margin-top: 20px;">
                <span>و هذا اقرار منى بذلك</span>
                <div style="text-align: center;">
                    <span>التوقيع: _________________</span>
                    <br>
                    <span>الاسم: _________________</span>
                </div>
            </div>
        </div>
    @endif

    @if(($options['sign_x'] ?? '1') == '1')
        <div style="margin-top: 50px; display: flex; justify-content: space-around; font-weight: bold;">
            <div style="text-align: center;">
                <p>المدير المالي</p>
                <br><br>
                __________________
            </div>
            <div style="text-align: center;">
                <p>رئيس مجلس الإدارة</p>
                <br><br>
                __________________
            </div>
        </div>
    @endif

    <div class="no-print" style="margin-top: 20px; text-align: center;">
        <button onclick="window.print()" style="padding: 10px 20px; cursor: pointer;">طباعة</button>
        <button onclick="window.close()" style="padding: 10px 20px; cursor: pointer;">إغلاق</button>
    </div>
</body>

</html>