@extends('layouts.admin')

@section('content')
    <div class="bg-white rounded-lg shadow-sm p-6">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-xl font-semibold text-gray-800">{{ __('Edit Employee:') }} {{ $employee->arabic_name }}</h2>
            <a href="{{ route('hr.index') }}" class="text-gray-600 hover:text-gray-900 transition-colors">
                @if(app()->getLocale() == 'ar')
                    {{ __('Back to List') }} &rarr;
                @else
                    &larr; {{ __('Back to List') }}
                @endif
            </a>
        </div>

        @if ($errors->any())
            <div class="bg-red-50 text-red-600 p-4 rounded-lg mb-6">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('hr.update', $employee->emp_id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <!-- Names -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Arabic Name') }}</label>
                    <input type="text" name="arabic_name" value="{{ old('arabic_name', $employee->arabic_name) }}"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('English Name') }}</label>
                    <input type="text" name="english_name" value="{{ old('english_name', $employee->english_name) }}"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        required>
                </div>

                <!-- IDs -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('National ID') }}</label>
                    <input type="text" name="nat_id" value="{{ old('nat_id', $employee->nat_id) }}"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        maxlength="14" required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Insurance ID') }}</label>
                    <input type="text" name="ins_id" value="{{ old('ins_id', $employee->ins_id) }}"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <!-- Address & Contact -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Address') }}</label>
                    <input type="text" name="address" value="{{ old('address', $employee->address) }}"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Nationality') }}</label>
                    <input type="text" name="nationality" value="{{ old('nationality', $employee->nationality) }}"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Mobile') }}</label>
                    <input type="text" name="mobile" value="{{ old('mobile', $employee->mobile) }}"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        maxlength="11">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Gender') }}</label>
                    <select name="gender"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <option value="male" {{ $employee->gender == 'male' ? 'selected' : '' }}>{{ __('Male') }}</option>
                        <option value="female" {{ $employee->gender == 'female' ? 'selected' : '' }}>{{ __('Female') }}</option>
                    </select>
                </div>

                <!-- Job Info -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Job Title') }}</label>
                    <input type="text" name="job" value="{{ old('job', $employee->job) }}"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Project / Location') }}</label>
                    <select name="job_place"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        @foreach($jobPlaces as $place)
                            <option value="{{ $place }}" {{ $employee->job_place == $place ? 'selected' : '' }}>{{ $place }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Hire Date') }}</label>
                    <input type="text" name="hire_date" value="{{ old('hire_date', $employee->hire_date) }}"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        placeholder="YYYY-MM-DD">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Birth Date') }}</label>
                    <input type="text" name="bdate" value="{{ old('bdate', $employee->bdate) }}"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        placeholder="YYYY-MM-DD">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Salary') }}</label>
                    <input type="number" name="salary" value="{{ old('salary', $employee->salary) }}"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        step="0.01">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Direct Manager') }}</label>
                    <select name="manager_id"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <option value="">{{ __('None') }}</option>
                        @foreach($managers as $manager)
                            <option value="{{ $manager->emp_id }}" {{ $employee->manager_id == $manager->emp_id ? 'selected' : '' }}>
                                {{ $manager->arabic_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="flex justify-between items-center">
                <button type="button"
                    onclick="if(confirm('{{ __('Are you sure you want to deactivate this employee?') }}')) document.getElementById('delete-form').submit();"
                    class="text-red-600 hover:text-red-900 font-medium">
                    {{ __('Deactivate Employee') }}
                </button>
                <button type="submit"
                    class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition duration-150">
                    {{ __('Update Employee') }}
                </button>
            </div>
        </form>

        <form id="delete-form" action="{{ route('hr.destroy', $employee->emp_id) }}" method="POST" class="hidden">
            @csrf
            @method('DELETE')
        </form>
    </div>
@endsection