@extends('layouts.admin')

@section('content')
    <div class="p-6">
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 space-y-4 md:space-y-0">
            <h1 class="text-2xl font-bold text-gray-800">{{ __('Employee Bonuses') }}</h1>
            <div class="flex flex-wrap items-center gap-3">
                <form action="{{ route('hr.bonuses') }}" method="GET" id="filter-form" class="flex items-center space-x-3">
                    <div class="flex items-center {{ app()->getLocale() == 'ar' ? 'ml-2' : 'space-x-2' }}">
                        <label class="text-sm font-semibold text-gray-600">{{ __('Department:') }}</label>
                        <select name="job_place" onchange="this.form.submit()"
                            class="px-4 py-2 border rounded-lg outline-none focus:ring-2 focus:ring-blue-500 text-sm">
                            <option value="">{{ __('All Projects') }}</option>
                            @foreach($jobPlaces as $place)
                                <option value="{{ $place }}" {{ $jobPlace == $place ? 'selected' : '' }}>{{ $place }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="flex items-center {{ app()->getLocale() == 'ar' ? 'ml-2' : 'space-x-2' }}">
                        <label class="text-sm font-semibold text-gray-600">{{ __('Year:') }}</label>
                        <select name="year" onchange="this.form.submit()"
                            class="px-4 py-2 border rounded-lg outline-none focus:ring-2 focus:ring-blue-500 text-sm">
                            @foreach(range(date('Y') - 2, date('Y') + 1) as $y)
                                <option value="{{ $y }}" {{ $year == $y ? 'selected' : '' }}>{{ $y }}</option>
                            @endforeach
                        </select>
                    </div>
                </form>

                <div class="flex items-center space-x-3 border-l pl-3">
                    <div class="flex flex-col">
                        <label class="text-[10px] uppercase font-bold text-gray-400">{{ __('Signature') }}</label>
                        <select id="sign_x" class="text-xs border rounded p-1">
                            <option value="1">{{ __('Yes') }}</option>
                            <option value="0">{{ __('No') }}</option>
                        </select>
                    </div>
                    <div class="flex flex-col">
                        <label class="text-[10px] uppercase font-bold text-gray-400">{{ __('Ack.') }}</label>
                        <select id="pr_x" class="text-xs border rounded p-1">
                            <option value="1">{{ __('Yes') }}</option>
                            <option value="0">{{ __('No') }}</option>
                        </select>
                    </div>
                    <div class="flex flex-col">
                        <label class="text-[10px] uppercase font-bold text-gray-400">{{ __('Emp. Sign') }}</label>
                        <select id="emp_x" class="text-xs border rounded p-1">
                            <option value="1">{{ __('Yes') }}</option>
                            <option value="0">{{ __('No') }}</option>
                        </select>
                    </div>
                </div>

                <a href="{{ route('hr.bonuses.print_all', ['year' => $year, 'job_place' => $jobPlace]) }}"
                    id="print-all-btn" target="_blank"
                    class="bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 transition flex items-center shadow-sm">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z">
                        </path>
                    </svg>
                    {{ __('Print All') }}
                </a>
            </div>
        </div>

        <form action="{{ route('hr.bonuses.update') }}" method="POST">
            @csrf
            <input type="hidden" name="year" value="{{ $year }}">

            <div class="flex justify-end mb-4">
                <button type="submit"
                    class="px-6 py-2 bg-green-600 text-white rounded-lg font-bold hover:bg-green-700 transition duration-150 shadow-sm">
                    {{ __('Save All Changes') }}
                </button>
            </div>

            <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-x-auto overflow-y-hidden">
                <table class="w-full text-start min-w-[1200px]">
                    <thead class="bg-gray-50 text-sm font-semibold text-gray-600">
                        <tr>
                            <th class="px-4 py-4 text-start">{{ __('Employee') }}</th>
                            <th class="px-2 py-4 text-center">{{ __('Salary') }}</th>
                            <th class="px-2 py-4 text-center">{{ __('Incentive') }}</th>
                            <th class="px-2 py-4 text-center">{{ __('Meal') }}</th>
                            <th class="px-2 py-4 text-center">{{ __('Loans') }}</th>
                            <th class="px-2 py-4 text-center">{{ __('Extra') }}</th>
                            <th class="px-2 py-4 text-center">{{ __('Transp.') }}</th>
                            <th class="px-2 py-4 text-center">{{ __('Adj.') }}</th>
                            <th class="px-4 py-4 text-center">{{ __('Total') }}</th>
                            <th class="px-4 py-4 text-center">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @foreach($employees as $emp)
                            @php
                                $bonus = $emp->bonuses->first();
                            @endphp
                            <tr class="hover:bg-gray-50 transition duration-150">
                                <td class="px-4 py-4">
                                    <div class="text-sm font-medium text-gray-900">{{ $emp->arabic_name }}</div>
                                    <div class="text-xs text-gray-500">{{ $emp->job_place }}</div>
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[{{ $emp->emp_id }}][salary]" value="{{ $emp->salary }}"
                                        class="w-20 px-2 py-1 border rounded text-xs text-center bonus-input-{{ $emp->emp_id }}"
                                        disabled>
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[{{ $emp->emp_id }}][incentive]"
                                        value="{{ $bonus->incentive ?? 0 }}"
                                        class="w-20 px-2 py-1 border rounded text-xs text-center bonus-input-{{ $emp->emp_id }}"
                                        data-emp-id="{{ $emp->emp_id }}">
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[{{ $emp->emp_id }}][meal]"
                                        value="{{ $bonus->meal ?? 0 }}"
                                        class="w-16 px-2 py-1 border rounded text-xs text-center bonus-input-{{ $emp->emp_id }}"
                                        data-emp-id="{{ $emp->emp_id }}">
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[{{ $emp->emp_id }}][loans]"
                                        value="{{ $bonus->loans ?? 0 }}"
                                        class="w-16 px-2 py-1 border rounded text-xs text-center bonus-input-{{ $emp->emp_id }}"
                                        data-emp-id="{{ $emp->emp_id }}">
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[{{ $emp->emp_id }}][extra]"
                                        value="{{ $bonus->amount ?? 0 }}"
                                        class="w-20 px-2 py-1 border rounded text-xs text-center bonus-input-{{ $emp->emp_id }}"
                                        data-emp-id="{{ $emp->emp_id }}">
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[{{ $emp->emp_id }}][transp]"
                                        value="{{ $bonus->transp ?? 0 }}"
                                        class="w-20 px-2 py-1 border rounded text-xs text-center bonus-input-{{ $emp->emp_id }}"
                                        data-emp-id="{{ $emp->emp_id }}">
                                </td>
                                <td class="px-2 py-4 text-center">
                                    <input type="number" name="bonuses[{{ $emp->emp_id }}][taswia]"
                                        value="{{ $bonus->taswia ?? 0 }}"
                                        class="w-16 px-2 py-1 border rounded text-xs text-center bonus-input-{{ $emp->emp_id }}"
                                        data-emp-id="{{ $emp->emp_id }}">
                                </td>
                                <td class="px-4 py-4 text-center font-bold text-blue-600">
                                    <span
                                        id="total-{{ $emp->emp_id }}">{{ number_format($emp->salary + ($bonus ? (($bonus->incentive ?? 0) + ($bonus->meal ?? 0) + ($bonus->amount ?? 0) + ($bonus->transp ?? 0) + ($bonus->taswia ?? 0) - ($bonus->loans ?? 0)) : 0)) }}</span>
                                </td>
                                <td class="px-4 py-4 text-center">
                                    @if($bonus)
                                        <a href="{{ route('hr.bonuses.print', $bonus->id) }}"
                                            data-base-url="{{ route('hr.bonuses.print', $bonus->id) }}" target="_blank"
                                            class="text-gray-400 hover:text-blue-600 transition-colors print-individual"
                                            title="{{ __('Print Slip') }}">
                                            <svg class="w-5 h-5 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z">
                                                </path>
                                            </svg>
                                        </a>
                                    @else
                                        <span class="text-xs text-gray-300 italic"
                                            title="{{ __('Save changes to print') }}">{{ __('Not Saved') }}</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="flex justify-end mt-4">
                <button type="submit"
                    class="px-6 py-2 bg-green-600 text-white rounded-lg font-bold hover:bg-green-700 transition duration-150 shadow-sm">
                    {{ __('Save All Changes') }}
                </button>
            </div>
        </form>
    </div>
@endsection

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Dynamic Print Links update
            const printAllBtn = document.getElementById('print-all-btn');
            const signX = document.getElementById('sign_x');
            const prX = document.getElementById('pr_x');
            const empX = document.getElementById('emp_x');

            function updatePrintUrls() {
                const params = new URLSearchParams({
                    year: '{{ $year }}',
                    job_place: '{{ $jobPlace }}',
                    sign_x: signX.value,
                    pr_x: prX.value,
                    emp_x: empX.value
                });

                printAllBtn.href = `{{ route('hr.bonuses.print_all') }}?${params.toString()}`;

                document.querySelectorAll('.print-individual').forEach(btn => {
                    const baseUrl = btn.dataset.baseUrl;
                    const bonusParams = new URLSearchParams({
                        sign_x: signX.value,
                        pr_x: prX.value,
                        emp_x: empX.value
                    });
                    btn.href = `${baseUrl}?${bonusParams.toString()}`;
                });
            }

            [signX, prX, empX].forEach(el => el.addEventListener('change', updatePrintUrls));
            updatePrintUrls();

            // Dynamic Total Calculation
            document.querySelectorAll('input[type="number"]').forEach(input => {
                input.addEventListener('input', function () {
                    const empId = this.dataset.empId;
                    if (!empId) return;

                    const inputs = document.querySelectorAll(`.bonus-input-${empId}`);
                    let total = 0;
                    inputs.forEach(ci => {
                        const val = parseFloat(ci.value) || 0;
                        if (ci.name.includes('[loans]')) {
                            total -= val;
                        } else if (ci.name.includes('[salary]')) {
                            total += val;
                        } else {
                            total += val;
                        }
                    });
                    document.getElementById(`total-${empId}`).textContent = new Intl.NumberFormat().format(total);
                });
            });
        });
    </script>
@endpush