@extends('layouts.admin')

@section('content')
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800">{{ __('Audit Logs') }}</h1>
            <div class="text-sm text-gray-500">{{ __('Snapshots saved on various actions') }}</div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <table class="w-full text-start">
                <thead class="bg-gray-50 text-sm font-semibold text-gray-600">
                    <tr>
                        <th class="px-6 py-4 text-start">{{ __('Context / ID') }}</th>
                        <th class="px-6 py-4 text-start">{{ __('Type') }}</th>
                        <th class="px-6 py-4 text-start">{{ __('Snapshot Data') }}</th>
                        <th class="px-6 py-4 text-start">{{ __('Action Date') }}</th>
                        <th class="px-6 py-4 text-start">{{ __('Registered By') }}</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @foreach($logs as $log)
                        <tr class="hover:bg-gray-50 transition duration-150">
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900">{{ $log->employee->arabic_name ?? __('N/A') }}
                                </div>
                                <div class="text-xs text-gray-500">{{ __('Ref ID') }}: {{ $log->emp_id }}</div>
                            </td>
                            <td class="px-6 py-4">
                                @php
                                    $typeColor = match (strtolower($log->type)) {
                                        'salary' => 'bg-green-100 text-green-700',
                                        'bonus' => 'bg-blue-100 text-blue-700',
                                        'print order' => 'bg-purple-100 text-purple-700',
                                        'add_client' => 'bg-emerald-100 text-emerald-700',
                                        'add_reservation' => 'bg-indigo-100 text-indigo-700',
                                        'delete_reservation' => 'bg-rose-100 text-rose-700',
                                        'add_receipt' => 'bg-orange-100 text-orange-700 border border-orange-200',
                                        'edit_receipt' => 'bg-amber-100 text-amber-700 border border-amber-200',
                                        'delete_receipt' => 'bg-red-100 text-red-700 border border-red-200',
                                        default => 'bg-gray-100 text-gray-700'
                                    };
                                @endphp
                                <span
                                    class="px-2 py-1 {{ $typeColor }} rounded text-[10px] font-bold uppercase whitespace-nowrap">
                                    {{ __($log->type) }}
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-xs text-gray-600 bg-gray-50 p-2 rounded">
                                    <ul class="grid grid-cols-2 gap-x-4">
                                        @if(is_array($log->snapshot))
                                            @foreach($log->snapshot as $key => $value)
                                                <li><span class="font-semibold">{{ __(str_replace('_', ' ', $key)) }}:</span>
                                                    {{ is_array($value) ? json_encode($value) : $value }}</li>
                                            @endforeach
                                        @else
                                            <li>{{ $log->snapshot }}</li>
                                        @endif
                                    </ul>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-500">
                                {{ $log->created_at }}
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-500">
                                {{ $log->registrar->name ?? 'Admin' }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $logs->links() }}
        </div>
    </div>
@endsection