@extends('layouts.admin')

@section('content')
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800">{{ __('Attendance Machine Logs') }}</h1>
            <form action="{{ route('hr.attendance') }}" method="GET" class="flex items-center space-x-2">
                <input type="date" name="from" value="{{ $from }}"
                    class="px-3 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 outline-none">
                <span class="text-gray-400">{{ __('to') }}</span>
                <input type="date" name="to" value="{{ $to }}"
                    class="px-3 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 outline-none">
                <button type="submit"
                    class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition">{{ __('Filter') }}</button>
            </form>
        </div>

        <div class="bg-white rounded-xl shadow-sm overflow-hidden border border-gray-100">
            <table class="w-full text-start">
                <thead class="bg-gray-50 border-b border-gray-100">
                    <tr>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600 text-start">{{ __('Date') }}</th>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600 text-start">{{ __('Machine ID') }}</th>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600 text-start">{{ __('Entry Time') }}</th>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600 text-start">{{ __('Exit Time') }}</th>
                        <th
                            class="px-6 py-4 text-sm font-semibold text-gray-600 {{ app()->getLocale() == 'ar' ? 'text-left' : 'text-right' }}">
                            {{ __('Working Hours') }}</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @foreach($attendance as $att)
                        @php
                            $start = \Carbon\Carbon::parse($att->enter_tm);
                            $end = \Carbon\Carbon::parse($att->exit_tm);
                            $hours = $start->diffInHours($end);
                        @endphp
                        <tr class="hover:bg-gray-50 transition duration-150">
                            <td class="px-6 py-4 text-sm text-gray-800 font-medium">{{ $att->day }}</td>
                            <td class="px-6 py-4 text-sm text-gray-600 italic">#{{ $att->machine_id }}</td>
                            <td class="px-6 py-4 text-sm text-green-600">{{ $att->enter_tm }}</td>
                            <td class="px-6 py-4 text-sm text-red-600">{{ $att->exit_tm }}</td>
                            <td class="px-6 py-4 {{ app()->getLocale() == 'ar' ? 'text-left' : 'text-right' }}">
                                <span class="px-2 py-1 bg-yellow-50 text-yellow-700 rounded text-xs font-bold font-mono">
                                    {{ $hours }}h
                                </span>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection