@extends('layouts.admin')

@section('header', 'System Overview')

@section('content')
    <div class="max-w-7xl mx-auto space-y-8">
        <!-- Quick Stats Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            @php
                $stat_items = [
                    ['label' => 'Total Clients', 'value' => $stats['clients'], 'icon' => 'M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z', 'color' => 'blue'],
                    ['label' => 'Active Projects', 'value' => $stats['projects'], 'icon' => 'M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4', 'color' => 'indigo'],
                    ['label' => 'Reservations', 'value' => $stats['reservations'], 'icon' => 'M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z', 'color' => 'green'],
                    ['label' => 'System Admins', 'value' => $stats['admins'], 'icon' => 'M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z', 'color' => 'red'],
                ];
            @endphp

            @foreach($stat_items as $item)
                <div class="bg-white p-6 rounded-3xl shadow-sm border border-gray-100 hover:shadow-md transition-shadow group">
                    <div class="flex items-center justify-between mb-4">
                        <div
                            class="p-3 bg-{{ $item['color'] }}-50 text-{{ $item['color'] }}-600 rounded-2xl group-hover:scale-110 transition-transform">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $item['icon'] }}" />
                            </svg>
                        </div>
                        <span class="text-xs font-bold text-gray-400 uppercase tracking-widest">Stats</span>
                    </div>
                    <h3 class="text-3xl font-extrabold text-gray-900 mb-1 tracking-tight">{{ number_format($item['value']) }}
                    </h3>
                    <p class="text-gray-500 font-medium">{{ $item['label'] }}</p>
                </div>
            @endforeach
        </div>

        <!-- Main Dashboard Body -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Revenue Breakdown -->
            <div class="lg:col-span-2 space-y-6">
                <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="p-8 border-b border-gray-100">
                        <h3 class="text-xl font-bold text-gray-900">Project Revenue Breakdown</h3>
                        <p class="text-gray-500 text-sm mt-1">Total accumulated receipts by project</p>
                    </div>
                    <div class="p-8">
                        <div class="space-y-6">
                            @foreach($projectRevenue as $revenue)
                                <div>
                                    <div class="flex justify-between items-center mb-2">
                                        <span
                                            class="font-bold text-gray-700">{{ $revenue->project->name ?? 'Unknown Project' }}</span>
                                        <span class="text-primary font-black">{{ number_format($revenue->total, 2) }} <span
                                                class="text-xs text-gray-400 font-normal">EGP</span></span>
                                    </div>
                                    <div class="w-full bg-gray-100 rounded-full h-2.5 overflow-hidden">
                                        @php
                                            $max = $projectRevenue->max('total') ?: 1;
                                            $width = ($revenue->total / $max) * 100;
                                        @endphp
                                        <div class="bg-gradient-to-r from-primary to-primary-dark h-full rounded-full transition-all duration-1000"
                                            style="width: {{ $width }}%"></div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

                <!-- Unit Status Grid -->
                <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="p-8 border-b border-gray-100">
                        <h3 class="text-xl font-bold text-gray-900">Unit Distribution</h3>
                        <p class="text-gray-500 text-sm mt-1">Comparision of units with and without assigned flats</p>
                    </div>
                    <div class="p-8 grid grid-cols-1 sm:grid-cols-2 gap-4">
                        @foreach($resvStats as $rStats)
                            @php $prj = \App\Models\Project::find($rStats->prj_id); @endphp
                            <div class="p-4 rounded-2xl bg-gray-50 border border-gray-100">
                                <h4 class="font-bold text-gray-800 text-sm mb-3">{{ $prj->name ?? 'Project #' . $rStats->prj_id }}
                                </h4>
                                <div class="flex items-center gap-4">
                                    <div class="flex-1">
                                        <span class="text-[10px] text-gray-400 uppercase font-black block mb-1">Assigned</span>
                                        <span class="text-lg font-bold text-green-600">{{ $rStats->with_flat }}</span>
                                    </div>
                                    <div class="w-px h-8 bg-gray-200"></div>
                                    <div class="flex-1 text-right">
                                        <span class="text-[10px] text-gray-400 uppercase font-black block mb-1">Pending</span>
                                        <span class="text-lg font-bold text-gray-600">{{ $rStats->without_flat }}</span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Sidebar Actions -->
            <div class="space-y-6">
                <div class="bg-gradient-to-br from-slate-900 to-slate-800 rounded-3xl p-8 text-white shadow-xl">
                    <h3 class="text-xl font-bold mb-4">System Actions</h3>
                    <div class="space-y-3">
                        <a href="{{ route('admin.iba.permissions') }}"
                            class="flex items-center gap-3 p-4 rounded-2xl bg-white/10 hover:bg-white/20 transition-all group">
                            <div class="p-2 bg-primary rounded-xl group-hover:rotate-12 transition-transform">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                                </svg>
                            </div>
                            <span class="font-bold">System Permissions</span>
                        </a>
                        <a href="{{ route('admin.iba.lock') }}"
                            class="flex items-center gap-3 p-4 rounded-2xl bg-white/10 hover:bg-white/20 transition-all group">
                            <div class="p-2 bg-red-500 rounded-xl group-hover:rotate-12 transition-transform">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                </svg>
                            </div>
                            <span class="font-bold">Lock Console</span>
                        </a>
                    </div>
                </div>

                <div class="bg-white rounded-3xl shadow-sm border border-gray-100 p-8">
                    <h4 class="text-sm font-black text-gray-400 uppercase tracking-widest mb-4">System Pulse</h4>
                    <div class="flex items-center gap-3 py-3 border-b border-gray-50">
                        <div class="w-2 h-2 rounded-full bg-green-500 animate-pulse"></div>
                        <span class="text-sm text-gray-600 font-medium">Database Online</span>
                    </div>
                    <div class="flex items-center gap-3 py-3 border-b border-gray-50">
                        <div class="w-2 h-2 rounded-full bg-blue-500"></div>
                        <span class="text-sm text-gray-600 font-medium">Session Secure</span>
                    </div>
                    <div class="flex items-center gap-3 py-3">
                        <div class="w-2 h-2 rounded-full bg-purple-500"></div>
                        <span class="text-sm text-gray-600 font-medium last:">Laravel {{ app()->version() }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection