@extends('layouts.admin')

@section('content')
    <div class="p-6">
        <div class="max-w-6xl mx-auto">
            <div class="flex justify-between items-center mb-6">
                <h1 class="text-2xl font-bold text-gray-800">{{ $consultant->office_name }}</h1>
                <span class="px-3 py-1 bg-green-100 text-green-700 rounded-full text-sm font-medium">Verified
                    Consultant</span>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Info Card -->
                <div class="lg:col-span-1 bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">Office Details</h3>
                    <div class="space-y-4">
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Representitive</p>
                            <p class="text-sm font-medium">{{ $consultant->arabic_name }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Mobile</p>
                            <p class="text-sm font-medium">{{ $consultant->mobile ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Project</p>
                            <p class="text-sm font-medium text-green-600">{{ $consultant->project->name ?? 'N/A' }}</p>
                        </div>
                    </div>
                </div>

                <!-- Payments Section -->
                <div class="lg:col-span-2 space-y-6">
                    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold">Payments History</h3>
                            <button onclick="document.getElementById('payment-modal').classList.remove('hidden')"
                                class="text-sm bg-blue-600 text-white px-3 py-1 rounded-md hover:bg-blue-700">+ Add
                                Payment</button>
                        </div>
                        <table class="w-full text-left">
                            <thead class="bg-gray-50 text-xs font-semibold text-gray-500 uppercase tracking-wider">
                                <tr>
                                    <th class="px-4 py-3">Date</th>
                                    <th class="px-4 py-3">Check No.</th>
                                    <th class="px-4 py-3 text-right">Amount</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100 italic">
                                @forelse($consultant->payments as $pay)
                                    <tr>
                                        <td class="px-4 py-3 text-sm">{{ $pay->chk_date }}</td>
                                        <td class="px-4 py-3 text-sm">{{ $pay->chk_num }}</td>
                                        <td class="px-4 py-3 text-sm text-right font-semibold text-blue-600">
                                            {{ number_format($pay->amount) }} EGP</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="px-4 py-8 text-center text-gray-400">No payments recorded yet.
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment Modal -->
    <div id="payment-modal" class="hidden fixed inset-0 bg-black/50 backdrop-blur-sm flex items-center justify-center z-50">
        <div class="bg-white rounded-xl p-8 max-w-md w-full mx-4">
            <h2 class="text-xl font-bold mb-4">Add Consultant Payment</h2>
            <form action="{{ route('admin.consult.payments.store', $consultant->cons_id) }}" method="POST">
                @csrf
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium mb-1">Amount</label>
                        <input type="number" name="amount"
                            class="w-full px-3 py-2 border rounded-lg outline-none focus:ring-2 focus:ring-blue-500"
                            required>
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">Check Date</label>
                        <input type="text" name="chk_date" placeholder="DD-MM-YYYY"
                            class="w-full px-3 py-2 border rounded-lg outline-none focus:ring-2 focus:ring-blue-500"
                            required>
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">Check Number</label>
                        <input type="text" name="chk_num"
                            class="w-full px-3 py-2 border rounded-lg outline-none focus:ring-2 focus:ring-blue-500"
                            required>
                    </div>
                </div>
                <div class="mt-6 flex justify-end space-x-2">
                    <button type="button" onclick="document.getElementById('payment-modal').classList.add('hidden')"
                        class="px-4 py-2 text-gray-600">Cancel</button>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg">Save Payment</button>
                </div>
            </form>
        </div>
    </div>
@endsection