@extends('layouts.admin')

@section('content')
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800">Consulting Offices</h1>
            <a href="{{ route('admin.consult.create') }}"
                class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg transition duration-200">
                + Add New Consultant
            </a>
        </div>

        <div class="bg-white rounded-xl shadow-sm overflow-hidden border border-gray-100">
            <table class="w-full text-left">
                <thead class="bg-gray-50 border-b border-gray-100">
                    <tr>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600">Office Name</th>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600">Representitive</th>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600">Mobile</th>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600">Project</th>
                        <th class="px-6 py-4 text-sm font-semibold text-gray-600 text-right">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100 italic">
                    @foreach($consultants as $con)
                        <tr class="hover:bg-gray-50 transition duration-150">
                            <td class="px-6 py-4 text-sm text-gray-800 font-medium">{{ $con->office_name }}</td>
                            <td class="px-6 py-4 text-sm text-gray-600">{{ $con->arabic_name }}</td>
                            <td class="px-6 py-4 text-sm text-gray-600">{{ $con->mobile }}</td>
                            <td class="px-6 py-4 text-sm">
                                <span class="px-2 py-1 bg-green-50 text-green-700 rounded-md text-xs font-medium">
                                    {{ $con->project->name ?? 'N/A' }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <a href="{{ route('admin.consult.show', $con->cons_id) }}"
                                    class="text-blue-600 hover:text-blue-800 font-medium mr-3">View</a>
                                <button class="text-red-600 hover:text-red-800 font-medium">Deactivate</button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection