@extends('layouts.admin')

@section('content')
<div class="max-w-7xl mx-auto space-y-6" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">
    <!-- Client Info Card -->
    <div class="bg-white rounded-2xl shadow-xl border border-emerald-100 overflow-hidden">
        <div class="bg-gradient-to-r from-emerald-600 to-teal-600 p-6 flex justify-between items-center text-white">
            <div>
                <h2 class="text-2xl font-bold">{{ __('Client Reservations') }}</h2>
                <p class="text-emerald-50 text-sm mt-1">
                    <span class="font-bold">{{ $client->arabic_name }}</span> 
                    <span class="mx-2 opacity-50">|</span> 
                    {{ __('Membership No:') }} {{ $client->old_member_no }}
                    <span class="mx-2 opacity-50">|</span> 
                    {{ __('File No:') }} {{ $client->file_no }}
                </p>
            </div>
            <div class="flex gap-2 text-xs">
                @if($client->action == 'on')
                    <span class="px-3 py-1 bg-red-500/20 rounded-full border border-red-400/30 font-bold uppercase">{{ __('File Closed') }}</span>
                @endif
            </div>
        </div>

        <div class="p-8">
            <h3 class="text-lg font-bold text-gray-800 mb-6 flex items-center">
                <i class="entypo-home text-emerald-500 mr-2 text-xl"></i> {{ __('Unit Reservations') }}
            </h3>

            <div class="grid grid-cols-1 gap-6">
                @forelse($data as $item)
                    @php 
                        $res = $item['res'];
                        $pending = $item['pending'];
                        $isPhase1 = ($res->sess == '1');
                    @endphp
                    <div class="bg-gray-50 rounded-2xl border border-gray-100 p-6 relative overflow-hidden group hover:shadow-md transition-shadow">
                        <!-- Unit Header Info -->
                        <div class="flex flex-wrap justify-between items-start mb-6 gap-4">
                            <div class="space-y-1">
                                <div class="text-xs font-bold text-emerald-600 uppercase tracking-widest">{{ $res->project_name }}</div>
                                <div class="text-xl font-black text-gray-900">
                                    {{ __('Building') }} {{ $res->bldg_id }} <span class="mx-2 text-gray-300">/</span> {{ __('Unit') }} {{ $res->flat_num }} {{ $res->flt_order }}
                                </div>
                                <div class="text-sm text-gray-500 font-medium">
                                    {{ $res->flat_txt }} <span class="mx-1 text-gray-300">•</span> {{ __('Floor') }} {{ $res->floor }}
                                </div>
                            </div>

                            <div class="flex gap-2">
                                @if($pending)
                                    <div class="px-4 py-2 bg-amber-50 border border-amber-200 rounded-xl text-amber-700 text-xs font-bold text-center">
                                        <i class="entypo-clock"></i> {{ __('PENDING') }}
                                        <div class="text-[10px] opacity-75">{{ $pending->cl_to ? __('TRANSFER') : __('REFUND') }}</div>
                                    </div>
                                @endif
                                
                                @if($isPhase1)
                                    <div class="px-4 py-2 bg-blue-50 border border-blue-200 rounded-xl text-blue-700 text-xs font-bold flex items-center">
                                        {{ __('PHASE 1') }}
                                    </div>
                                @endif
                            </div>
                        </div>

                        <!-- Financial Summary -->
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-8">
                            <div class="bg-white p-4 rounded-xl border border-gray-200">
                                <span class="text-[10px] font-bold text-gray-400 uppercase tracking-wider block mb-1">{{ __('Required Total') }}</span>
                                <span class="text-lg font-black text-gray-800">{{ number_format($item['required'], 2) }}</span>
                            </div>
                            <div class="bg-white p-4 rounded-xl border border-gray-200">
                                <span class="text-[10px] font-bold text-emerald-400 uppercase tracking-wider block mb-1">{{ __('Total Paid') }}</span>
                                <span class="text-lg font-black text-emerald-600">{{ number_format($item['paid'], 2) }}</span>
                            </div>
                            <div class="bg-white p-4 rounded-xl border border-gray-200 shadow-inner">
                                <span class="text-[10px] font-bold text-red-400 uppercase tracking-wider block mb-1">{{ __('Remaining Balance') }}</span>
                                <span class="text-lg font-black text-red-600">{{ number_format($item['remaining'], 2) }}</span>
                            </div>
                        </div>

                        <!-- Action Bar -->
                        <div class="flex flex-wrap gap-2 pt-4 border-t border-dashed border-gray-200">
                            <!-- Transfer Group -->
                            <button onclick="openTransferSavingsModal({{ $res->prj_id }}, '{{ $res->flat_txt }}', {{ $item['paid'] }})" class="bg-white border border-gray-200 text-gray-700 px-3 py-2 rounded-lg text-xs font-bold hover:bg-emerald-50 hover:border-emerald-200 transition-all">
                                <i class="entypo-pencil mr-1"></i> {{ __('Transfer Req.') }}
                            </button>
                            <button onclick="openTransferSavingsModal({{ $res->prj_id }}, '{{ $res->flat_txt }}', {{ $item['paid'] }})" class="bg-white border border-gray-200 text-gray-700 px-3 py-2 rounded-lg text-xs font-bold hover:bg-emerald-50 hover:border-emerald-200 transition-all">
                                <i class="entypo-pencil mr-1"></i> {{ __('Transfer Savings') }}
                            </button>
                            <button onclick="openWithdrawSavingsModal({{ $res->prj_id }}, '{{ $res->flat_txt }}', {{ $item['paid'] }})" class="bg-white border border-gray-200 text-gray-700 px-3 py-2 rounded-lg text-xs font-bold hover:bg-emerald-50 hover:border-emerald-200 transition-all">
                                <i class="entypo-pencil mr-1"></i> {{ __('Withdraw Savings') }}
                            </button>

                            <div class="flex-grow"></div>

                            <!-- Management Group -->
                            @if(!$pending)
                                @if($res->sess != '0') <!-- If modification allowed -->
                                    <button onclick="openEditUnitModal('{{ $res->prj_id }}', '{{ $res->bldg_id }}', '{{ $res->flat_num }}', '{{ $res->floor }}')" class="bg-sky-50 text-sky-700 px-3 py-2 rounded-lg text-xs font-bold hover:bg-sky-100 transition-all flex items-center">
                                        <i class="entypo-pencil mr-1 text-sm"></i> {{ __('Edit Unit') }}
                                    </button>
                                    <button onclick="openAddParkingModal({{ $res->prj_id }})" class="bg-emerald-50 text-emerald-700 px-3 py-2 rounded-lg text-xs font-bold hover:bg-emerald-100 transition-all flex items-center">
                                        <i class="entypo-plus mr-1 text-sm"></i> {{ __('Add Parking') }}
                                    </button>
                                    <button onclick="openAddGardenModal({{ $res->prj_id }})" class="bg-blue-50 text-blue-700 px-3 py-2 rounded-lg text-xs font-bold hover:bg-blue-100 transition-all flex items-center">
                                        <i class="entypo-plus mr-1 text-sm"></i> {{ __('Add Garden') }}
                                    </button>
                                    <button onclick="openAddRoofModal({{ $res->prj_id }})" class="bg-indigo-50 text-indigo-700 px-3 py-2 rounded-lg text-xs font-bold hover:bg-indigo-100 transition-all flex items-center">
                                        <i class="entypo-plus mr-1 text-sm"></i> {{ __('Add Roof') }}
                                    </button>
                                    <button onclick="deleteUnit('{{ $res->prj_id }}', '{{ $res->bldg_id }}', '{{ $res->flat_num }}')" class="bg-rose-50 text-rose-700 px-3 py-2 rounded-lg text-xs font-bold hover:bg-rose-100 transition-all flex items-center scale-95 group-hover:scale-100 origin-right duration-300">
                                        <i class="entypo-trash mr-1 text-sm"></i> {{ __('Delete Unit') }}
                                    </button>
                                @endif

                                <!-- State Transitions -->
                                <div class="flex gap-2 ml-4 pl-4 border-l border-gray-200">
                                    <button onclick="openTransferRequestModal({{ $res->prj_id }}, '{{ $res->flat_txt }}')" class="bg-white border border-indigo-200 text-indigo-700 px-3 py-2 rounded-lg text-xs font-bold hover:bg-indigo-50 transition-all">
                                        {{ __('Request Transfer') }}
                                    </button>
                                    <button onclick="openRefundRequestModal({{ $res->prj_id }}, '{{ $res->flt_id }}')" class="bg-white border border-orange-200 text-orange-700 px-3 py-2 rounded-lg text-xs font-bold hover:bg-orange-50 transition-all">
                                        {{ __('Request Refund') }}
                                    </button>
                                </div>
                            @else
                                <!-- Move/Refund Review Actions -->
                                <div class="flex gap-2">
                                    <button onclick="approveRequest({{ $pending->id }})" class="bg-emerald-600 text-white px-4 py-2 rounded-lg text-xs font-bold hover:bg-emerald-700 transition-all">
                                        <i class="entypo-check mr-1"></i> {{ __('Approve') }}
                                    </button>
                                    <button onclick="cancelRequest({{ $pending->id }})" class="bg-red-600 text-white px-4 py-2 rounded-lg text-xs font-bold hover:bg-red-700 transition-all">
                                        <i class="entypo-cancel mr-1"></i> {{ __('Cancel Request') }}
                                    </button>
                                </div>
                            @endif
                        </div>
                    </div>
                @empty
                    <div class="py-20 text-center bg-gray-50 rounded-2xl border border-gray-100">
                        <i class="entypo-home text-4xl text-gray-300 block mb-2"></i>
                        <span class="text-gray-400 italic">{{ __('No active unit reservations found.') }}</span>
                    </div>
                @endforelse
            </div>

            <!-- Garden Section -->
            @if(count($gardens) > 0)
                <div class="mt-12 space-y-6">
                    <h3 class="text-lg font-bold text-gray-800 flex items-center">
                        <i class="entypo-leaf text-green-500 mr-2 text-xl"></i> {{ __('Garden Assignments') }}
                    </h3>

                    <div class="bg-white rounded-2xl border border-gray-100 overflow-hidden shadow-sm">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr class="text-[10px] font-bold text-gray-500 uppercase tracking-widest text-center">
                                    <th class="px-6 py-3">#</th>
                                    <th class="px-6 py-3 text-left">{{ __('Project') }}</th>
                                    <th class="px-6 py-3">{{ __('Building') }}</th>
                                    <th class="px-6 py-3">{{ __('Unit No.') }}</th>
                                    <th class="px-6 py-3">{{ __('Garden Area (m2)') }}</th>
                                    <th class="px-6 py-3">{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100">
                                @foreach($gardens as $index => $garden)
                                    <tr class="hover:bg-green-50/30 transition-colors text-center">
                                        <td class="px-6 py-4 text-sm font-medium text-gray-400">{{ $index + 1 }}</td>
                                        <td class="px-6 py-4 text-sm font-bold text-gray-800 text-left">{{ $garden->project_name }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-600 font-medium">{{ $garden->bldg_id }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-600 font-medium">{{ $garden->flat_num }}</td>
                                        <td class="px-6 py-4">
                                            <span class="px-3 py-1 bg-green-100 text-green-700 rounded-full text-sm font-black">
                                                {{ $garden->garden_size }} m²
                                            </span>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="flex justify-center gap-2">
                                                <button onclick="openEditGardenModal({{ $garden->resv_id }}, '{{ $garden->garden_size }}', '{{ $garden->bldg_id }}', '{{ $garden->flat_num }}')" 
                                                        class="inline-flex items-center gap-1 px-3 py-1 bg-amber-50 text-amber-700 rounded-lg text-xs font-bold hover:bg-amber-100 transition-all border border-amber-200" title="{{ __('Edit') }}">
                                                    <i class="entypo-pencil"></i>
                                                    <span>{{ __('Edit') }}</span>
                                                </button>
                                                <button type="button" 
                                                        class="delete-garden-btn inline-flex items-center gap-1 px-3 py-1 bg-red-50 text-red-700 rounded-lg text-xs font-bold hover:bg-red-100 transition-all border border-red-200" 
                                                        data-resv-id="{{ $garden->resv_id }}"
                                                        title="{{ __('Delete') }}">
                                                    <i class="entypo-trash"></i>
                                                    <span>{{ __('Delete') }}</span>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @endif

            <!-- Parking Section -->
            @if($parking->isNotEmpty())
                <div class="mt-12 space-y-6">
                    <h3 class="text-lg font-bold text-gray-800 flex items-center">
                        <i class="entypo-clipboard text-blue-500 mr-2 text-xl"></i> {{ __('Parking Reservations') }}
                    </h3>

                    <div class="bg-white rounded-2xl border border-gray-100 overflow-hidden shadow-sm">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr class="text-[10px] font-bold text-gray-500 uppercase tracking-widest text-center">
                                    <th class="px-6 py-3">#</th>
                                    <th class="px-6 py-3 text-left">{{ __('Project') }}</th>
                                    <th class="px-6 py-3">{{ __('Building') }}</th>
                                    <th class="px-6 py-3">{{ __('Parking No.') }}</th>
                                    <th class="px-6 py-3">{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100">
                                @foreach($parking as $index => $park)
                                    <tr class="hover:bg-blue-50/30 transition-colors text-center">
                                        <td class="px-6 py-4 text-sm font-medium text-gray-400">{{ $index + 1 }}</td>
                                        <td class="px-6 py-4 text-sm font-bold text-gray-800 text-left">{{ $park->project_name }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-600 font-medium">{{ $park->bldg }}</td>
                                        <td class="px-6 py-4">
                                            <input type="text" value="{{ $park->park_no }}" 
                                                   class="w-24 text-center border-gray-200 rounded-lg text-sm font-black text-gray-700 focus:ring-blue-500 bg-gray-50 hover:bg-white transition-all disabled:bg-gray-100" 
                                                   disabled>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="flex justify-center gap-2">
                                                <button onclick="openEditParkingModal({{ $park->id }}, '{{ $park->bldg }}', '{{ $park->park_no }}')" 
                                                        class="inline-flex items-center gap-1 px-3 py-1 bg-amber-50 text-amber-700 rounded-lg text-xs font-bold hover:bg-amber-100 transition-all border border-amber-200" title="{{ __('Edit') }}">
                                                    <i class="entypo-pencil"></i>
                                                    <span>{{ __('Edit') }}</span>
                                                </button>
                                                <button type="button" 
                                                        class="delete-parking-btn inline-flex items-center gap-1 px-3 py-1 bg-red-50 text-red-700 rounded-lg text-xs font-bold hover:bg-red-100 transition-all border border-red-200" 
                                                        data-id="{{ $park->id }}"
                                                        title="{{ __('Delete') }}">
                                                    <i class="entypo-trash"></i>
                                                    <span>{{ __('Delete') }}</span>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Modals -->
@include('admin.clients.modals.reservation_actions')

<!-- Hidden Forms for Actions -->
<form id="delete-garden-form" action="{{ route('clients.reservations.delete_garden') }}" method="POST" style="display: none;">
    @csrf
    <input type="hidden" name="resv_id" id="delete_garden_id">
</form>

<form id="delete-parking-form" method="POST" style="display: none;">
    @csrf
    @method('DELETE')
</form>

@endsection

@push('scripts')
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script>
    function openTransferRequestModal(prj_id, flat_txt) {
        $('#transfer_prj_id').val(prj_id);
        $('#transfer_flat_txt').text(flat_txt);
        $('#transferModal').removeClass('hidden');
    }

    function openRefundRequestModal(prj_id, flt_id) {
        $('#refund_prj_id').val(prj_id);
        $('#refund_flt_id').val(flt_id);
        // Load receipts for selection
        $.post("{{ route('clients.receipts.get_data') }}", {
            _token: "{{ csrf_token() }}",
            cl_id: "{{ $client->cl_id }}",
            prj_id: prj_id
        }, function(data) {
            let html = '';
            data.receipts.forEach(r => {
                html += `
                    <label class="flex items-center space-x-3 p-3 bg-gray-50 rounded-lg cursor-pointer hover:bg-gray-100 transition">
                        <input type="checkbox" name="recs[]" value="${r.id}" class="form-checkbox h-5 w-5 text-emerald-600 rounded">
                        <div class="flex-grow">
                            <div class="text-sm font-bold text-gray-800">#${r.number}</div>
                            <div class="text-xs text-gray-500">${r.date} • ${r.value} EGP</div>
                        </div>
                    </label>
                `;
            });
            $('#receipts_list').html(html);
        });
        $('#refundModal').removeClass('hidden');
    }

    function openEditUnitModal(prj_id, bldg_id, flat_num, floor) {
        $('#edit_prj_id').val(prj_id);
        $('#edit_old_bldg').val(bldg_id);
        $('#edit_old_flat').val(flat_num);
        $('#edit_bldg_id').val(bldg_id);
        $('#edit_flat_num').val(flat_num);
        $('#edit_floor').val(floor);
        $('#editUnitModal').removeClass('hidden');
    }

    function deleteUnit(prj_id, bldg_id, flat_num) {
        if (confirm('{{ __("Are you sure you want to delete this unit reservation?") }}')) {
            $.ajax({
                url: "{{ route('clients.reservations.delete') }}",
                type: 'DELETE',
                data: {
                    _token: "{{ csrf_token() }}",
                    prj_id: prj_id,
                    bldg_id: bldg_id,
                    flat_num: flat_num
                },
                success: function(response) {
                    location.reload();
                }
            });
        }
    }

    function approveRequest(id) {
        $.post("{{ route('clients.pending.process') }}", {
            _token: "{{ csrf_token() }}",
            id: id
        }, function(response) {
            location.reload();
        });
    }

    function cancelRequest(id) {
        if (confirm('{{ __("Cancel this request?") }}')) {
            $.ajax({
                url: "{{ route('website.reject_request') }}",
                type: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    id: id
                },
                success: function(response) {
                    location.reload();
                }
            });
        }
    }

    function openTransferSavingsModal(prj_id, flat_txt, base_amount) {
        $('#savings_prj_id').val(prj_id);
        $('#savings_base_amount').val(base_amount);
        $('#transferSavingsModal').removeClass('hidden');
    }

    function openWithdrawSavingsModal(prj_id, flat_txt, base_amount) {
        $('#withdraw_prj_id').val(prj_id);
        $('#withdraw_amount').val(base_amount);
        $('#withdrawSavingsModal').removeClass('hidden');
    }

    function openAddParkingModal(prj_id) {
        $('#park_prj_id').val(prj_id);
        $('#addParkingModal').removeClass('hidden');
    }

    function openEditParkingModal(id, bldg, park_no) {
        $('#edit_park_id').val(id);
        $('#edit_park_bldg').val(bldg);
        $('#edit_park_no').val(park_no);
        $('#editParkingModal').removeClass('hidden');
    }

    function openAddGardenModal(prj_id) {
        $('#garden_prj_id').val(prj_id);
        $('#addGardenModal').removeClass('hidden');
    }

    function openEditGardenModal(resv_id, garden_size, bldg_id, flat_num) {
        $('#edit_garden_resv_id').val(resv_id);
        $('#edit_garden_size').val(garden_size);
        $('#edit_garden_bldg').text(bldg_id);
        $('#edit_garden_flat').text(flat_num);
        $('#editGardenModal').removeClass('hidden');
    }

    function openAddRoofModal(prj_id) {
        $('#roof_prj_id').val(prj_id);
        $('#addRoofModal').removeClass('hidden');
    }

    // Modal Closing Logic
    window.onclick = function(event) {
        if ($(event.target).hasClass('modal-bg')) {
            $('.fixed.inset-0').addClass('hidden');
        }
    }
    
    function closeModal(id) {
        $('#' + id).addClass('hidden');
    }

    // jQuery Event Listeners for Delete Actions
    $(document).ready(function() {
        console.log('Reservations page script loaded');

        let targetDeleteForm = null;

        $(document).ready(function() {
            // Setup Modal confirm click
            $('#confirmDeleteBtn').on('click', function() {
                if (targetDeleteForm) {
                    console.log('Confirmed delete via Modal. Submitting form...');
                    targetDeleteForm.submit();
                }
            });
        });

        $(document).on('click', '.delete-garden-btn', function(e) {
            e.preventDefault();
            const resv_id = $(this).data('resv-id');
            console.log('Delete garden clicked for ID:', resv_id);

            // Prepare form
            $('#delete_garden_id').val(resv_id);
            targetDeleteForm = $('#delete-garden-form');

            // Show modal
            $('#deleteConfirmTitle').text('{{ __("Delete Garden Appointment") }}');
            $('#deleteConfirmMessage').text('{{ __("Are you sure you want to remove the garden assignment from this unit?") }}');
            $('#deleteConfirmModal').removeClass('hidden');
        });

        $(document).on('click', '.delete-parking-btn', function(e) {
            e.preventDefault();
            const id = $(this).data('id');
            console.log('Delete parking clicked for ID:', id);

            // Prepare form
            let deleteUrl = "{{ route('clients.parking.delete', ['id' => ':id']) }}".replace(':id', id);
            $('#delete-parking-form').attr('action', deleteUrl);
            targetDeleteForm = $('#delete-parking-form');

             // Show modal
            $('#deleteConfirmTitle').text('{{ __("Delete Parking Reservation") }}');
            $('#deleteConfirmMessage').text('{{ __("Are you sure you want to delete this parking reservation?") }}');
            $('#deleteConfirmModal').removeClass('hidden');
        });
    });
</script>
@endpush
