<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <title>{{ __('Print Check') }}</title>
    <style>
        body {
            font-family: 'Tahoma', sans-serif;
            font-size: 14px;
            margin: 0;
            padding: 20px;
        }

        .check-container {
            width: 800px;
            height: 350px;
            border: 1px solid #ccc;
            padding: 20px;
            margin: 0 auto;
            position: relative;
        }

        .date {
            position: absolute;
            top: 50px;
            right: 50px;
        }

        .value {
            position: absolute;
            top: 50px;
            left: 50px;
            border: 1px solid #000;
            padding: 5px 10px;
            font-weight: bold;
        }

        .pay-to {
            position: absolute;
            top: 120px;
            right: 100px;
            width: 600px;
        }

        .amount-text {
            position: absolute;
            top: 160px;
            right: 100px;
            width: 600px;
        }

        .bank-name {
            position: absolute;
            bottom: 50px;
            left: 50px;
        }

        @media print {
            .no-print {
                display: none;
            }

            .check-container {
                border: none;
            }
        }
    </style>
</head>

<body onload="window.print()">
    <div class="no-print" style="text-align: center; margin-bottom: 20px;">
        <button onclick="window.print()">{{ __('Print') }}</button>
        <button onclick="window.close()">{{ __('Close') }}</button>
    </div>

    <div class="check-container">
        <div class="date">{{ $date }}</div>
        <div class="value"># {{ number_format($value, 2) }} #</div>
        <div class="pay-to">{{ __('Pay to the order of') }}: {{ $name }}</div>
        <div class="amount-text">{{ __('The sum of') }}: {{ $tafqit }}</div>
        <div class="bank-name">{{ $bank_name }}</div>
    </div>
</body>

</html>